/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.nls;

import org.assertj.core.api.Assertions;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.nls.NlsSupport;
import org.eclipse.wb.internal.core.nls.bundle.pure.direct.DirectSource;
import org.eclipse.wb.internal.core.nls.bundle.pure.field.FieldSource;
import org.eclipse.wb.internal.core.nls.model.AbstractSource;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.core.nls.AbstractNlsTest;
import org.eclipse.wb.tests.designer.core.nls.NlsTestUtils;
import org.junit.jupiter.api.Test;

public class SourceAbstractSpecialTest
extends AbstractNlsTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_parseErrors() throws Exception {
        this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    getContentPane().add(new JButton(), BorderLayout.NORTH);", "  }", "}");
        SourceAbstractSpecialTest.assertEquals((int)0, (int)this.m_lastState.getBadParserNodes().nodes().size());
    }

    @Test
    public void test_replace_toStringLiteral() throws Exception {
        SourceAbstractSpecialTest.setFileContentSrc("test/messages.properties", SourceAbstractSpecialTest.getSourceDQ("frame.title=My JFrame", "frame.name=My name"));
        SourceAbstractSpecialTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  private static final ResourceBundle m_bundle = ResourceBundle.getBundle('test.messages'); //$NON-NLS-1$", "  public Test() {", "    setTitle(m_bundle.getString('frame.title')); //$NON-NLS-1$", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        AbstractSource[] sources = support.getSources();
        SourceAbstractSpecialTest.assertEquals((int)1, (int)sources.length);
        FieldSource fieldSource = (FieldSource)sources[0];
        GenericProperty titleProperty = (GenericProperty)frame.getPropertyByTitle("title");
        fieldSource.replace_toStringLiteral(titleProperty, "my title");
        this.assertEditor("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  private static final ResourceBundle m_bundle = ResourceBundle.getBundle('test.messages'); //$NON-NLS-1$", "  public Test() {", "    setTitle('my title');", "  }", "}");
        String newProperties = SourceAbstractSpecialTest.getFileContentSrc("test/messages.properties");
        SourceAbstractSpecialTest.assertTrue((boolean)newProperties.contains("frame.title=My JFrame"));
        SourceAbstractSpecialTest.assertTrue((boolean)newProperties.contains("frame.name=My name"));
    }

    @Test
    public void test_replace_externalizedSourceKey_1() throws Exception {
        String properties = SourceAbstractSpecialTest.getSource("frame.title=My JFrame", "frame.name=My name");
        SourceAbstractSpecialTest.setFileContentSrc("test/messages.properties", properties);
        SourceAbstractSpecialTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  private static final ResourceBundle m_bundle = ResourceBundle.getBundle('test.messages'); //$NON-NLS-1$", "  public Test() {", "    setTitle(ResourceBundle.getBundle('test.messages').getString('frame.title')); //$NON-NLS-1$ //$NON-NLS-2$", "    setName(m_bundle.getString('frame.name')); //$NON-NLS-1$", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        AbstractSource[] sources = support.getSources();
        SourceAbstractSpecialTest.assertEquals((int)2, (int)sources.length);
        DirectSource directSource = (DirectSource)sources[1];
        SourceAbstractSpecialTest.assertInstanceOf(FieldSource.class, (Object)sources[0]);
        GenericProperty titleProperty = (GenericProperty)frame.getPropertyByTitle("title");
        directSource.useKey(titleProperty, "frame.name");
        this.assertEditor("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  private static final ResourceBundle m_bundle = ResourceBundle.getBundle('test.messages'); //$NON-NLS-1$", "  public Test() {", "    setTitle(ResourceBundle.getBundle('test.messages').getString('frame.name')); //$NON-NLS-1$ //$NON-NLS-2$", "    setName(m_bundle.getString('frame.name')); //$NON-NLS-1$", "  }", "}");
        SourceAbstractSpecialTest.assertEquals((Object)properties, (Object)SourceAbstractSpecialTest.getFileContentSrc("test/messages.properties"));
    }

    @Test
    public void test_replace_externalizedSourceKey_2() throws Exception {
        String properties = SourceAbstractSpecialTest.getSource("frame.title=My JFrame", "frame.name=My name");
        SourceAbstractSpecialTest.setFileContentSrc("test/messages.properties", properties);
        SourceAbstractSpecialTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  private static final ResourceBundle m_bundle = ResourceBundle.getBundle('test.messages'); //$NON-NLS-1$", "  public Test() {", "    setTitle(ResourceBundle.getBundle('test.messages').getString('frame.title')); //$NON-NLS-1$ //$NON-NLS-2$", "    setName(m_bundle.getString('frame.name')); //$NON-NLS-1$", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        AbstractSource[] sources = support.getSources();
        SourceAbstractSpecialTest.assertEquals((int)2, (int)sources.length);
        SourceAbstractSpecialTest.assertInstanceOf(DirectSource.class, (Object)sources[1]);
        FieldSource fieldSource = (FieldSource)sources[0];
        GenericProperty titleProperty = (GenericProperty)frame.getPropertyByTitle("title");
        fieldSource.useKey(titleProperty, "frame.name");
        this.assertEditor("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  private static final ResourceBundle m_bundle = ResourceBundle.getBundle('test.messages'); //$NON-NLS-1$", "  public Test() {", "    setTitle(m_bundle.getString('frame.name')); //$NON-NLS-1$", "    setName(m_bundle.getString('frame.name')); //$NON-NLS-1$", "  }", "}");
        SourceAbstractSpecialTest.assertEquals((Object)properties, (Object)SourceAbstractSpecialTest.getFileContentSrc("test/messages.properties"));
    }

    @Test
    public void test_replace_externalizedSourceKey_3() throws Exception {
        String properties = SourceAbstractSpecialTest.getSource("frame.title=My JFrame", "frame.name=My name");
        SourceAbstractSpecialTest.setFileContentSrc("test/messages.properties", properties);
        SourceAbstractSpecialTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  private static final ResourceBundle m_bundle = ResourceBundle.getBundle('test.messages'); //$NON-NLS-1$", "  public Test() {", "    setTitle('Some title');", "    setName(m_bundle.getString('frame.name')); //$NON-NLS-1$", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        AbstractSource[] sources = support.getSources();
        SourceAbstractSpecialTest.assertEquals((int)1, (int)sources.length);
        FieldSource fieldSource = (FieldSource)sources[0];
        GenericProperty titleProperty = (GenericProperty)frame.getPropertyByTitle("title");
        fieldSource.useKey(titleProperty, "frame.name");
        this.assertEditor("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  private static final ResourceBundle m_bundle = ResourceBundle.getBundle('test.messages'); //$NON-NLS-1$", "  public Test() {", "    setTitle(m_bundle.getString('frame.name')); //$NON-NLS-1$", "    setName(m_bundle.getString('frame.name')); //$NON-NLS-1$", "  }", "}");
        SourceAbstractSpecialTest.assertEquals((Object)properties, (Object)SourceAbstractSpecialTest.getFileContentSrc("test/messages.properties"));
    }

    @Test
    public void test_replace_externalizedSourceKey_4() throws Exception {
        String properties = SourceAbstractSpecialTest.getSource("frame.title=My JFrame", "frame.name=My name");
        SourceAbstractSpecialTest.setFileContentSrc("test/messages.properties", properties);
        SourceAbstractSpecialTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  private static final ResourceBundle m_bundle = ResourceBundle.getBundle('test.messages'); //$NON-NLS-1$", "  public Test() {", "    setName(m_bundle.getString('frame.name')); //$NON-NLS-1$", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        AbstractSource[] sources = support.getSources();
        SourceAbstractSpecialTest.assertEquals((int)1, (int)sources.length);
        FieldSource fieldSource = (FieldSource)sources[0];
        GenericProperty titleProperty = (GenericProperty)frame.getPropertyByTitle("title");
        fieldSource.useKey(titleProperty, "frame.name");
        this.assertEditor("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  private static final ResourceBundle m_bundle = ResourceBundle.getBundle('test.messages'); //$NON-NLS-1$", "  public Test() {", "    setTitle(m_bundle.getString('frame.name')); //$NON-NLS-1$", "    setName(m_bundle.getString('frame.name')); //$NON-NLS-1$", "  }", "}");
        SourceAbstractSpecialTest.assertEquals((Object)properties, (Object)SourceAbstractSpecialTest.getFileContentSrc("test/messages.properties"));
    }

    @Test
    public void test_replace_externalizedSourceKey_5() throws Exception {
        String properties = SourceAbstractSpecialTest.getSource("frame.title=My JFrame", "frame.name=My name");
        SourceAbstractSpecialTest.setFileContentSrc("test/messages.properties", properties);
        SourceAbstractSpecialTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  private static final ResourceBundle m_bundle = ResourceBundle.getBundle('test.messages'); //$NON-NLS-1$", "  public Test() {", "    setTitle(m_bundle.getString('frame.title')); //$NON-NLS-1$", "    setName(m_bundle.getString('frame.name')); //$NON-NLS-1$", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        AbstractSource[] sources = support.getSources();
        SourceAbstractSpecialTest.assertEquals((int)1, (int)sources.length);
        FieldSource fieldSource = (FieldSource)sources[0];
        GenericProperty titleProperty = (GenericProperty)frame.getPropertyByTitle("title");
        fieldSource.useKey(titleProperty, "frame.name");
        this.assertEditor("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  private static final ResourceBundle m_bundle = ResourceBundle.getBundle('test.messages'); //$NON-NLS-1$", "  public Test() {", "    setTitle(m_bundle.getString('frame.name')); //$NON-NLS-1$", "    setName(m_bundle.getString('frame.name')); //$NON-NLS-1$", "  }", "}");
        SourceAbstractSpecialTest.assertEquals((Object)properties, (Object)SourceAbstractSpecialTest.getFileContentSrc("test/messages.properties"));
    }

    @Test
    public void test_replace_externalizedSourceKey_6() throws Exception {
        m_testProject.addPlugin("org.eclipse.osgi");
        NlsTestUtils.create_EclipseModern_AccessorAndProperties();
        String accessor = SourceAbstractSpecialTest.getFileContentSrc("test/Messages.java");
        String properties = SourceAbstractSpecialTest.getFileContentSrc("test/messages.properties");
        String[] lines1 = new String[]{"public class Test extends JFrame {", "  public Test() {", "    setTitle(Messages.frame_title);", "  }", "}"};
        ContainerInfo frame = this.parseContainer(lines1);
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        AbstractSource fieldSource = support.getSources()[0];
        GenericProperty nameProperty = (GenericProperty)frame.getPropertyByTitle("name");
        fieldSource.useKey(nameProperty, "frame_name");
        String[] lines = new String[]{"public class Test extends JFrame {", "  public Test() {", "    setName(Messages.frame_name);", "    setTitle(Messages.frame_title);", "  }", "}"};
        this.assertEditor(lines);
        SourceAbstractSpecialTest.assertEquals((Object)accessor, (Object)SourceAbstractSpecialTest.getFileContentSrc("test/Messages.java"));
        SourceAbstractSpecialTest.assertEquals((Object)properties, (Object)SourceAbstractSpecialTest.getFileContentSrc("test/messages.properties"));
    }

    @Test
    public void test_useKey() throws Exception {
        SourceAbstractSpecialTest.setFileContentSrc("test/messages.properties", SourceAbstractSpecialTest.getSourceDQ("frame.title=My JFrame", "frame.name=My name"));
        SourceAbstractSpecialTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  private static final ResourceBundle m_bundle = ResourceBundle.getBundle('test.messages'); //$NON-NLS-1$", "  public Test() {", "    setName(m_bundle.getString('frame.name')); //$NON-NLS-1$", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        Object[] sources = support.getSources();
        Assertions.assertThat((Object[])sources).hasSize(1);
        FieldSource fieldSource = (FieldSource)sources[0];
        GenericProperty titleProperty = (GenericProperty)frame.getPropertyByTitle("title");
        fieldSource.useKey(titleProperty, "frame.title");
        this.assertEditor("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  private static final ResourceBundle m_bundle = ResourceBundle.getBundle(\"test.messages\"); //$NON-NLS-1$", "  public Test() {", "    setTitle(m_bundle.getString(\"frame.title\")); //$NON-NLS-1$", "    setName(m_bundle.getString(\"frame.name\")); //$NON-NLS-1$", "  }", "}");
        String newProperties = SourceAbstractSpecialTest.getFileContentSrc("test/messages.properties");
        SourceAbstractSpecialTest.assertTrue((boolean)newProperties.contains("frame.title=My JFrame"));
        SourceAbstractSpecialTest.assertTrue((boolean)newProperties.contains("frame.name=My name"));
    }

    @Test
    public void test_useKey_alreadyExternalized() throws Exception {
        SourceAbstractSpecialTest.setFileContentSrc("test/messages.properties", SourceAbstractSpecialTest.getSourceDQ("frame.title=My JFrame", "frame.name=My name"));
        SourceAbstractSpecialTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  private static final ResourceBundle m_bundle = ResourceBundle.getBundle('test.messages'); //$NON-NLS-1$", "  public Test() {", "    setName(m_bundle.getString('frame.name')); //$NON-NLS-1$", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        Object[] sources = support.getSources();
        Assertions.assertThat((Object[])sources).hasSize(1);
        FieldSource fieldSource = (FieldSource)sources[0];
        GenericProperty nameProperty = (GenericProperty)frame.getPropertyByTitle("name");
        fieldSource.useKey(nameProperty, "frame.title");
        this.assertEditor("import java.util.ResourceBundle;", "public class Test extends JFrame {", "  private static final ResourceBundle m_bundle = ResourceBundle.getBundle(\"test.messages\"); //$NON-NLS-1$", "  public Test() {", "    setName(m_bundle.getString(\"frame.title\")); //$NON-NLS-1$", "  }", "}");
        String newProperties = SourceAbstractSpecialTest.getFileContentSrc("test/messages.properties");
        SourceAbstractSpecialTest.assertTrue((boolean)newProperties.contains("frame.title=My JFrame"));
        SourceAbstractSpecialTest.assertTrue((boolean)newProperties.contains("frame.name=My name"));
    }
}

