/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.nls;

import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JFrame;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.broadcast.JavaEventListener;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.ToolkitDescriptionJava;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.nls.NlsSupport;
import org.eclipse.wb.internal.core.nls.SourceDescription;
import org.eclipse.wb.internal.core.nls.bundle.eclipse.old.EclipseSource;
import org.eclipse.wb.internal.core.nls.bundle.eclipse.old.EclipseSourceNewComposite;
import org.eclipse.wb.internal.core.nls.edit.IEditableSource;
import org.eclipse.wb.internal.core.nls.edit.IEditableSupport;
import org.eclipse.wb.internal.core.nls.model.AbstractSource;
import org.eclipse.wb.internal.core.nls.model.LocaleInfo;
import org.eclipse.wb.internal.core.nls.ui.AbstractSourceNewComposite;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.swing.ToolkitProvider;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.core.PreferencesRepairer;
import org.eclipse.wb.tests.designer.core.nls.NlsTestUtils;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

public class NlsSupportTest
extends SwingModelTest {
    private ContainerInfo m_frame;
    private NlsSupport m_support;

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        NlsSupportTest.waitEventLoop(0);
        if (this.m_frame != null) {
            this.m_frame.refresh_dispose();
            this.m_frame = null;
            this.m_support = null;
        }
        super.tearDown();
    }

    private void prepareUsualState() throws Exception {
        this.createUsualAccessorProperties();
        this.parseUsualJFrame();
    }

    private void createUsualAccessorProperties() throws Exception {
        this.createUsualAccessor();
        NlsSupportTest.setFileContentSrc("test/messages.properties", NlsSupportTest.getSourceDQ("frame.title=My JFrame"));
        NlsSupportTest.setFileContentSrc("test/messages_it.properties", NlsSupportTest.getSourceDQ("frame.title=My JFrame IT"));
        NlsSupportTest.waitForAutoBuild();
    }

    private void createUsualAccessor() throws Exception {
        NlsTestUtils.create_EclipseOld_Accessor(this, false);
    }

    private void parseUsualJFrame() throws Exception {
        this.m_frame = this.parseContainer("class Test extends JFrame {", "  Test() {", "    setTitle(Messages.getString('frame.title')); //$NON-NLS-1$", "    setName('Some name');", "  }", "}");
        this.m_support = NlsSupport.get((JavaInfo)this.m_frame);
        AbstractSource.setLocaleInfo((JavaInfo)this.m_frame, (LocaleInfo)LocaleInfo.DEFAULT);
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_getKeySource() throws Exception {
        this.prepareUsualState();
        NlsSupport nlsSupport = NlsSupport.get((JavaInfo)this.m_frame);
        Object[] sources = nlsSupport.getSources();
        Assertions.assertThat((Object[])sources).hasSize(1);
        Object source = sources[0];
        NlsSupportTest.assertSame((Object)source, (Object)nlsSupport.getKeySource("frame.title"));
        NlsSupportTest.assertSame(null, (Object)nlsSupport.getKeySource("no.such.key"));
    }

    @Test
    public void test_getValue_default() throws Exception {
        this.prepareUsualState();
        this.m_frame.refresh();
        NlsSupportTest.assertEquals((Object)"My JFrame", (Object)((JFrame)this.m_frame.getObject()).getTitle());
    }

    @Test
    public void test_getValue_null() throws Exception {
        this.prepareUsualState();
        AbstractSource.setLocaleInfo((JavaInfo)this.m_frame, null);
        this.m_frame.refresh();
        NlsSupportTest.assertEquals((Object)"My JFrame", (Object)((JFrame)this.m_frame.getObject()).getTitle());
    }

    @Test
    public void test_getValue_it() throws Exception {
        this.prepareUsualState();
        AbstractSource.setLocaleInfo((JavaInfo)this.m_frame, (LocaleInfo)new LocaleInfo(Locale.of("it")));
        this.m_frame.refresh();
        NlsSupportTest.assertEquals((Object)"My JFrame IT", (Object)((JFrame)this.m_frame.getObject()).getTitle());
    }

    @Test
    public void test_getValue_it_IT() throws Exception {
        this.prepareUsualState();
        AbstractSource.setLocaleInfo((JavaInfo)this.m_frame, (LocaleInfo)new LocaleInfo(Locale.of("it_IT")));
        this.m_frame.refresh();
        NlsSupportTest.assertEquals((Object)"My JFrame IT", (Object)((JFrame)this.m_frame.getObject()).getTitle());
    }

    @Test
    public void test_getValue_removeResources() throws Exception {
        this.createUsualAccessor();
        this.m_frame = this.parseContainer("class Test extends JFrame {", "  Test() {", "    setTitle(Messages.getString('frame.title'));", "  }", "}");
        this.m_frame.refresh();
        this.m_support = NlsSupport.get((JavaInfo)this.m_frame);
        Expression expression = ((GenericProperty)this.m_frame.getPropertyByTitle("title")).getExpression();
        NlsSupportTest.assertTrue((boolean)NlsSupport.isBadExpression((Expression)expression));
    }

    @Test
    public void test_useSelectedLocale_forBinaryComponents() throws Exception {
        this.createUsualAccessorProperties();
        NlsSupportTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public MyPanel() {", "    setName(Messages.getString('frame.title')); //$NON-NLS-1$", "  }", "}"));
        NlsSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends MyPanel {", "}");
        panel.refresh();
        NlsSupportTest.assertEquals((Object)"My JFrame", (Object)panel.getComponent().getName());
        AbstractSource.setLocaleInfo((JavaInfo)panel, (LocaleInfo)new LocaleInfo(Locale.of("it")));
        panel.refresh();
        NlsSupportTest.assertEquals((Object)"My JFrame IT", (Object)panel.getComponent().getName());
    }

    @Test
    public void test_SourceDescription() throws Exception {
        this.prepareUsualState();
        SourceDescription[] sourceDescriptions = NlsSupport.getSourceDescriptions((JavaInfo)this.m_frame);
        int i = 0;
        while (i < sourceDescriptions.length) {
            SourceDescription sourceDescription = sourceDescriptions[i];
            if (sourceDescription.getSourceClass() == EclipseSource.class) {
                NlsSupportTest.assertSame(EclipseSourceNewComposite.class, (Object)sourceDescription.getNewCompositeClass());
                NlsSupportTest.assertEquals((Object)"Classic Eclipse messages class", (Object)sourceDescription.getTitle());
                Shell shell = new Shell();
                try {
                    AbstractSourceNewComposite composite = sourceDescription.createNewComposite((Composite)shell, (JavaInfo)this.m_frame);
                    NlsSupportTest.assertNotNull((Object)composite);
                }
                finally {
                    shell.dispose();
                }
            }
            ++i;
        }
    }

    @Test
    public void test_NLSSource_getRoot() throws Exception {
        this.prepareUsualState();
        NlsSupportTest.assertSame((Object)this.m_frame, (Object)this.m_support.getRoot());
    }

    @Test
    public void test_NLSSource_getSources() throws Exception {
        this.prepareUsualState();
        AbstractSource[] sources = this.m_support.getSources();
        NlsSupportTest.assertEquals((int)1, (int)sources.length);
        NlsSupportTest.assertInstanceOf(EclipseSource.class, (Object)sources[0]);
    }

    @Test
    public void test_NLSSource_getLocales() throws Exception {
        this.prepareUsualState();
        Object[] locales = this.m_support.getLocales();
        Assertions.assertThat((Object[])locales).hasSize(2);
        NlsSupportTest.assertEquals((Object)"(default)", (Object)locales[0].getTitle());
        NlsSupportTest.assertEquals((Object)"it", (Object)locales[1].getTitle());
    }

    @Test
    public void test_NLSSource_getLocales_alwaysVisibleLocales() throws Exception {
        this.prepareUsualState();
        ToolkitDescriptionJava toolkit = this.m_frame.getDescription().getToolkit();
        PreferencesRepairer preferencesRepairer = new PreferencesRepairer(toolkit.getPreferences());
        try {
            preferencesRepairer.setValue("nls.alwaysVisibleLocales", "de, ru_RU");
            LocaleInfo[] locales = this.m_support.getLocales();
            List localeNames = Stream.of(locales).map(LocaleInfo::toString).collect(Collectors.toList());
            ((ListAssert)Assertions.assertThat(localeNames).hasSize(4)).containsOnly((Object[])new String[]{"(default)", "it", "de", "ru_RU"});
        }
        finally {
            preferencesRepairer.restore();
        }
    }

    @Test
    public void test_NLSSource_isExternalized() throws Exception {
        this.prepareUsualState();
        GenericProperty titleProperty = (GenericProperty)this.m_frame.getPropertyByTitle("title");
        NlsSupportTest.assertTrue((boolean)this.m_support.isExternalized(titleProperty.getExpression()));
        GenericProperty nameProperty = (GenericProperty)this.m_frame.getPropertyByTitle("name");
        NlsSupportTest.assertFalse((boolean)this.m_support.isExternalized(nameProperty.getExpression()));
    }

    @Test
    public void test_NLSSource_isExternallyChanged() throws Exception {
        this.prepareUsualState();
        NlsSupportTest.assertFalse((boolean)this.m_support.isExternallyChanged());
        NlsSupportTest.setFileContentSrc("test/messages.properties", NlsSupportTest.getSourceDQ("frame.title=My JFrame2"));
        NlsSupportTest.assertTrue((boolean)this.m_support.isExternallyChanged());
    }

    @Test
    public void test_NLSSource_setValue() throws Exception {
        this.prepareUsualState();
        GenericProperty titleProperty = (GenericProperty)this.m_frame.getPropertyByTitle("title");
        this.m_support.setValue(titleProperty.getExpression(), "New title");
        String newProperties = NlsSupportTest.getFileContentSrc("test/messages.properties");
        NlsSupportTest.assertTrue((boolean)newProperties.contains("frame.title=New title"));
    }

    @Test
    public void test_NLSSource_externalize() throws Exception {
        this.prepareUsualState();
        GenericProperty nameProperty = (GenericProperty)this.m_frame.getPropertyByTitle("name");
        this.m_support.externalize((JavaInfo)this.m_frame, nameProperty);
        this.assertEditor("class Test extends JFrame {", "  Test() {", "    setTitle(Messages.getString('frame.title')); //$NON-NLS-1$", "    setName(Messages.getString('Test.this.name')); //$NON-NLS-1$", "  }", "}");
        String newProperties = NlsSupportTest.getFileContentSrc("test/messages.properties");
        NlsSupportTest.assertTrue((boolean)newProperties.contains("Test.this.name=Some name"));
    }

    @Test
    public void test_getAttachedSource() throws Exception {
        NlsSupportTest.setFileContentSrc("test/messages.properties", NlsSupportTest.getSourceDQ("#Field ResourceBundle: m_bundle"));
        NlsSupportTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("// filler filler filler", "public class Test extends JFrame {", "  public Test() {", "  }", "}");
        NlsSupport support = NlsSupport.get((JavaInfo)frame);
        IEditableSupport editableSupport = support.getEditable();
        List editableSources = editableSupport.getEditableSources();
        Assertions.assertThat((List)editableSources).hasSize(1);
        IEditableSource editableSource = (IEditableSource)editableSources.get(0);
        AbstractSource source = editableSupport.getSource(editableSource);
        NlsSupportTest.assertNull((Object)source);
        source = support.getAttachedSource(editableSupport, editableSource);
        NlsSupportTest.assertNotNull((Object)source);
        this.assertEditor("import java.util.ResourceBundle;", "// filler filler filler", "public class Test extends JFrame {", "  private static final ResourceBundle m_bundle = ResourceBundle.getBundle(\"test.messages\"); //$NON-NLS-1$", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_GenericProperty_setValue_clearProperty() throws Exception {
        this.prepareUsualState();
        this.m_frame.refresh();
        Property titleProperty = this.m_frame.getPropertyByTitle("title");
        titleProperty.setValue(Property.UNKNOWN_VALUE);
        NlsSupportTest.assertEquals((Object)"", (Object)((JFrame)this.m_frame.getObject()).getTitle());
        this.assertEditor("class Test extends JFrame {", "  Test() {", "    setName('Some name');", "  }", "}");
        String newProperties = NlsSupportTest.getFileContentSrc("test/messages.properties");
        NlsSupportTest.assertFalse((boolean)newProperties.contains("Test.this.name=myName"));
    }

    @Test
    public void test_GenericProperty_setValue_forAlreadyExternalized() throws Exception {
        this.prepareUsualState();
        this.m_frame.refresh();
        GenericProperty property = (GenericProperty)this.m_frame.getPropertyByTitle("title");
        property.setValue((Object)"New title");
        String newProperties = NlsSupportTest.getFileContentSrc("test/messages.properties");
        NlsSupportTest.assertTrue((boolean)newProperties.contains("frame.title=New title"));
        NlsSupportTest.assertEquals((Object)"New title", (Object)((JFrame)this.m_frame.getObject()).getTitle());
    }

    @Test
    public void test_GenericProperty_setValue_setKey_forNewProperty() throws Exception {
        this.createUsualAccessorProperties();
        this.m_frame = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    setName(Messages.getString('frame.name')); //$NON-NLS-1$", "  }", "}");
        this.m_frame.refresh();
        Property property = this.m_frame.getPropertyByTitle("title");
        property.setValue((Object)"*frame.title");
        NlsSupportTest.assertEquals((Object)"My JFrame", (Object)property.getValue());
        String expectedSource = this.getTestSource("public class Test extends JFrame {", "  public Test() {", "    setTitle(Messages.getString('frame.title')); //$NON-NLS-1$", "    setName(Messages.getString('frame.name')); //$NON-NLS-1$", "  }", "}");
        NlsSupportTest.assertEditor(expectedSource, this.m_lastEditor);
        NlsSupportTest.assertEquals((Object)expectedSource, (Object)this.m_lastEditor.getModelUnit().getSource());
        String newProperties = NlsSupportTest.getFileContentSrc("test/messages.properties");
        NlsSupportTest.assertTrue((boolean)newProperties.contains("frame.title=My JFrame"));
    }

    @Test
    public void test_GenericProperty_setValue_setKey_forExistingProperty() throws Exception {
        this.createUsualAccessorProperties();
        this.m_frame = this.parseContainer("public class Test extends JFrame {", "  public Test() {", "    setName(Messages.getString('frame.name')); //$NON-NLS-1$", "  }", "}");
        this.m_frame.refresh();
        Property property = this.m_frame.getPropertyByTitle("name");
        property.setValue((Object)"*frame.title");
        NlsSupportTest.assertEquals((Object)"My JFrame", (Object)property.getValue());
        String expectedSource = this.getTestSource("public class Test extends JFrame {", "  public Test() {", "    setName(Messages.getString('frame.title')); //$NON-NLS-1$", "  }", "}");
        NlsSupportTest.assertEditor(expectedSource, this.m_lastEditor);
        NlsSupportTest.assertEquals((Object)expectedSource, (Object)this.m_lastEditor.getModelUnit().getSource());
        String newProperties = NlsSupportTest.getFileContentSrc("test/messages.properties");
        NlsSupportTest.assertTrue((boolean)newProperties.contains("frame.title=My JFrame"));
    }

    @Test
    public void test_GenericProperty_setValue_autoExternalizeEnabled() throws Exception {
        this.createUsualAccessorProperties();
        this.m_frame = this.parseContainer("class Test extends JFrame {", "  Test() {", "    setTitle(Messages.getString('frame.title')); //$NON-NLS-1$", "  }", "}");
        this.m_frame.refresh();
        Property property = this.m_frame.getPropertyByTitle("name");
        property.setValue((Object)"myName");
        NlsSupportTest.assertEquals((Object)"myName", (Object)property.getValue());
        String expectedSource = this.getTestSource("class Test extends JFrame {", "  Test() {", "    setName(Messages.getString('Test.this.name')); //$NON-NLS-1$", "    setTitle(Messages.getString('frame.title')); //$NON-NLS-1$", "  }", "}");
        NlsSupportTest.assertEditor(expectedSource, this.m_lastEditor);
        NlsSupportTest.assertEquals((Object)expectedSource, (Object)this.m_lastEditor.getModelUnit().getSource());
        String newProperties = NlsSupportTest.getFileContentSrc("test/messages.properties");
        NlsSupportTest.assertTrue((boolean)newProperties.contains("Test.this.name=myName"));
    }

    @Test
    public void test_GenericProperty_setValue_autoExternalizeDisable() throws Exception {
        this.createUsualAccessorProperties();
        this.m_frame = this.parseContainer("class Test extends JFrame {", "  Test() {", "    setTitle(Messages.getString('frame.title')); //$NON-NLS-1$", "  }", "}");
        this.m_frame.refresh();
        PreferencesRepairer preferences = new PreferencesRepairer(ToolkitProvider.DESCRIPTION.getPreferences());
        try {
            preferences.setValue("nls.automaticallyExternalize", false);
            this.m_frame.getPropertyByTitle("name").setValue((Object)"myName");
        }
        finally {
            preferences.restore();
        }
        this.assertEditor("class Test extends JFrame {", "  Test() {", "    setName('myName');", "    setTitle(Messages.getString('frame.title')); //$NON-NLS-1$", "  }", "}");
        String newProperties = NlsSupportTest.getFileContentSrc("test/messages.properties");
        NlsSupportTest.assertFalse((boolean)newProperties.contains("Test.this.name=myName"));
    }

    @Test
    public void test_liveImage_whenExternalized() throws Exception {
        this.createUsualAccessorProperties();
        NlsSupportTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButton extends JButton {", "}"));
        NlsSupportTest.setFileContentSrc("test/MyButton.wbp-component.xml", NlsSupportTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <model class='" + MyButtonInfo.class.getName() + "'/>", "</component>"));
        NlsSupportTest.waitForAutoBuild();
        this.m_frame = this.parseContainer("class Test extends JFrame {", "  Test() {", "    setTitle(Messages.getString('frame.title')); //$NON-NLS-1$", "  }", "}");
        this.m_frame.refresh();
        String properties = NlsSupportTest.getFileContentSrc("test/messages.properties");
        String messages = NlsSupportTest.getFileContentSrc("test/Messages.java");
        ComponentInfo button = NlsSupportTest.createComponent("test.MyButton");
        Image image = button.getImage();
        NlsSupportTest.assertNotNull((Object)image);
        Assertions.assertThat((int)image.getBounds().width).isGreaterThan(40);
        Assertions.assertThat((int)image.getBounds().height).isGreaterThan(20);
        String newProperties = NlsSupportTest.getFileContentSrc("test/messages.properties");
        String newMessages = NlsSupportTest.getFileContentSrc("test/Messages.java");
        NlsSupportTest.assertEquals((Object)properties, (Object)newProperties);
        NlsSupportTest.assertEquals((Object)messages, (Object)newMessages);
    }

    @Test
    public void test_renameKeysWhenVariable() throws Exception {
        String newProperties;
        NlsSupportTest.setFileContentSrc("test/messages.properties", NlsSupportTest.getSourceDQ("Test.frame.title=My JFrame", "frame.name=My name", "foo.bar=baz"));
        NlsSupportTest.setFileContentSrc("test/MyResourceBundleFactory.java", NlsSupportTest.getSourceDQ("package test;", "import java.util.ResourceBundle;", "public class MyResourceBundleFactory {", "  public static ResourceBundle getMainBundle() {", "    return ResourceBundle.getBundle('test.messages');", "  }", "}"));
        NlsSupportTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("import java.util.ResourceBundle;", "public class Test {", "  private static final ResourceBundle m_bundle = ResourceBundle.getBundle('test.messages'); //$NON-NLS-1$", "  public static void main(String[] args) {", "    JFrame frame = new JFrame();", "    frame.setTitle(m_bundle.getString('Test.frame.title')); //$NON-NLS-1$", "  }", "}");
        frame.refresh();
        PreferencesRepairer preferencesRepairer = new PreferencesRepairer(frame.getDescription().getToolkit().getPreferences());
        try {
            preferencesRepairer.setValue("nls.renameKeysWithVariables", true);
            frame.getVariableSupport().setName("newName");
            newProperties = NlsSupportTest.getFileContentSrc("test/messages.properties");
            NlsSupportTest.assertTrue((boolean)newProperties.contains("Test.newName.title=My JFrame"));
            NlsSupportTest.assertTrue((boolean)newProperties.contains("foo.bar=baz"));
        }
        finally {
            preferencesRepairer.restore();
        }
        frame.getVariableSupport().setName("frame2");
        newProperties = NlsSupportTest.getFileContentSrc("test/messages.properties");
        NlsSupportTest.assertTrue((boolean)newProperties.contains("Test.newName.title=My JFrame"));
    }

    public static class MyButtonInfo
    extends ComponentInfo {
        public MyButtonInfo(AstEditor editor, ComponentDescription description, CreationSupport creationSupport) throws Exception {
            super(editor, description, creationSupport);
            this.addBroadcastListener(new JavaEventListener(){

                public void addAfter(JavaInfo parent, JavaInfo child) throws Exception {
                    this.getPropertyByTitle("text").setValue((Object)"txt");
                }
            });
        }
    }
}

