/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.description;

import java.awt.Component;
import java.awt.Container;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import org.eclipse.wb.internal.core.model.description.ComponentDescriptionKey;
import org.eclipse.wb.tests.designer.tests.DesignerTestCase;
import org.junit.jupiter.api.Test;

public class ComponentDescriptionKeyTest
extends DesignerTestCase {
    @Test
    public void test_constructor_nullClass() throws Exception {
        try {
            new ComponentDescriptionKey(null, null, null);
            ComponentDescriptionKeyTest.fail();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Test
    public void test_constructor_nullHost_notNullSuffix() throws Exception {
        try {
            new ComponentDescriptionKey(Object.class, null, "theSuffix");
            ComponentDescriptionKeyTest.fail();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Test
    public void test_constructor_notNullHost_nullSuffix() throws Exception {
        ComponentDescriptionKey host = new ComponentDescriptionKey(Object.class);
        try {
            new ComponentDescriptionKey(Object.class, host, null);
            ComponentDescriptionKeyTest.fail();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Test
    public void test_toString_noHost() throws Exception {
        ComponentDescriptionKey key = new ComponentDescriptionKey(Component.class);
        ComponentDescriptionKeyTest.assertEquals((Object)"CDKey(java.awt.Component)", (Object)key.toString());
        ComponentDescriptionKeyTest.assertTrue((boolean)key.isPureComponent());
    }

    @Test
    public void test_toString_withHost() throws Exception {
        ComponentDescriptionKey host = new ComponentDescriptionKey(Container.class);
        ComponentDescriptionKey key = new ComponentDescriptionKey(Component.class, host, "theSuffix");
        ComponentDescriptionKeyTest.assertEquals((Object)"CDKey(java.awt.Component,CDKey(java.awt.Container),theSuffix)", (Object)key.toString());
        ComponentDescriptionKeyTest.assertFalse((boolean)key.isPureComponent());
    }

    @Test
    public void test_hashCode() throws Exception {
        ComponentDescriptionKey key_1 = new ComponentDescriptionKey(Component.class);
        ComponentDescriptionKey key_2 = new ComponentDescriptionKey(Component.class);
        ComponentDescriptionKey key_3 = new ComponentDescriptionKey(Container.class);
        ComponentDescriptionKeyTest.assertEquals((int)key_1.hashCode(), (int)key_2.hashCode());
        ComponentDescriptionKeyTest.assertNotEquals((int)key_1.hashCode(), (int)key_3.hashCode());
    }

    @Test
    public void test_equals_noHost() throws Exception {
        ComponentDescriptionKey key_1 = new ComponentDescriptionKey(Component.class);
        ComponentDescriptionKey key_2 = new ComponentDescriptionKey(Component.class);
        ComponentDescriptionKey key_3 = new ComponentDescriptionKey(Container.class);
        ComponentDescriptionKeyTest.assertNotEquals((Object)key_1, (Object)((Object)this));
        ComponentDescriptionKeyTest.assertEquals((Object)key_1, (Object)key_1);
        ComponentDescriptionKeyTest.assertEquals((Object)key_1, (Object)key_2);
        ComponentDescriptionKeyTest.assertNotEquals((Object)key_1, (Object)key_3);
    }

    @Test
    public void test_equals_withHost() throws Exception {
        ComponentDescriptionKey host_1 = new ComponentDescriptionKey(List.class);
        ComponentDescriptionKey host_2 = new ComponentDescriptionKey(Map.class);
        ComponentDescriptionKey key_1 = new ComponentDescriptionKey(Component.class, host_1, "suffix_1");
        ComponentDescriptionKey key_2 = new ComponentDescriptionKey(Component.class, host_1, "suffix_2");
        ComponentDescriptionKey key_3 = new ComponentDescriptionKey(Component.class, host_2, "suffix_1");
        ComponentDescriptionKey key_4 = new ComponentDescriptionKey(Component.class, host_2, "suffix_2");
        ComponentDescriptionKey key_5 = new ComponentDescriptionKey(Component.class, host_1, "suffix_1");
        ComponentDescriptionKeyTest.assertEquals((Object)key_1, (Object)key_1);
        ComponentDescriptionKeyTest.assertNotEquals((Object)key_1, (Object)key_2);
        ComponentDescriptionKeyTest.assertNotEquals((Object)key_1, (Object)key_3);
        ComponentDescriptionKeyTest.assertNotEquals((Object)key_1, (Object)key_4);
        ComponentDescriptionKeyTest.assertEquals((Object)key_1, (Object)key_5);
    }

    @Test
    public void test_getComponentClass() throws Exception {
        ComponentDescriptionKey key = new ComponentDescriptionKey(Component.class);
        ComponentDescriptionKeyTest.assertSame((Object)key.getComponentClass(), Component.class);
    }

    @Test
    public void test_getName_noHost() throws Exception {
        ComponentDescriptionKey key = new ComponentDescriptionKey(Component.class);
        ComponentDescriptionKeyTest.assertEquals((Object)"java/awt/Component", (Object)key.getName());
    }

    @Test
    public void test_getName_withHost() throws Exception {
        ComponentDescriptionKey host = new ComponentDescriptionKey(Container.class);
        ComponentDescriptionKey key = new ComponentDescriptionKey(Component.class, host, "theSuffix");
        ComponentDescriptionKeyTest.assertEquals((Object)"java/awt/Container.theSuffix", (Object)key.getName());
    }

    @Test
    public void test_getName_withHost2() throws Exception {
        ComponentDescriptionKey key_1 = new ComponentDescriptionKey(Container.class);
        ComponentDescriptionKey key_2 = new ComponentDescriptionKey(Component.class, key_1, "firstSuffix");
        ComponentDescriptionKey key_3 = new ComponentDescriptionKey(JButton.class, key_2, "secondSuffix");
        ComponentDescriptionKeyTest.assertEquals((Object)"java/awt/Container.firstSuffix.secondSuffix", (Object)key_3.getName());
    }
}

