/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.gef;

import java.util.Set;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableRunnable;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;

public class UiContext {
    private final Display m_display;

    public UiContext() {
        this.m_display = Display.getCurrent();
    }

    public UiContext(Display display) {
        this.m_display = display;
    }

    public void executeAndCheck(FailableRunnable<Exception> uiRunnable, FailableConsumer<SWTBot, Exception> checkRunnable) throws Exception {
        Set<Shell> originalShells = Set.of(this.m_display.getShells());
        Throwable[] checkException = new Throwable[1];
        boolean[] ready = new boolean[1];
        Thread thread = Thread.ofVirtual().name("UIContext_checkThread").start(() -> {
            while (!ready[0]) {
                Thread.yield();
            }
            try {
                try {
                    Shell activeShell = (Shell)UIThreadRunnable.syncExec(() -> ((Display)this.m_display).getActiveShell());
                    checkRunnable.accept((Object)new SWTBot((Widget)activeShell));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    throwableArray[0] = e;
                    this.dispose(originalShells);
                }
            }
            finally {
                this.dispose(originalShells);
            }
        });
        this.m_display.asyncExec(() -> {
            boolean bl = blArray[0] = true;
        });
        uiRunnable.run();
        while (thread.isAlive()) {
            this.m_display.readAndDispatch();
        }
        if (checkException[0] != null) {
            Throwable throwable = checkException[0];
            if (throwable instanceof AssertionError) {
                AssertionError error = (AssertionError)((Object)throwable);
                throw error;
            }
            Throwable throwable2 = checkException[0];
            if (throwable2 instanceof WidgetNotFoundException) {
                WidgetNotFoundException error = (WidgetNotFoundException)throwable2;
                throw error;
            }
            throw new Exception("Exception during running 'check' UIRunnable.", checkException[0]);
        }
    }

    public void execute(FailableRunnable<Exception> uiRunnable) {
        this.m_display.asyncExec(() -> {
            try {
                uiRunnable.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void dispose(Set<Shell> originalShells) {
        this.execute((FailableRunnable<Exception>)((FailableRunnable)() -> {
            Shell[] shellArray = this.m_display.getShells();
            int n = shellArray.length;
            int n2 = 0;
            while (n2 < n) {
                Shell shell = shellArray[n2];
                if (!originalShells.contains(shell)) {
                    shell.dispose();
                }
                ++n2;
            }
        }));
    }
}

