/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableRunnable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.gef.EditPart;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wb.core.editor.IDesignPageSite;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.gef.core.tools.CreationTool;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.DesignPageSite;
import org.eclipse.wb.internal.core.editor.structure.components.IComponentsTree;
import org.eclipse.wb.internal.core.utils.ast.BodyDeclarationTarget;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.core.RefactoringTestUtils;
import org.eclipse.wb.tests.designer.core.annotations.DisposeProjectAfter;
import org.eclipse.wb.tests.designer.swing.SwingGefTest;
import org.eclipse.wb.tests.gef.UiContext;
import org.junit.After;
import org.junit.Ignore;
import org.junit.Test;

public class UndoManagerTest
extends SwingGefTest {
    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        IPreferenceStore preferences = DesignerPlugin.getPreferences();
        preferences.setToDefault("editor.layout");
    }

    @Test
    public void test_undoRedo() throws Exception {
        this.openContainer("// filler filler filler\npublic class Test extends JFrame {\n\tpublic Test() {\n\t}\n}");
        String initialSource = this.m_lastEditor.getSource();
        IActionBars actionBars = this.m_designerEditor.getEditorSite().getActionBars();
        ContainerInfo frame = (ContainerInfo)this.m_contentJavaInfo;
        ContainerInfo contentPane = (ContainerInfo)frame.getChildrenComponents().get(0);
        UndoManagerTest.assertTrue((boolean)this.m_viewerCanvas.getSelectedEditParts().isEmpty());
        this.canvas.moveTo((Object)contentPane, 10, 10);
        this.canvas.click();
        this.assertSelectionModels(contentPane);
        Object newButton = this.loadCreationTool("javax.swing.JButton");
        UndoManagerTest.assertTrue((boolean)(this.m_viewerCanvas.getEditDomain().getActiveTool() instanceof CreationTool));
        this.canvas.moveTo((Object)contentPane, 100, 50);
        this.canvas.click();
        this.assertEditor("// filler filler filler\npublic class Test extends JFrame {\n\tpublic Test() {\n\t\t{\n\t\t\tJButton button = new JButton(\"New button\");\n\t\t\tgetContentPane().add(button, BorderLayout.NORTH);\n\t\t}\n\t}\n}");
        String source_withButton = this.m_lastEditor.getSource();
        this.assertSelectionModels(newButton);
        this.assertExpandedComponents(new ObjectInfo[]{frame, contentPane});
        actionBars.getGlobalActionHandler("undo").run();
        UndoManagerTest.waitEventLoop(0);
        this.fetchContentFields();
        UndoManagerTest.assertEquals((Object)initialSource, (Object)this.m_lastEditor.getSource());
        frame = (ContainerInfo)this.m_contentJavaInfo;
        contentPane = (ContainerInfo)frame.getChildrenComponents().get(0);
        this.assertSelectionModels(contentPane);
        actionBars.getGlobalActionHandler("redo").run();
        UndoManagerTest.waitEventLoop(0);
        this.fetchContentFields();
        UndoManagerTest.assertEquals((Object)source_withButton, (Object)this.m_lastEditor.getSource());
        frame = (ContainerInfo)this.m_contentJavaInfo;
        contentPane = (ContainerInfo)frame.getChildrenComponents().get(0);
        this.assertSelectionModels(contentPane.getChildrenComponents().get(0));
        this.assertExpandedComponents(new ObjectInfo[]{frame, contentPane});
    }

    @Test
    public void test_modifyLogicAndSwitchDesign() throws Exception {
        this.openContainer("// filler filler filler\npublic class Test extends JFrame {\n\tpublic Test() {\n\t}\n}");
        ICompilationUnit compilationUnit = (ICompilationUnit)ReflectionUtils.getFieldObject((Object)this.m_designPage, (String)"m_compilationUnit");
        ContainerInfo frame = (ContainerInfo)this.m_contentJavaInfo;
        ContainerInfo contentPane = (ContainerInfo)frame.getChildrenComponents().get(0);
        UndoManagerTest.assertTrue((boolean)this.m_viewerCanvas.getSelectedEditParts().isEmpty());
        this.canvas.click(150, 100, 1);
        this.assertSelectionModels(contentPane);
        this.openSourcePage();
        compilationUnit.getBuffer().replace(0, 0, "// abc\n");
        UndoManagerTest.waitEventLoop(0);
        this.openDesignPage();
        List selectedEditParts = this.m_viewerCanvas.getSelectedEditParts();
        UndoManagerTest.assertEquals((long)1L, (long)selectedEditParts.size());
        EditPart selectedEditPart = (EditPart)selectedEditParts.get(0);
        UndoManagerTest.assertEquals((Object)contentPane.toString(), (Object)selectedEditPart.getModel().toString());
    }

    @Test
    public void test_modifyInParallelJavaEditor() throws Exception {
        IWorkbenchPage activePage = DesignerPlugin.getActivePage();
        ContainerInfo originalContainer = this.openContainer("// filler filler filler\npublic class Test extends JFrame {\n\tpublic Test() {\n\t}\n}");
        IFile file = UndoManagerTest.getFileSrc("test/Test.java");
        IEditorPart javaEditor = activePage.openEditor((IEditorInput)new FileEditorInput(file), "org.eclipse.jdt.ui.CompilationUnitEditor", true, 0);
        ISourceViewer sourceViewer = (ISourceViewer)ReflectionUtils.invokeMethod((Object)javaEditor, (String)"getViewer()", (Object[])new Object[0]);
        sourceViewer.getDocument().replace(0, 0, "// comment\n");
        this.fetchContentFields();
        UndoManagerTest.assertSame((Object)originalContainer, (Object)this.m_contentJavaInfo);
        activePage.activate((IWorkbenchPart)this.m_designerEditor);
        UndoManagerTest.waitEventLoop(0);
        this.fetchContentFields();
        UndoManagerTest.assertNotSame((Object)originalContainer, (Object)this.m_contentJavaInfo);
    }

    @Test
    public void test_expandOnSelection() throws Exception {
        ContainerInfo frame = this.openContainer("// filler filler filler\npublic class Test extends JFrame {\n\tpublic Test() {\n\t}\n}");
        ContainerInfo contentPane = (ContainerInfo)frame.getChildrenComponents().get(0);
        IComponentsTree componentTree = DesignPageSite.Helper.getSite((ObjectInfo)frame).getComponentTree();
        componentTree.setExpandedElements(ArrayUtils.EMPTY_OBJECT_ARRAY);
        UndoManagerTest.assertEquals((long)0L, (long)componentTree.getExpandedElements().length);
        this.canvas.select(contentPane);
        this.assertExpandedComponents(new ObjectInfo[]{frame});
    }

    @Ignore
    @Test
    public void test_expandRemembered_bug_0() throws Exception {
        ContainerInfo frame = this.openContainer("public class Test extends JFrame {\n\tpublic Test() {\n\t\tJPanel panel = new JPanel();\n\t\tgetContentPane().add(panel);\n\t\tpanel.add(new JButton());\n\t}\n}");
        IActionBars actionBars = this.m_designerEditor.getEditorSite().getActionBars();
        ContainerInfo contentPane = (ContainerInfo)frame.getChildrenComponents().get(0);
        ContainerInfo panel = (ContainerInfo)contentPane.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        this.canvas.select(button);
        this.assertExpandedComponents(new ObjectInfo[]{frame, contentPane, panel});
        this.canvas.select(panel);
        actionBars.getGlobalActionHandler(ActionFactory.DELETE.getId()).run();
        UndoManagerTest.assertEquals((Object)UndoManagerTest.getSource("package test;", "import java.awt.*;", "import java.awt.event.*;", "import javax.swing.*;", "import javax.swing.border.*;", "public class Test extends JFrame {", "  public Test() {", "  }", "}"), (Object)this.m_lastEditor.getModelUnit().getSource());
        this.openSourcePage();
        actionBars.getGlobalActionHandler("org.eclipse.jdt.ui.actions.OrganizeImports").run();
        UndoManagerTest.assertEquals((Object)UndoManagerTest.getSourceDQ("package test;", "import javax.swing.JFrame;", "public class Test extends JFrame {", "  public Test() {", "  }", "}"), (Object)this.m_lastEditor.getModelUnit().getSource());
        this.openDesignPage();
    }

    @Test
    public void test_expandOnOpen_1() throws Exception {
        ContainerInfo frame = this.openContainer("// filler filler filler\npublic class Test extends JFrame {\n\tpublic Test() {\n\t}\n}");
        this.assertExpandedComponents(new ObjectInfo[]{frame});
    }

    @Test
    public void test_expandOnOpen_2() throws Exception {
        ContainerInfo frame = this.openContainer("public class Test extends JFrame {\n\tpublic Test() {\n\t\tgetContentPane().add(new JButton());\n\t\tgetContentPane().add(new JButton());\n\t}\n}");
        ContainerInfo contentPane = (ContainerInfo)frame.getChildrenComponents().get(0);
        this.assertExpandedComponents(new ObjectInfo[]{frame, contentPane});
    }

    @Test
    public void test_expandOnOpen_3() throws Exception {
        ContainerInfo frame = this.openContainer("// filler filler filler\npublic class Test extends JFrame {\n\tpublic Test() {\n\t\t{\n\t\t\tJPanel panel = new JPanel();\n\t\t\tgetContentPane().add(panel);\n\t\t\tpanel.add(new JButton());\n\t\t}\n\t\tgetContentPane().add(new JButton());\n\t}\n}");
        ContainerInfo contentPane = (ContainerInfo)frame.getChildrenComponents().get(0);
        this.assertExpandedComponents(new ObjectInfo[]{frame, contentPane});
    }

    private void assertExpandedComponents(ObjectInfo ... expandedObjects) {
        IComponentsTree componentTree = DesignPageSite.Helper.getSite((ObjectInfo)this.m_contentJavaInfo).getComponentTree();
        UndoManagerTest.assertTrue((boolean)Arrays.equals(expandedObjects, componentTree.getExpandedElements()));
    }

    @Test
    public void test_restoreSelection_good() throws Exception {
        this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJButton button_1 = new JButton();\n\t\t\tadd(button_1);\n\t\t}\n\t\t{\n\t\t\tJButton button_2 = new JButton();\n\t\t\tadd(button_2);\n\t\t}\n\t}\n}");
        this.tree.select(UndoManagerTest.getJavaInfoByName("button_2"));
        this.tree.assertPrimarySelected(UndoManagerTest.getJavaInfoByName("button_2"));
        IDesignPageSite.Helper.getSite((ObjectInfo)this.m_contentJavaInfo).reparse();
        this.fetchContentFields();
        this.tree.assertPrimarySelected(UndoManagerTest.getJavaInfoByName("button_2"));
    }

    @Test
    public void test_restoreSelection_whenComponentDisappears() throws Exception {
        UndoManagerTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {\n\tprivate JButton m_button = new JButton();\n\tpublic MyPanel() {\n\t\tadd(m_button);\n\t}\n\tpublic JButton getButton() {\n\t\treturn m_button;\n\t}\n}"));
        UndoManagerTest.waitForAutoBuild();
        this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tadd(new MyPanel());\n\t}\n}");
        ComponentInfo button = (ComponentInfo)UndoManagerTest.getJavaInfoByName("getButton()");
        this.tree.select(button);
        this.tree.assertPrimarySelected(button);
        UndoManagerTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {\n\tprivate JButton m_button = new JButton();\n\tpublic MyPanel() {\n\t\tadd(m_button);\n\t}\n}"));
        UndoManagerTest.waitForAutoBuild();
        IDesignPageSite.Helper.getSite((ObjectInfo)this.m_contentJavaInfo).reparse();
        this.fetchContentFields();
        this.tree.assertSelectedEmpty();
    }

    @Test
    public void test_readOnly_Yes() throws Exception {
        String expectedSource = "// filler filler filler\npublic class Test extends JFrame {\n\tpublic Test() {\n\t}\n\tvoid foo() {\n\t}\n}";
        this.test_readOnly(IDialogConstants.YES_LABEL, false, expectedSource, expectedSource);
    }

    @Test
    public void test_readOnly_No() throws Exception {
        this.test_readOnly(IDialogConstants.NO_LABEL, true, "// filler filler filler\npublic class Test extends JFrame {\n\tpublic Test() {\n\t}\n\tvoid foo() {\n\t}\n}", "// filler filler filler\npublic class Test extends JFrame {\n\tpublic Test() {\n\t}\n}");
    }

    private void test_readOnly(final String buttonId, boolean expectedAccess, String expectedSource1, String expectedSource2) throws Exception {
        this.openContainer("// filler filler filler\npublic class Test extends JFrame {\n\tpublic Test() {\n\t}\n}");
        ICompilationUnit unit = this.m_lastEditor.getModelUnit();
        IFile unitFile = (IFile)unit.getUnderlyingResource();
        ResourceAttributes attributes = new ResourceAttributes();
        attributes.setReadOnly(true);
        unitFile.setResourceAttributes(attributes);
        TypeDeclaration typeDeclaration = (TypeDeclaration)this.m_lastEditor.getAstUnit().types().get(0);
        this.m_lastEditor.addMethodDeclaration("void foo()", new ArrayList(), new BodyDeclarationTarget(typeDeclaration, false));
        new UiContext().executeAndCheck(new FailableRunnable<Exception>(){

            public void run() throws Exception {
                UndoManagerTest.this.m_lastEditor.commitChanges();
            }
        }, new FailableConsumer<SWTBot, Exception>(){

            public void accept(SWTBot bot) {
                SWTBot shell = bot.shell("Read-only File Encountered").bot();
                shell.button(buttonId).click();
            }
        });
        UndoManagerTest.waitEventLoop(0);
        UndoManagerTest.waitForAutoBuild();
        UndoManagerTest.assertEquals((Object)expectedAccess, (Object)unitFile.isReadOnly());
        UndoManagerTest.assertEquals((Object)this.getTestSource(expectedSource1), (Object)this.m_lastEditor.getSource());
        UndoManagerTest.assertEquals((Object)this.getTestSource(expectedSource2), (Object)unit.getBuffer().getContents());
    }

    @DisposeProjectAfter
    @Test
    public void test_showDesign_switchToSource_rename_showDesign() throws Exception {
        this.openContainer("// filler filler filler\npublic class Test extends JFrame {\n\tpublic Test() {\n\t}\n}");
        ICompilationUnit unit = this.m_lastEditor.getModelUnit();
        this.openSourcePage();
        RefactoringTestUtils.renameType(unit.getType("Test"), "Test_2");
        UndoManagerTest.waitEventLoop(0);
        this.openDesignPage();
    }

    @DisposeProjectAfter
    @Ignore
    @Test
    public void test_showDesign_rename() throws Exception {
        this.openContainer("public class Test extends JFrame {\n\tpublic static void main2(String[] args) {\n\t\tTest frame = new Test();\n\t\tframe.setVisible(true);\n\t}\n\tpublic Test() {\n\t}\n}");
        ICompilationUnit unit = this.m_lastEditor.getModelUnit();
        RefactoringTestUtils.renameType(unit.getType("Test"), "Test_2");
        int i = 0;
        while (i < 10) {
            UndoManagerTest.waitEventLoop(0);
            ++i;
        }
        this.assertNoLoggedExceptions();
    }
}

