/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.util;

import java.lang.invoke.CallSite;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.apache.commons.collections4.bidimap.UnmodifiableBidiMap;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.ObjectInfoUtils;
import org.eclipse.wb.internal.core.model.util.TemplateUtils;
import org.eclipse.wb.internal.core.utils.ast.BodyDeclarationTarget;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Ignore;
import org.junit.Test;

public class TemplateUtilsTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_getExpression() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        String id = ObjectInfoUtils.getId((ObjectInfo)panel);
        TemplateUtilsTest.assertEquals((Object)("__wbpId:" + id), (Object)TemplateUtils.getExpression((JavaInfo)panel));
    }

    @Ignore
    @Test
    public void test_format() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        String id = ObjectInfoUtils.getId((ObjectInfo)panel);
        String expected = "__wbpId:" + id + ".setEnabled(false)";
        TemplateUtilsTest.assertEquals((Object)expected, (Object)MessageFormat.format("{0}.setEnabled({1})", panel, "false"));
    }

    @Test
    public void test_resolve_referenceExpression() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    int target;", "  }", "}");
        NodeTarget nodeTarget = TemplateUtilsTest.getNodeStatementTarget((JavaInfo)panel, false, 0);
        String template = "foo(__wbpId:" + ObjectInfoUtils.getId((ObjectInfo)panel) + ")";
        TemplateUtilsTest.assertEquals((Object)"foo(this)", (Object)TemplateUtils.resolve((NodeTarget)nodeTarget, (String)template));
    }

    @Test
    public void test_resolve_referenceExpression_usingStatementTarget() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    int target;", "  }", "}");
        StatementTarget target = TemplateUtilsTest.getStatementTarget((JavaInfo)panel, false, 0);
        String template = "foo(__wbpId:" + ObjectInfoUtils.getId((ObjectInfo)panel) + ")";
        TemplateUtilsTest.assertEquals((Object)"foo(this)", (Object)TemplateUtils.resolve((StatementTarget)target, (String)template));
    }

    @Test
    public void test_resolve_referenceExpression_usingBodyDeclarationTarget() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    int target;", "  }", "}");
        BodyDeclarationTarget target = TemplateUtilsTest.getBodyDeclarationTarget((JavaInfo)panel, false, 0);
        String template = "foo(__wbpId:" + ObjectInfoUtils.getId((ObjectInfo)panel) + ")";
        TemplateUtilsTest.assertEquals((Object)"foo(this)", (Object)TemplateUtils.resolve((BodyDeclarationTarget)target, (String)template));
    }

    @Test
    public void test_resolve_thisAccessExpression() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    int target;", "  }", "}");
        NodeTarget nodeTarget = TemplateUtilsTest.getNodeStatementTarget((JavaInfo)panel, false, 0);
        String template = "__wbpId:" + ObjectInfoUtils.getId((ObjectInfo)panel) + ".setEnabled(false)";
        TemplateUtilsTest.assertEquals((Object)"setEnabled(false)", (Object)TemplateUtils.resolve((NodeTarget)nodeTarget, (String)template));
    }

    @Test
    public void test_resolve_accessExpression() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        NodeTarget nodeTarget = TemplateUtilsTest.getNodeStatementTarget((JavaInfo)panel, false, 0);
        String template = "__wbpId:" + ObjectInfoUtils.getId((ObjectInfo)button) + ".setEnabled(false)";
        TemplateUtilsTest.assertEquals((Object)"button.setEnabled(false)", (Object)TemplateUtils.resolve((NodeTarget)nodeTarget, (String)template));
    }

    @Test
    public void test_resolve_StringList() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    int target;", "  }", "}");
        NodeTarget nodeTarget = TemplateUtilsTest.getNodeStatementTarget((JavaInfo)panel, false, 0);
        List<CallSite> lines = List.of(TemplateUtils.getExpression((JavaInfo)panel) + " a", TemplateUtils.getExpression((JavaInfo)panel) + " b");
        List<String> result = List.of("this a", "this b");
        TemplateUtilsTest.assertEquals((Object)TemplateUtils.resolve((NodeTarget)nodeTarget, lines), result);
    }

    @Test
    public void test_formatResolve_StatementTarget() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    int target;", "  }", "}");
        StatementTarget target = TemplateUtilsTest.getStatementTarget((JavaInfo)panel, false, 0);
        TemplateUtilsTest.assertEquals((Object)"foo(this)", (Object)TemplateUtils.resolve((StatementTarget)target, (String)"foo({0})", (Object[])new Object[]{panel}));
    }

    @Test
    public void test_formatResolve_BodyDeclarationTarget() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    int target;", "  }", "}");
        BodyDeclarationTarget target = TemplateUtilsTest.getBodyDeclarationTarget((JavaInfo)panel, false, 0);
        TemplateUtilsTest.assertEquals((Object)"foo(this)", (Object)TemplateUtils.resolve((BodyDeclarationTarget)target, (String)"foo({0})", (Object[])new Object[]{panel}));
    }

    @Test
    public void test_addStatement() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        StatementTarget target = TemplateUtilsTest.getBlockTarget((JavaInfo)panel, true, new int[0]);
        TemplateUtils.addStatement((JavaInfo)panel, (StatementTarget)target, List.of(TemplateUtils.format((String)"{0}", (Object[])new Object[]{panel}), "\t.setEnabled(false);"));
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    this", "      .setEnabled(false);", "  }", "}");
    }

    @Test
    public void test_evaluate() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JLabel myLabel = new JLabel();", "    add(myLabel);", "    //", "    JButton myButton = new JButton();", "    add(myButton);", "  }", "}");
        ComponentInfo label = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(1);
        DualHashBidiMap bidi = new DualHashBidiMap();
        bidi.put((Object)"1", (Object)"foo");
        bidi.put((Object)"2", (Object)"bar");
        TemplateUtilsTest.assertEquals((Object)"foo bar", (Object)TemplateUtils.evaluate((String)"${1} ${2}", null, (Map)UnmodifiableBidiMap.unmodifiableBidiMap((BidiMap)bidi)));
        String expected = "a " + TemplateUtils.getExpression((JavaInfo)button) + " b";
        String actual = TemplateUtils.evaluate((String)"a ${expression} b", (JavaInfo)button);
        TemplateUtilsTest.assertEquals((Object)expected, (Object)actual);
        expected = "first " + TemplateUtils.getExpression((JavaInfo)button) + ", second " + TemplateUtils.getExpression((JavaInfo)button);
        actual = TemplateUtils.evaluate((String)"first ${expression}, second ${expression}", (JavaInfo)button);
        TemplateUtilsTest.assertEquals((Object)expected, (Object)actual);
        expected = "a " + TemplateUtils.getExpression((JavaInfo)panel) + " b";
        actual = TemplateUtils.evaluate((String)"a ${parent.expression} b", (JavaInfo)button);
        TemplateUtilsTest.assertEquals((Object)expected, (Object)actual);
        expected = "a " + TemplateUtils.getExpression((JavaInfo)label) + " b";
        actual = TemplateUtils.evaluate((String)"a ${parent.firstChild[javax.swing.JLabel].expression} b", (JavaInfo)button);
        TemplateUtilsTest.assertEquals((Object)expected, (Object)actual);
        expected = "a " + TemplateUtils.getExpression((JavaInfo)button) + " b";
        actual = TemplateUtils.evaluate((String)"a ${parent.firstChild[javax.swing.AbstractButton].expression} b", (JavaInfo)button);
        TemplateUtilsTest.assertEquals((Object)expected, (Object)actual);
        try {
            TemplateUtils.evaluate((String)"${noSuchOperator}", (JavaInfo)button);
            TemplateUtilsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            TemplateUtils.evaluate((String)"${firstChild[no.such.ComponentClass].expression}", (JavaInfo)button);
            TemplateUtilsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            TemplateUtils.evaluate((String)"${parent}", (JavaInfo)button);
            TemplateUtilsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

