/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property.editor;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.BooleanObjectPropertyEditor;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.core.model.property.editor.AbstractTextPropertyEditorTest;
import org.junit.Test;

public class BooleanObjectPropertyEditorTest
extends AbstractTextPropertyEditorTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_doubleClick() throws Exception {
        this.prepareBooleanPanel();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        Property property = panel.getPropertyByTitle("foo");
        BooleanObjectPropertyEditor editor = (BooleanObjectPropertyEditor)property.getEditor();
        editor.doubleClick(property, null);
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setFoo(true);", "  }", "}");
        editor.doubleClick(property, null);
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setFoo(false);", "  }", "}");
        editor.doubleClick(property, null);
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setFoo(true);", "  }", "}");
    }

    @Test
    public void test_doubleClick_fromNull() throws Exception {
        this.prepareBooleanPanel();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setFoo(null);", "  }", "}");
        panel.refresh();
        Property property = panel.getPropertyByTitle("foo");
        BooleanObjectPropertyEditor editor = (BooleanObjectPropertyEditor)property.getEditor();
        editor.doubleClick(property, null);
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setFoo(true);", "  }", "}");
    }

    @Test
    public void test_activate_usingKeyboard() throws Exception {
        this.prepareBooleanPanel();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setFoo(true);", "  }", "}");
        panel.refresh();
        Property property = panel.getPropertyByTitle("foo");
        BooleanObjectPropertyEditor editor = (BooleanObjectPropertyEditor)property.getEditor();
        boolean activated = editor.activate(null, property, null);
        BooleanObjectPropertyEditorTest.assertFalse((boolean)activated);
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setFoo(false);", "  }", "}");
    }

    @Test
    public void test_activate_clickOnCheckBox() throws Exception {
        this.prepareBooleanPanel();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setFoo(true);", "  }", "}");
        panel.refresh();
        Property property = panel.getPropertyByTitle("foo");
        BooleanObjectPropertyEditor editor = (BooleanObjectPropertyEditor)property.getEditor();
        boolean activated = editor.activate(null, property, new Point(10, 0));
        BooleanObjectPropertyEditorTest.assertFalse((boolean)activated);
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setFoo(false);", "  }", "}");
    }

    @Test
    public void test_activate_justClickToSelect() throws Exception {
        this.prepareBooleanPanel();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setFoo(true);", "  }", "}");
        panel.refresh();
        Property property = panel.getPropertyByTitle("foo");
        BooleanObjectPropertyEditor editor = (BooleanObjectPropertyEditor)property.getEditor();
        boolean activated = editor.activate(null, property, new Point(100, 0));
        BooleanObjectPropertyEditorTest.assertFalse((boolean)activated);
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setFoo(true);", "  }", "}");
    }

    private void prepareBooleanPanel() throws Exception {
        BooleanObjectPropertyEditorTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void setFoo(Boolean foo) {", "  }", "}"));
        BooleanObjectPropertyEditorTest.waitForAutoBuild();
    }
}

