/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.widgets;

import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.association.CompoundAssociation;
import org.eclipse.wb.core.model.association.ConstructorParentAssociation;
import org.eclipse.wb.core.model.association.InvocationChildAssociation;
import org.eclipse.wb.internal.core.model.presentation.IObjectPresentation;
import org.eclipse.wb.internal.core.utils.GenericsUtils;
import org.eclipse.wb.internal.rcp.model.widgets.AbstractPositionInfo;
import org.eclipse.wb.internal.rcp.model.widgets.ViewFormInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.BTestUtils;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.Test;

public class ViewFormTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_defaultProperties() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    ViewForm viewForm = new ViewForm(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        ViewFormInfo viewForm = (ViewFormInfo)shell.getChildrenControls().get(0);
        ViewFormTest.assertSame((Object)Boolean.FALSE, (Object)viewForm.getPropertyByTitle("borderVisible").getValue());
        ViewFormTest.assertSame((Object)Boolean.FALSE, (Object)viewForm.getPropertyByTitle("topCenterSeparate").getValue());
    }

    @Test
    public void test_childrenNo() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    ViewForm viewForm = new ViewForm(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        ViewFormInfo viewForm = (ViewFormInfo)shell.getChildrenControls().get(0);
        ViewFormTest.assertNull((Object)viewForm.getControl("setContent"));
        ViewFormTest.assertNull((Object)viewForm.getControl("setTopLeft"));
        ViewFormTest.assertNull((Object)viewForm.getControl("setTopCenter"));
        ViewFormTest.assertNull((Object)viewForm.getControl("setTopRight"));
    }

    @Test
    public void test_children() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    ViewForm viewForm = new ViewForm(this, SWT.NONE);", "    {", "      Button button = new Button(viewForm, SWT.NONE);", "      viewForm.setContent(button);", "    }", "  }", "}");
        shell.refresh();
        ViewFormInfo viewForm = (ViewFormInfo)shell.getChildrenControls().get(0);
        ControlInfo button = (ControlInfo)viewForm.getChildrenControls().get(0);
        ViewFormTest.assertSame((Object)button, (Object)viewForm.getControl("setContent"));
        CompoundAssociation compoundAssociation = (CompoundAssociation)button.getAssociation();
        List associations = compoundAssociation.getAssociations();
        Assertions.assertThat((List)associations).hasSize(2);
        ConstructorParentAssociation constructorAssociation = (ConstructorParentAssociation)associations.get(0);
        ViewFormTest.assertEquals((Object)"new Button(viewForm, SWT.NONE)", (Object)constructorAssociation.getSource());
        InvocationChildAssociation invocationAssociation = (InvocationChildAssociation)associations.get(1);
        ViewFormTest.assertEquals((Object)"viewForm.setContent(button)", (Object)invocationAssociation.getSource());
    }

    @Test
    public void test_presentation_decorateText() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    ViewForm viewForm = new ViewForm(this, SWT.NONE);", "    {", "      Button button = new Button(viewForm, SWT.NONE);", "      viewForm.setContent(button);", "    }", "  }", "}");
        shell.refresh();
        ViewFormInfo viewForm = (ViewFormInfo)shell.getChildrenControls().get(0);
        ControlInfo button = (ControlInfo)viewForm.getChildrenControls().get(0);
        ViewFormTest.assertEquals((Object)"setContent - button", (Object)ObjectInfo.getText((ObjectInfo)button));
    }

    @Test
    public void test_AbstractPositionInfo_getChildrenTree_placeholders() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    ViewForm viewForm = new ViewForm(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        ViewFormInfo viewForm = (ViewFormInfo)shell.getChildrenControls().get(0);
        List children = viewForm.getPresentation().getChildrenTree();
        ViewFormTest.assertEquals((long)4L, (long)children.size());
        ViewFormTest.assertEquals((long)4L, (long)GenericsUtils.select((Collection)children, AbstractPositionInfo.class).size());
        AbstractPositionInfo positionTopLeft = (AbstractPositionInfo)children.get(0);
        ViewFormTest.assertSame((Object)viewForm, (Object)positionTopLeft.getComposite());
        ViewFormTest.assertSame(null, (Object)positionTopLeft.getControl());
        IObjectPresentation presentation = positionTopLeft.getPresentation();
        ViewFormTest.assertNotNull((Object)presentation.getIcon());
        ViewFormTest.assertEquals((Object)"setTopLeft", (Object)presentation.getText());
        ControlInfo button = BTestUtils.createButton();
        positionTopLeft.command_CREATE(button);
        ViewFormTest.assertSame((Object)button, (Object)positionTopLeft.getControl());
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    ViewForm viewForm = new ViewForm(this, SWT.NONE);", "    {", "      Button button = new Button(viewForm, SWT.NONE);", "      viewForm.setTopLeft(button);", "    }", "  }", "}");
        children = viewForm.getPresentation().getChildrenTree();
        ViewFormTest.assertEquals((long)4L, (long)children.size());
        ViewFormTest.assertInstanceOf(ControlInfo.class, children.get(0));
        ViewFormTest.assertEquals((long)3L, (long)GenericsUtils.select((Collection)children, AbstractPositionInfo.class).size());
        AbstractPositionInfo positionContent = (AbstractPositionInfo)children.get(3);
        ViewFormTest.assertEquals((Object)"setContent", (Object)ObjectInfo.getText((ObjectInfo)positionContent));
        button = viewForm.getControl("setTopLeft");
        positionContent.command_MOVE(button);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    ViewForm viewForm = new ViewForm(this, SWT.NONE);", "    {", "      Button button = new Button(viewForm, SWT.NONE);", "      viewForm.setContent(button);", "    }", "  }", "}");
    }

    @Test
    public void test_AbstractPositionInfo_getChildrenTree_sortChildren() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    ViewForm viewForm = new ViewForm(this, SWT.NONE);", "    {", "      Button button = new Button(viewForm, SWT.NONE);", "      viewForm.setTopCenter(button);", "    }", "  }", "}");
        shell.refresh();
        ViewFormInfo viewForm = (ViewFormInfo)shell.getChildrenControls().get(0);
        ControlInfo button = (ControlInfo)viewForm.getChildrenControls().get(0);
        List children = viewForm.getPresentation().getChildrenTree();
        ViewFormTest.assertEquals((long)4L, (long)children.size());
        AbstractPositionInfo position = (AbstractPositionInfo)children.get(0);
        ViewFormTest.assertEquals((Object)"setTopLeft", (Object)ObjectInfo.getText((ObjectInfo)position));
        ViewFormTest.assertSame((Object)button, children.get(1));
        position = (AbstractPositionInfo)children.get(2);
        ViewFormTest.assertEquals((Object)"setTopRight", (Object)ObjectInfo.getText((ObjectInfo)position));
        position = (AbstractPositionInfo)children.get(3);
        ViewFormTest.assertEquals((Object)"setContent", (Object)ObjectInfo.getText((ObjectInfo)position));
    }

    @Test
    public void test_AbstractPositionInfo_getChildrenTree_sortChildren_dups() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    ViewForm viewForm = new ViewForm(this, SWT.NONE);", "    Button button = new Button(viewForm, SWT.NONE);", "    viewForm.setTopLeft(button);", "    viewForm.setTopCenter(button);", "  }", "}");
        shell.refresh();
        ViewFormInfo viewForm = (ViewFormInfo)shell.getChildrenControls().get(0);
        ControlInfo button = (ControlInfo)viewForm.getChildrenControls().get(0);
        List children = viewForm.getPresentation().getChildrenTree();
        ViewFormTest.assertEquals((long)4L, (long)children.size());
        ViewFormTest.assertSame(children.get(0), (Object)button);
        ViewFormTest.assertInstanceOf(AbstractPositionInfo.class, children.get(1));
    }

    @Test
    public void test_CREATE() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    ViewForm viewForm = new ViewForm(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        ViewFormInfo viewForm = (ViewFormInfo)shell.getChildrenControls().get(0);
        ControlInfo button = BTestUtils.createButton();
        viewForm.command_CREATE(button, "setContent");
        ViewFormTest.assertSame((Object)button, (Object)viewForm.getControl("setContent"));
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    ViewForm viewForm = new ViewForm(this, SWT.NONE);", "    {", "      Button button = new Button(viewForm, SWT.NONE);", "      viewForm.setContent(button);", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_1() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    ViewForm viewForm = new ViewForm(this, SWT.NONE);", "    {", "      Button button = new Button(viewForm, SWT.NONE);", "      viewForm.setContent(button);", "    }", "  }", "}");
        shell.refresh();
        ViewFormInfo viewForm = (ViewFormInfo)shell.getChildrenControls().get(0);
        ControlInfo button = (ControlInfo)viewForm.getChildrenControls().get(0);
        ViewFormTest.assertSame((Object)button, (Object)viewForm.getControl("setContent"));
        viewForm.command_MOVE(button, "setTopLeft");
        ViewFormTest.assertNull((Object)viewForm.getControl("setContent"));
        ViewFormTest.assertSame((Object)button, (Object)viewForm.getControl("setTopLeft"));
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    ViewForm viewForm = new ViewForm(this, SWT.NONE);", "    {", "      Button button = new Button(viewForm, SWT.NONE);", "      viewForm.setTopLeft(button);", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_2() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    ViewForm viewForm = new ViewForm(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        ViewFormInfo viewForm = (ViewFormInfo)shell.getChildrenControls().get(0);
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(1);
        viewForm.command_MOVE(button, "setTopLeft");
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    ViewForm viewForm = new ViewForm(this, SWT.NONE);", "    {", "      Button button = new Button(viewForm, SWT.NONE);", "      viewForm.setTopLeft(button);", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_3() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    ViewForm viewForm = new ViewForm(this, SWT.NONE);", "    {", "      Button button = new Button(viewForm, SWT.NONE);", "      viewForm.setTopLeft(button);", "    }", "  }", "}");
        shell.refresh();
        ViewFormInfo viewForm = (ViewFormInfo)shell.getChildrenControls().get(0);
        ControlInfo button = (ControlInfo)viewForm.getChildrenControls().get(0);
        shell.getLayout().command_MOVE(button, null);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    ViewForm viewForm = new ViewForm(this, SWT.NONE);", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_4() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    ViewForm viewForm = new ViewForm(this, SWT.NONE);", "    {", "      Button button_1 = new Button(viewForm, SWT.NONE);", "      viewForm.setTopCenter(button_1);", "    }", "    {", "      Button button_2 = new Button(viewForm, SWT.NONE);", "      viewForm.setTopRight(button_2);", "    }", "  }", "}");
        shell.refresh();
        ViewFormInfo viewForm = (ViewFormInfo)shell.getChildrenControls().get(0);
        ControlInfo button_2 = (ControlInfo)viewForm.getChildrenControls().get(1);
        viewForm.command_MOVE(button_2, "setTopLeft");
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    ViewForm viewForm = new ViewForm(this, SWT.NONE);", "    {", "      Button button_2 = new Button(viewForm, SWT.NONE);", "      viewForm.setTopLeft(button_2);", "    }", "    {", "      Button button_1 = new Button(viewForm, SWT.NONE);", "      viewForm.setTopCenter(button_1);", "    }", "  }", "}");
    }
}

