/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.example;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.wb.tests.designer.editor.DesignerEditorTestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class SwingExampleTest
extends DesignerEditorTestCase {
    private static final String PATH_PREFIX = "../examples/swing";

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        SwingExampleTest.do_projectCreate();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        SwingExampleTest.do_projectDispose();
        super.tearDown();
    }

    @Test
    public void test_swing_kmeans() throws Exception {
        this.copySwingExampleFile("kMeans", "kmeans", "KMeansCluster.java");
        this.copySwingExampleFile("kMeans", "kmeans", "KMeansFrame.java");
        this.copySwingExampleFile("kMeans", "kmeans", "KMeansPanel.java");
        SwingExampleTest.waitForAutoBuild();
        ICompilationUnit cu = m_testProject.getCompilationUnit("kmeans.KMeansFrame");
        this.openDesign(cu);
    }

    private void copySwingExampleFile(String projectName, String packageName, String className) throws Exception {
        Path sourcePath = Paths.get(PATH_PREFIX, projectName, "src", packageName, className);
        List<String> sourceLines = Files.readAllLines(sourcePath);
        SwingExampleTest.setFileContentSrc(packageName + "/" + className, StringUtils.join(sourceLines, (String)System.lineSeparator()));
    }
}

