/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.property;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.utils.ManagerUtils;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ResourceManagerTest
extends RcpModelTest {
    private Class<?> DisplayClass;
    private Object m_defaultDisplay;
    private Class<?> ManagerClass;
    private Class<?> ImageDescriptorClass;
    private Class<?> ImageClass;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        CompositeInfo shell = this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        ManagerUtils.ensure_ResourceManager((JavaInfo)shell);
        this.DisplayClass = this.m_lastLoader.loadClass("org.eclipse.swt.widgets.Display");
        this.ImageClass = this.m_lastLoader.loadClass("org.eclipse.swt.graphics.Image");
        this.ImageDescriptorClass = this.m_lastLoader.loadClass("org.eclipse.jface.resource.ImageDescriptor");
        this.ManagerClass = this.m_lastLoader.loadClass("org.eclipse.wb.swt.ResourceManager");
        this.m_defaultDisplay = ReflectionUtils.invokeMethod(this.DisplayClass, (String)"getDefault()", (Object[])new Object[0]);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        if (m_testProject != null && this.ManagerClass != null) {
            ReflectionUtils.invokeMethod(this.ManagerClass, (String)"dispose()", (Object[])new Object[0]);
        }
        super.tearDown();
        this.DisplayClass = null;
        this.ManagerClass = null;
        this.ImageDescriptorClass = null;
        this.ImageClass = null;
        this.m_defaultDisplay = null;
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_getImageDescriptor() throws Exception {
        Object imageDescriptor = ReflectionUtils.invokeMethod(this.ManagerClass, (String)"getImageDescriptor(java.lang.Class,java.lang.String)", (Object[])new Object[]{this.ManagerClass, "/javax/swing/plaf/basic/icons/JavaCup16.png"});
        ResourceManagerTest.assertNotNull((Object)imageDescriptor);
    }

    @Test
    public void test_getImage_null() throws Exception {
        Object imageDescriptor = null;
        Object image = ReflectionUtils.invokeMethod(this.ManagerClass, (String)"getImage(org.eclipse.jface.resource.ImageDescriptor)", (Object[])new Object[]{imageDescriptor});
        ResourceManagerTest.assertNull((Object)image);
    }

    @Test
    public void test_getImage() throws Exception {
        Object imageDescriptor = ReflectionUtils.invokeMethod(this.ImageDescriptorClass, (String)"createFromFile(java.lang.Class,java.lang.String)", (Object[])new Object[]{this.ManagerClass, "/javax/swing/plaf/basic/icons/JavaCup16.png"});
        ResourceManagerTest.assertNotNull((Object)imageDescriptor);
        Object image = ReflectionUtils.invokeMethod(this.ManagerClass, (String)"getImage(org.eclipse.jface.resource.ImageDescriptor)", (Object[])new Object[]{imageDescriptor});
        ResourceManagerTest.assertNotNull((Object)image);
        ResourceManagerTest.assertFalse((boolean)((Boolean)ReflectionUtils.invokeMethod((Object)image, (String)"isDisposed()", (Object[])new Object[0])));
        ResourceManagerTest.assertSame((Object)image, (Object)ReflectionUtils.invokeMethod(this.ManagerClass, (String)"getImage(org.eclipse.jface.resource.ImageDescriptor)", (Object[])new Object[]{imageDescriptor}));
        Object descriptorImageMap = ReflectionUtils.getFieldObject(this.ManagerClass, (String)"m_descriptorImageMap");
        ResourceManagerTest.assertEquals((Object)1, (Object)ReflectionUtils.invokeMethod((Object)descriptorImageMap, (String)"size()", (Object[])new Object[0]));
        ReflectionUtils.invokeMethod(this.ManagerClass, (String)"disposeImages()", (Object[])new Object[0]);
        ResourceManagerTest.assertEquals((Object)0, (Object)ReflectionUtils.invokeMethod((Object)descriptorImageMap, (String)"size()", (Object[])new Object[0]));
        ResourceManagerTest.assertTrue((boolean)((Boolean)ReflectionUtils.invokeMethod((Object)image, (String)"isDisposed()", (Object[])new Object[0])));
    }

    @Test
    public void test_decorateImage_wrongCorner() throws Exception {
        try {
            ReflectionUtils.invokeMethod(this.ManagerClass, (String)"decorateImage(org.eclipse.swt.graphics.Image,org.eclipse.swt.graphics.Image,int)", (Object[])new Object[]{null, null, 0});
            ResourceManagerTest.fail();
        }
        catch (IllegalArgumentException e) {
            ResourceManagerTest.assertEquals((Object)"Wrong decorate corner", (Object)e.getMessage());
        }
        try {
            ReflectionUtils.invokeMethod(this.ManagerClass, (String)"decorateImage(org.eclipse.swt.graphics.Image,org.eclipse.swt.graphics.Image,int)", (Object[])new Object[]{null, null, 5});
            ResourceManagerTest.fail();
        }
        catch (IllegalArgumentException e) {
            ResourceManagerTest.assertEquals((Object)"Wrong decorate corner", (Object)e.getMessage());
        }
    }

    @Test
    public void test_decorateImage() throws Exception {
        int corner = ReflectionUtils.getFieldInt(this.ManagerClass, (String)"BOTTOM_RIGHT");
        Object[] images = this.createImages();
        Object base = images[0];
        Object decorator = images[1];
        try {
            Object image = ReflectionUtils.invokeMethod(this.ManagerClass, (String)"decorateImage(org.eclipse.swt.graphics.Image,org.eclipse.swt.graphics.Image,int)", (Object[])new Object[]{base, decorator, corner});
            ResourceManagerTest.assertNotNull((Object)image);
            ResourceManagerTest.assertFalse((boolean)((Boolean)ReflectionUtils.invokeMethod((Object)image, (String)"isDisposed()", (Object[])new Object[0])));
            ResourceManagerTest.assertSame((Object)image, (Object)ReflectionUtils.invokeMethod(this.ManagerClass, (String)"decorateImage(org.eclipse.swt.graphics.Image,org.eclipse.swt.graphics.Image)", (Object[])new Object[]{base, decorator}));
        }
        finally {
            ReflectionUtils.invokeMethod((Object)base, (String)"dispose()", (Object[])new Object[0]);
            ReflectionUtils.invokeMethod((Object)decorator, (String)"dispose()", (Object[])new Object[0]);
        }
    }

    @Test
    public void test_decorateImage2() throws Exception {
        int corner = ReflectionUtils.getFieldInt(this.ManagerClass, (String)"BOTTOM_RIGHT");
        int corner1 = ReflectionUtils.getFieldInt(this.ManagerClass, (String)"TOP_LEFT");
        Object[] images = this.createImages();
        Object base = images[0];
        Object decorator = images[1];
        try {
            Object image = ReflectionUtils.invokeMethod(this.ManagerClass, (String)"decorateImage(org.eclipse.swt.graphics.Image,org.eclipse.swt.graphics.Image,int)", (Object[])new Object[]{base, decorator, corner});
            ResourceManagerTest.assertNotNull((Object)image);
            ResourceManagerTest.assertSame((Object)image, (Object)ReflectionUtils.invokeMethod(this.ManagerClass, (String)"decorateImage(org.eclipse.swt.graphics.Image,org.eclipse.swt.graphics.Image,int)", (Object[])new Object[]{base, decorator, corner}));
            Object image1 = ReflectionUtils.invokeMethod(this.ManagerClass, (String)"decorateImage(org.eclipse.swt.graphics.Image,org.eclipse.swt.graphics.Image,int)", (Object[])new Object[]{base, decorator, corner1});
            ResourceManagerTest.assertNotNull((Object)image1);
            ResourceManagerTest.assertSame((Object)image1, (Object)ReflectionUtils.invokeMethod(this.ManagerClass, (String)"decorateImage(org.eclipse.swt.graphics.Image,org.eclipse.swt.graphics.Image,int)", (Object[])new Object[]{base, decorator, corner1}));
            ResourceManagerTest.assertNotSame((Object)image, (Object)image1);
        }
        finally {
            ReflectionUtils.invokeMethod((Object)base, (String)"dispose()", (Object[])new Object[0]);
            ReflectionUtils.invokeMethod((Object)decorator, (String)"dispose()", (Object[])new Object[0]);
        }
    }

    @Test
    public void test_decorateImage_TOP_LEFT() throws Exception {
        int corner = ReflectionUtils.getFieldInt(this.ManagerClass, (String)"TOP_LEFT");
        this.test_decorateImage(corner);
    }

    @Test
    public void test_decorateImage_TOP_RIGHT() throws Exception {
        int corner = ReflectionUtils.getFieldInt(this.ManagerClass, (String)"TOP_RIGHT");
        this.test_decorateImage(corner);
    }

    @Test
    public void test_decorateImage_BOTTOM_LEFT() throws Exception {
        int corner = ReflectionUtils.getFieldInt(this.ManagerClass, (String)"BOTTOM_LEFT");
        this.test_decorateImage(corner);
    }

    @Test
    public void test_decorateImage_BOTTOM_RIGHT() throws Exception {
        int corner = ReflectionUtils.getFieldInt(this.ManagerClass, (String)"BOTTOM_RIGHT");
        this.test_decorateImage(corner);
    }

    private void test_decorateImage(int corner) throws Exception {
        Object[] images = this.createImages();
        Object base = images[0];
        Object decorator = images[1];
        try {
            Object image = ReflectionUtils.invokeMethod(this.ManagerClass, (String)"decorateImage(org.eclipse.swt.graphics.Image,org.eclipse.swt.graphics.Image,int)", (Object[])new Object[]{base, decorator, corner});
            ResourceManagerTest.assertNotNull((Object)image);
            ResourceManagerTest.assertFalse((boolean)((Boolean)ReflectionUtils.invokeMethod((Object)image, (String)"isDisposed()", (Object[])new Object[0])));
            ResourceManagerTest.assertSame((Object)image, (Object)ReflectionUtils.invokeMethod(this.ManagerClass, (String)"decorateImage(org.eclipse.swt.graphics.Image,org.eclipse.swt.graphics.Image,int)", (Object[])new Object[]{base, decorator, corner}));
            int blackPixel = ResourceManagerTest.getPixels(decorator)[0][0];
            int[][] result = ResourceManagerTest.getPixels(base);
            if (corner == 1) {
                result[0][0] = blackPixel;
            } else if (corner == 2) {
                result[2][0] = blackPixel;
            } else if (corner == 3) {
                result[0][2] = blackPixel;
            } else if (corner == 4) {
                result[2][2] = blackPixel;
            }
            ResourceManagerTest.assertEquals((Object)ResourceManagerTest.getText(result), (Object)ResourceManagerTest.getText(ResourceManagerTest.getPixels(image)));
        }
        finally {
            ReflectionUtils.invokeMethod((Object)base, (String)"dispose()", (Object[])new Object[0]);
            ReflectionUtils.invokeMethod((Object)decorator, (String)"dispose()", (Object[])new Object[0]);
        }
    }

    private Object[] createImages() throws Exception {
        Constructor constructor = ReflectionUtils.getConstructorBySignature(this.ImageClass, (String)"<init>(org.eclipse.swt.graphics.Device,int,int)");
        Object baseImage = constructor.newInstance(null, 3, 3);
        this.fillImage(baseImage, 1, 3, 3);
        Object decoratorImage = constructor.newInstance(null, 1, 1);
        this.fillImage(decoratorImage, 2, 1, 1);
        return new Object[]{baseImage, decoratorImage};
    }

    private void fillImage(Object image, int color, int width, int height) throws Exception {
        Class<?> GCClass = this.m_lastLoader.loadClass("org.eclipse.swt.graphics.GC");
        Object gc = ReflectionUtils.getConstructorBySignature(GCClass, (String)"<init>(org.eclipse.swt.graphics.Drawable)").newInstance(image);
        Object colorObject = ReflectionUtils.invokeMethod((Object)this.m_defaultDisplay, (String)"getSystemColor(int)", (Object[])new Object[]{color});
        ReflectionUtils.invokeMethod(gc, (String)"setBackground(org.eclipse.swt.graphics.Color)", (Object[])new Object[]{colorObject});
        ReflectionUtils.invokeMethod(gc, (String)"fillRectangle(int,int,int,int)", (Object[])new Object[]{0, 0, width, height});
        ReflectionUtils.invokeMethod(gc, (String)"dispose()", (Object[])new Object[0]);
    }

    private static int[][] getPixels(Object image) throws Exception {
        Object data = ReflectionUtils.invokeMethod((Object)image, (String)"getImageData()", (Object[])new Object[0]);
        Object palette = ReflectionUtils.getFieldObject((Object)data, (String)"palette");
        int width = ReflectionUtils.getFieldInt((Object)data, (String)"width");
        int height = ReflectionUtils.getFieldInt((Object)data, (String)"height");
        int[][] pixels = new int[width][height];
        int i = 0;
        while (i < width) {
            int j = 0;
            while (j < height) {
                int pixel = (Integer)ReflectionUtils.invokeMethod((Object)data, (String)"getPixel(int,int)", (Object[])new Object[]{i, j});
                Object rgb = ReflectionUtils.invokeMethod((Object)palette, (String)"getRGB(int)", (Object[])new Object[]{pixel});
                pixels[i][j] = ReflectionUtils.getFieldInt((Object)rgb, (String)"red");
                ++j;
            }
            ++i;
        }
        return pixels;
    }

    private static String getText(int[][] data) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < data.length) {
            int[] line = data[i];
            int j = 0;
            while (j < line.length) {
                buffer.append(line[j]);
                buffer.append(' ');
                ++j;
            }
            buffer.append('\n');
            ++i;
        }
        return buffer.toString();
    }

    @Test
    public void test_getPluginImage() throws Exception {
        URL[] urls = new URL[]{m_testProject.getProject().getFile("bin").getLocation().toFile().toURL()};
        URLClassLoader classLoader = new URLClassLoader(urls, ((Object)((Object)this)).getClass().getClassLoader());
        Class<?> local_ManagerClass = classLoader.loadClass("org.eclipse.wb.swt.ResourceManager");
        Object image = ReflectionUtils.invokeMethod(local_ManagerClass, (String)"getPluginImage(java.lang.String,java.lang.String)", (Object[])new Object[]{"org.eclipse.jdt.ui", "/icons/full/elcl16/ch_cancel.png"});
        ResourceManagerTest.assertNotNull((Object)image);
        ResourceManagerTest.assertFalse((boolean)((Boolean)ReflectionUtils.invokeMethod((Object)image, (String)"isDisposed()", (Object[])new Object[0])));
        ResourceManagerTest.assertSame((Object)image, (Object)ReflectionUtils.invokeMethod(local_ManagerClass, (String)"getPluginImage(java.lang.String,java.lang.String)", (Object[])new Object[]{"org.eclipse.jdt.ui", "/icons/full/elcl16/ch_cancel.png"}));
        ResourceManagerTest.assertNull((Object)ReflectionUtils.invokeMethod(local_ManagerClass, (String)"getPluginImage(java.lang.String,java.lang.String)", (Object[])new Object[]{"org.eclipse.jdt.ui", "zzz"}));
        Object URLImageMap = ReflectionUtils.getFieldObject(local_ManagerClass, (String)"m_URLImageMap");
        ResourceManagerTest.assertEquals((Object)1, (Object)ReflectionUtils.invokeMethod((Object)URLImageMap, (String)"size()", (Object[])new Object[0]));
        ReflectionUtils.invokeMethod(local_ManagerClass, (String)"disposeImages()", (Object[])new Object[0]);
        ResourceManagerTest.assertEquals((Object)0, (Object)ReflectionUtils.invokeMethod((Object)URLImageMap, (String)"size()", (Object[])new Object[0]));
        ResourceManagerTest.assertTrue((boolean)((Boolean)ReflectionUtils.invokeMethod((Object)image, (String)"isDisposed()", (Object[])new Object[0])));
    }

    @Test
    public void test_getPluginImageDescriptor() throws Exception {
        URL[] urls = new URL[]{m_testProject.getProject().getFile("bin").getLocation().toFile().toURL()};
        URLClassLoader classLoader = new URLClassLoader(urls, ((Object)((Object)this)).getClass().getClassLoader());
        Class<?> local_ManagerClass = classLoader.loadClass("org.eclipse.wb.swt.ResourceManager");
        ResourceManagerTest.assertNotNull((Object)ReflectionUtils.invokeMethod(local_ManagerClass, (String)"getPluginImageDescriptor(java.lang.String,java.lang.String)", (Object[])new Object[]{"org.eclipse.jdt.ui", "/icons/full/elcl16/ch_cancel.png"}));
        ResourceManagerTest.assertNull((Object)ReflectionUtils.invokeMethod(local_ManagerClass, (String)"getPluginImageDescriptor(java.lang.String,java.lang.String)", (Object[])new Object[]{"org.eclipse.jdt.ui", "zzz"}));
    }
}

