/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.MigLayout;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.wb.core.gef.policy.layout.grid.IGridInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.swing.MigLayout.model.MigColumnInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.MigLayoutInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.MigRowInfo;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingGefTest;
import org.eclipse.wb.tests.designer.swing.model.layout.AbstractLayoutTest;
import org.eclipse.wb.tests.designer.swing.model.layout.MigLayout.AbstractMigLayoutTest;
import org.eclipse.wb.tests.gef.GraphicalRobot;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class MigLayoutGefTest
extends SwingGefTest {
    private static int COL_GAP = 7;
    private static int ROW_GAP = 7;
    private static int COL_VIRTUAL_SIZE = 25;
    private static int ROW_VIRTUAL_SIZE = 25;
    private static int COL_INSET = 7;
    private static int ROW_INSET = 7;
    private ContainerInfo panel;
    private MigLayoutInfo layout;
    private GraphicalRobot horizontalRobot;
    private GraphicalRobot verticalRobot;

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        AbstractLayoutTest.configureForTest();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        AbstractLayoutTest.configureDefaults();
        super.tearDown();
    }

    @Override
    protected void configureNewProject() throws Exception {
        super.configureNewProject();
        AbstractMigLayoutTest.do_configureNewProject();
    }

    @Test
    public void test_setLayout_empty() throws Exception {
        this.openPanel("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        this.loadCreationTool("net.miginfocom.swing.MigLayout");
        this.canvas.moveTo((Object)this.panel, 0.5, 0.5).click();
        this.assertEditor("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout('', '[]', '[]'));", "  }", "}");
    }

    @Test
    public void test_setLayout_replaceGridBagLayout() throws Exception {
        this.openPanel("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new GridBagLayout());", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "  }", "}");
        this.canvas.select(this.panel);
        this.loadCreationTool("net.miginfocom.swing.MigLayout");
        this.canvas.moveTo((Object)this.panel, 0.5, 0.5).click();
        String source = this.m_lastEditor.getSource();
        Assertions.assertThat((String)source).contains(new CharSequence[]{"new MigLayout("});
    }

    @Test
    public void test_CREATE_filled() throws Exception {
        this.openPanel("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout());", "    {", "      JButton button = new JButton('Existing JButton');", "      add(button, 'cell 0 0');", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)MigLayoutGefTest.getJavaInfoByName("button");
        this.loadButtonWithText();
        this.canvas.moveTo((Object)button, 0.5, 0.55).click();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout());", "    {", "      JButton button = new JButton('Existing JButton');", "      add(button, 'flowy,cell 0 0');", "    }", "    {", "      JButton button = new JButton('New button');", "      add(button, 'cell 0 0');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_empty() throws Exception {
        this.openPanel("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout());", "  }", "}");
        this.loadButtonWithText();
        this.canvas.moveTo((Object)this.panel, COL_INSET, ROW_INSET).click();
        this.assertEditor("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout());", "    {", "      JButton button = new JButton('New button');", "      add(button, 'cell 0 0');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_virtual_1x1() throws Exception {
        this.openPanel("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout());", "  }", "}");
        this.loadButtonWithText();
        int x = COL_INSET + COL_VIRTUAL_SIZE + COL_GAP + COL_VIRTUAL_SIZE / 2;
        int y = ROW_INSET + ROW_VIRTUAL_SIZE + ROW_GAP + ROW_VIRTUAL_SIZE / 2;
        this.canvas.moveTo((Object)this.panel, x, y);
        this.canvas.click();
        this.assertEditor("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout('', '[][]', '[][]'));", "    {", "      JButton button = new JButton('New button');", "      add(button, 'cell 1 1');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_virtual_1x0() throws Exception {
        this.openPanel("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout());", "  }", "}");
        this.loadButtonWithText();
        int x = COL_INSET + COL_VIRTUAL_SIZE + COL_GAP + COL_VIRTUAL_SIZE / 2;
        int y = ROW_INSET + ROW_VIRTUAL_SIZE / 2;
        this.canvas.moveTo((Object)this.panel, x, y);
        this.canvas.click();
        this.assertEditor("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout('', '[][]', '[]'));", "    {", "      JButton button = new JButton('New button');", "      add(button, 'cell 1 0');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_virtual_0x1() throws Exception {
        this.openPanel("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout());", "  }", "}");
        this.loadButtonWithText();
        int x = COL_INSET + COL_VIRTUAL_SIZE / 2;
        int y = ROW_INSET + ROW_VIRTUAL_SIZE + ROW_GAP + ROW_VIRTUAL_SIZE / 2;
        this.canvas.moveTo((Object)this.panel, x, y);
        this.canvas.click();
        this.assertEditor("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout('', '[]', '[][]'));", "    {", "      JButton button = new JButton('New button');", "      add(button, 'cell 0 1');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_appendToColumn_0x1() throws Exception {
        this.openPanel("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout());", "    {", "      JButton existing = new JButton('Existing JButton');", "      add(existing, 'cell 0 0');", "    }", "  }", "}");
        ComponentInfo existing = (ComponentInfo)MigLayoutGefTest.getJavaInfoByName("existing");
        this.loadButtonWithText();
        this.canvas.target(existing).inX(0.5).outY(ROW_GAP + 1).move();
        this.canvas.click();
        this.assertEditor("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout('', '[]', '[][]'));", "    {", "      JButton existing = new JButton('Existing JButton');", "      add(existing, 'cell 0 0');", "    }", "    {", "      JButton button = new JButton('New button');", "      add(button, 'cell 0 1');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_appendToRow_1x0() throws Exception {
        this.openPanel("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout());", "    {", "      JButton existing = new JButton('Existing JButton');", "      add(existing, 'cell 0 0');", "    }", "  }", "}");
        ComponentInfo existing = (ComponentInfo)MigLayoutGefTest.getJavaInfoByName("existing");
        this.loadButtonWithText();
        this.canvas.target(existing).inY(0.5).outX(COL_GAP + 1).move();
        this.canvas.click();
        this.assertEditor("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout('', '[][]', '[]'));", "    {", "      JButton existing = new JButton('Existing JButton');", "      add(existing, 'cell 0 0');", "    }", "    {", "      JButton button = new JButton('New button');", "      add(button, 'cell 1 0');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_beforeFirstRow() throws Exception {
        this.openPanel("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout());", "    {", "      JButton existing = new JButton('Existing JButton');", "      add(existing, 'cell 0 0');", "    }", "  }", "}");
        ComponentInfo existing = (ComponentInfo)MigLayoutGefTest.getJavaInfoByName("existing");
        this.loadButtonWithText();
        this.canvas.target(existing).inX(0.5).outY(-2).move();
        this.canvas.click();
        this.assertEditor("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout('', '[]', '[][]'));", "    {", "      JButton button = new JButton('New button');", "      add(button, 'cell 0 0');", "    }", "    {", "      JButton existing = new JButton('Existing JButton');", "      add(existing, 'cell 0 1');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_beforeFirstColumn() throws Exception {
        this.openPanel("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout());", "    {", "      JButton existing = new JButton('Existing JButton');", "      add(existing, 'cell 0 0');", "    }", "  }", "}");
        ComponentInfo existing = (ComponentInfo)MigLayoutGefTest.getJavaInfoByName("existing");
        this.loadButtonWithText();
        this.canvas.target(existing).inY(0.5).outX(-2).move();
        this.canvas.click();
        this.assertEditor("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout('', '[][]', '[]'));", "    {", "      JButton button = new JButton('New button');", "      add(button, 'cell 0 0');", "    }", "    {", "      JButton existing = new JButton('Existing JButton');", "      add(existing, 'cell 1 0');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_insertRow_endOfComponent() throws Exception {
        this.openPanel("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout());", "    {", "      JButton button_1 = new JButton('Button 1');", "      add(button_1, 'cell 0 0');", "    }", "    {", "      JButton button_2 = new JButton('Button 2');", "      add(button_2, 'cell 0 1');", "    }", "  }", "}");
        ComponentInfo button_1 = (ComponentInfo)MigLayoutGefTest.getJavaInfoByName("button_1");
        this.loadButtonWithText();
        this.canvas.target(button_1).inX(0.5).inY(-2).move();
        this.canvas.click();
        this.assertEditor("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout('', '[]', '[][][]'));", "    {", "      JButton button_1 = new JButton('Button 1');", "      add(button_1, 'cell 0 0');", "    }", "    {", "      JButton button = new JButton('New button');", "      add(button, 'cell 0 1');", "    }", "    {", "      JButton button_2 = new JButton('Button 2');", "      add(button_2, 'cell 0 2');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_insertColumn_endOfComponent() throws Exception {
        this.openPanel("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout());", "    {", "      JButton button_1 = new JButton('Button 1');", "      add(button_1, 'cell 0 0');", "    }", "    {", "      JButton button_2 = new JButton('Button 2');", "      add(button_2, 'cell 1 0');", "    }", "  }", "}");
        ComponentInfo button_1 = (ComponentInfo)MigLayoutGefTest.getJavaInfoByName("button_1");
        this.loadButtonWithText();
        this.canvas.target(button_1).inY(0.5).inX(-2).move();
        this.canvas.click();
        this.assertEditor("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout('', '[][][]', '[]'));", "    {", "      JButton button_1 = new JButton('Button 1');", "      add(button_1, 'cell 0 0');", "    }", "    {", "      JButton button = new JButton('New button');", "      add(button, 'cell 1 0');", "    }", "    {", "      JButton button_2 = new JButton('Button 2');", "      add(button_2, 'cell 2 0');", "    }", "  }", "}");
    }

    @Test
    public void test_CREATE_inherited_columnOperations() throws Exception {
        MigLayoutGefTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyPanel extends JPanel {", "  public MyPanel() {", "    setLayout(new MigLayout('', '[][]', '[]'));", "  }", "}"));
        MigLayoutGefTest.waitForAutoBuild();
        this.openPanel("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    {", "      JButton button_1 = new JButton('JButton 1');", "      add(button_1, 'cell 0 0');", "    }", "    {", "      JButton button_2 = new JButton('JButton 2');", "      add(button_2, 'cell 1 0');", "    }", "  }", "}");
        this.loadButton();
        ComponentInfo button_1 = (ComponentInfo)MigLayoutGefTest.getJavaInfoByName("button_1");
        this.canvas.target(button_1).inY(0.5).inX(-2).move();
        this.canvas.assertCommandNull();
        ComponentInfo button_2 = (ComponentInfo)MigLayoutGefTest.getJavaInfoByName("button_2");
        this.canvas.target(button_2).inY(0.5).outX(COL_GAP + 1).move();
        this.canvas.assertCommandNull();
    }

    @Test
    public void test_CREATE_inherited_rowOperations() throws Exception {
        MigLayoutGefTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyPanel extends JPanel {", "  public MyPanel() {", "    setLayout(new MigLayout('', '[]', '[][]'));", "  }", "}"));
        MigLayoutGefTest.waitForAutoBuild();
        this.openPanel("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    {", "      JButton button_1 = new JButton('JButton 1');", "      add(button_1, 'cell 0 0');", "    }", "    {", "      JButton button_2 = new JButton('JButton 2');", "      add(button_2, 'cell 0 1');", "    }", "  }", "}");
        this.loadButton();
        ComponentInfo button_1 = (ComponentInfo)MigLayoutGefTest.getJavaInfoByName("button_1");
        this.canvas.target(button_1).inX(0.5).inY(-2).move();
        this.canvas.assertCommandNull();
        ComponentInfo button_2 = (ComponentInfo)MigLayoutGefTest.getJavaInfoByName("button_2");
        this.canvas.target(button_2).inX(0.5).outY(ROW_GAP + 1).move();
        MigLayoutGefTest.waitEventLoop(5000);
        this.canvas.assertCommandNull();
    }

    @Ignore
    @Test
    public void test_PASTE_virtual_1x0() throws Exception {
        this.openPanel("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout());", "    {", "      JButton existing = new JButton('My JButton');", "      add(existing, 'cell 0 0');", "    }", "  }", "}");
        ComponentInfo existing = (ComponentInfo)MigLayoutGefTest.getJavaInfoByName("existing");
        this.doCopyPaste((JavaInfo)existing);
        this.canvas.target(existing).inY(0.5).outX(COL_GAP + 1).move();
        this.canvas.click();
        this.assertEditor("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout('', '[][]', '[]'));", "    {", "      JButton existing = new JButton('My JButton');", "      add(existing, 'cell 0 0');", "    }", "    {", "      JButton button = new JButton('My JButton');", "      add(button, 'cell 1 0');", "    }", "  }", "}");
    }

    @Test
    public void test_MOVE_virtual_1x0() throws Exception {
        this.openPanel("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout());", "    {", "      JButton button = new JButton('My JButton');", "      add(button, 'cell 0 0');", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)MigLayoutGefTest.getJavaInfoByName("button");
        this.canvas.beginDrag(button);
        this.canvas.target(button).inY(0.5).outX(COL_GAP + 1).drag();
        this.canvas.endDrag();
        this.assertEditor("// filler filler filler filler filler", "public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout('', '[][]', '[]'));", "    {", "      JButton button = new JButton('My JButton');", "      add(button, 'cell 1 0');", "    }", "  }", "}");
    }

    @Test
    public void test_ADD_virtual_0x0() throws Exception {
        this.openPanel("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      JButton button = new JButton('My JButton');", "      add(button, BorderLayout.NORTH);", "    }", "    {", "      JPanel inner = new JPanel();", "      add(inner, BorderLayout.CENTER);", "      inner.setLayout(new MigLayout());", "    }", "  }", "}");
        ComponentInfo button = (ComponentInfo)MigLayoutGefTest.getJavaInfoByName("button");
        this.panel = (ContainerInfo)MigLayoutGefTest.getJavaInfoByName("inner");
        this.canvas.beginDrag(button);
        this.canvas.target(this.panel).in(COL_INSET, ROW_INSET).drag();
        this.canvas.endDrag();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    {", "      JPanel inner = new JPanel();", "      add(inner, BorderLayout.CENTER);", "      inner.setLayout(new MigLayout());", "      {", "        JButton button = new JButton('My JButton');", "        inner.add(button, 'cell 0 0');", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_headerColumn_MOVE_inherited() throws Exception {
        MigLayoutGefTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyPanel extends JPanel {", "  public MyPanel() {", "    setLayout(new MigLayout('', '[150px][100px]', ''));", "  }", "}"));
        MigLayoutGefTest.waitForAutoBuild();
        this.openPanel("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        this.canvas.select(this.panel);
        List columns = this.layout.getColumns();
        MigColumnInfo sourceColumn = (MigColumnInfo)columns.get(0);
        MigColumnInfo relativeColumn = (MigColumnInfo)columns.get(1);
        this.horizontalRobot.beginDrag(sourceColumn).dragTo((Object)relativeColumn, -5.0, 0.5);
        this.horizontalRobot.assertCommandNull();
    }

    @Test
    public void test_headerColumn_MOVE_forward_beforeOther() throws Exception {
        this.openPanel("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout('', '[150px][100px][50px]', ''));", "  }", "}");
        this.canvas.select(this.panel);
        List columns = this.layout.getColumns();
        MigColumnInfo sourceColumn = (MigColumnInfo)columns.get(0);
        MigColumnInfo relativeColumn = (MigColumnInfo)columns.get(1);
        this.horizontalRobot.beginDrag(sourceColumn).dragTo((Object)relativeColumn, -5.0, 0.5);
        this.horizontalRobot.endDrag();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout('', '[100px][150px][50px]', '[]'));", "  }", "}");
    }

    @Test
    public void test_headerColumn_MOVE_forward_afterLast() throws Exception {
        this.openPanel("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout('', '[150px][100px][50px]', ''));", "  }", "}");
        this.canvas.select(this.panel);
        List columns = this.layout.getColumns();
        MigColumnInfo sourceColumn = (MigColumnInfo)columns.get(0);
        MigColumnInfo relativeColumn = (MigColumnInfo)columns.get(2);
        this.horizontalRobot.beginDrag(sourceColumn).dragTo((Object)relativeColumn, -5.0, 0.5);
        this.horizontalRobot.endDrag();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout('', '[100px][50px][150px]', '[]'));", "  }", "}");
    }

    @Test
    public void test_headerRow_MOVE_inherited() throws Exception {
        MigLayoutGefTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyPanel extends JPanel {", "  public MyPanel() {", "    setLayout(new MigLayout('', '', '[100px][75px]'));", "  }", "}"));
        MigLayoutGefTest.waitForAutoBuild();
        this.openPanel("// filler filler filler filler filler", "// filler filler filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        this.canvas.select(this.panel);
        List rows = this.layout.getRows();
        MigRowInfo sourceRow = (MigRowInfo)rows.get(0);
        MigRowInfo relativeRow = (MigRowInfo)rows.get(1);
        this.verticalRobot.beginDrag(sourceRow).dragTo((Object)relativeRow, 0.5, -5.0);
        this.verticalRobot.assertCommandNull();
    }

    @Test
    public void test_headerRow_MOVE_forward_beforeOther() throws Exception {
        this.openPanel("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout('', '', '[100px][75px][50px]'));", "  }", "}");
        this.canvas.select(this.panel);
        List rows = this.layout.getRows();
        MigRowInfo sourceRow = (MigRowInfo)rows.get(0);
        MigRowInfo relativeRow = (MigRowInfo)rows.get(1);
        this.verticalRobot.beginDrag(sourceRow).dragTo((Object)relativeRow, 0.5, -5.0);
        this.verticalRobot.endDrag();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout('', '[]', '[75px][100px][50px]'));", "  }", "}");
    }

    @Test
    public void test_headerRow_MOVE_forward_afterLast() throws Exception {
        this.openPanel("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout('', '', '[100px][75px][50px]'));", "  }", "}");
        this.canvas.select(this.panel);
        List rows = this.layout.getRows();
        MigRowInfo sourceRow = (MigRowInfo)rows.get(0);
        MigRowInfo relativeRow = (MigRowInfo)rows.get(2);
        this.verticalRobot.beginDrag(sourceRow).dragTo((Object)relativeRow, 0.5, -5.0);
        this.verticalRobot.endDrag();
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    setLayout(new MigLayout('', '[]', '[75px][50px][100px]'));", "  }", "}");
    }

    @Override
    public String getTestSource(String ... lines) {
        lines = CodeUtils.join((String[])new String[]{"import net.miginfocom.layout.*;", "import net.miginfocom.swing.*;"}, (String[])lines);
        return super.getTestSource(lines);
    }

    private void openPanel(String ... lines) throws Exception {
        this.panel = this.openContainer(lines);
        if (this.panel.getLayout() instanceof MigLayoutInfo) {
            this.layout = (MigLayoutInfo)this.panel.getLayout();
            IGridInfo grid = this.layout.getGridInfo();
            COL_VIRTUAL_SIZE = grid.getVirtualColumnSize();
            ROW_VIRTUAL_SIZE = grid.getVirtualRowSize();
            COL_GAP = grid.getVirtualColumnGap();
            ROW_GAP = grid.getVirtualRowGap();
            COL_INSET = grid.getColumnIntervals()[0].begin();
            ROW_INSET = grid.getRowIntervals()[0].begin();
        }
        this.horizontalRobot = new GraphicalRobot(this.m_headerHorizontal);
        this.verticalRobot = new GraphicalRobot(this.m_headerVertical);
    }
}

