/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.component;

import java.util.List;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.component.JTabbedPaneInfo;
import org.eclipse.wb.internal.swing.model.component.JTabbedPaneTabInfo;
import org.eclipse.wb.tests.designer.swing.SwingGefTest;
import org.junit.Test;

public class JTabbedPaneGefTest
extends SwingGefTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_childrenForActiveTab() throws Exception {
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {", "  public Test() {", "    setLayout(new BorderLayout());", "    JTabbedPane tabbedPane = new JTabbedPane(JTabbedPane.TOP);", "    add(tabbedPane);", "    {", "      JPanel panel_1 = new JPanel();", "      panel_1.setLayout(null);", "      tabbedPane.addTab('AAAAAA', panel_1);", "      {", "        JButton button_1 = new JButton();", "        button_1.setBounds(10, 10, 100, 100);", "        panel_1.add(button_1);", "      }", "    }", "    {", "      JPanel panel_2 = new JPanel();", "      panel_2.setLayout(null);", "      tabbedPane.addTab('BBBBBB', panel_2);", "      {", "        JButton button_2 = new JButton();", "        button_2.setBounds(110, 10, 100, 100);", "        panel_2.add(button_2);", "      }", "    }", "  }", "}");
        JTabbedPaneInfo tabbedPane = (JTabbedPaneInfo)panel.getChildrenComponents().get(0);
        ContainerInfo panel_1 = (ContainerInfo)tabbedPane.getChildrenComponents().get(0);
        ContainerInfo panel_2 = (ContainerInfo)tabbedPane.getChildrenComponents().get(1);
        ComponentInfo button_1 = (ComponentInfo)panel_1.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)panel_2.getChildrenComponents().get(0);
        JTabbedPaneGefTest.assertNotNull((Object)this.canvas.getEditPart(panel_1));
        JTabbedPaneGefTest.assertNotNull((Object)this.canvas.getEditPart(button_1));
        this.canvas.assertNullEditPart(panel_2);
        this.canvas.assertNullEditPart(button_2);
        this.canvas.target(tabbedPane).in(50, 50).move().click();
        this.assertSelectionModels(button_1);
        this.canvas.target(tabbedPane).in(150, 50).move().click();
        this.assertSelectionModels(panel_1);
    }

    @Test
    public void test_tab_MOVE() throws Exception {
        ContainerInfo panel = this.openContainer("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane();", "    add(tabbed);", "    {", "      JLabel label = new JLabel();", "      tabbed.addTab('111', label);", "    }", "    {", "      JButton button = new JButton();", "      tabbed.addTab('222', button);", "    }", "  }", "}");
        JTabbedPaneInfo tabbedPane = (JTabbedPaneInfo)panel.getChildrenComponents().get(0);
        ComponentInfo label = (ComponentInfo)tabbedPane.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)tabbedPane.getChildrenComponents().get(1);
        this.canvas.assertNotNullEditPart(label);
        this.canvas.assertNullEditPart(button);
        List tabs = tabbedPane.getTabs();
        JTabbedPaneTabInfo labelTab = (JTabbedPaneTabInfo)tabs.get(0);
        JTabbedPaneTabInfo buttonTab = (JTabbedPaneTabInfo)tabs.get(1);
        this.canvas.beginDrag(buttonTab).dragTo((Object)labelTab, 5, 5).endDrag();
        this.canvas.assertNullEditPart(label);
        this.canvas.assertNotNullEditPart(button);
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JTabbedPane tabbed = new JTabbedPane();", "    add(tabbed);", "    {", "      JButton button = new JButton();", "      tabbed.addTab('222', button);", "    }", "    {", "      JLabel label = new JLabel();", "      tabbed.addTab('111', label);", "    }", "  }", "}");
    }
}

