/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.component;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Calendar;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.table.PropertyTooltipProvider;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.property.editor.models.spinner.SpinnerModelPropertyEditor;
import org.eclipse.wb.tests.designer.Expectations;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.Ignore;
import org.junit.Test;

public class JSpinnerTest
extends SwingModelTest {
    @Test
    public void test_setEditor() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JSpinner spinner = new JSpinner();", "    spinner.setEditor(new JSpinner.NumberEditor(spinner, '#'));", "    add(spinner);", "  }", "}");
        panel.refresh();
        JSpinnerTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_numberModel_Integer() throws Exception {
        String source = "new SpinnerNumberModel(15, 10, 20, 1)";
        String expectedText = "Integer, 15, 10, 20, 1";
        String expectedTooltip = "type=Integer value=15 start=10 end=20 step=1";
        this.assertEditorTextTooltip(source, expectedText, expectedTooltip);
    }

    @Test
    public void test_numberModel_Double() throws Exception {
        String source = "new SpinnerNumberModel(15.0, 10.2, 20.0, 1.2)";
        String expectedText = "Double, 15.0, 10.2, 20.0, 1.2";
        String expectedTooltip = "type=Double value=15.0 start=10.2 end=20.0 step=1.2";
        this.assertEditorTextTooltip(source, expectedText, expectedTooltip);
    }

    @Test
    public void test_numberModel_null() throws Exception {
        String source = "new SpinnerNumberModel(15, 0, null, 1)";
        String expectedText = "Integer, 15, 0, null, 1";
        String expectedTooltip = "type=Integer value=15 start=0 end=null step=1";
        this.assertEditorTextTooltip(source, expectedText, expectedTooltip);
    }

    @Test
    public void test_listModel() throws Exception {
        String source = "new SpinnerListModel(new Object[]{\"aaa\", \"bbb\", \"ccc\"})";
        String expectedText = "aaa, bbb, ccc";
        String expectedTooltip = "aaa\nbbb\nccc";
        this.assertEditorTextTooltip(source, expectedText, expectedTooltip);
    }

    @Test
    public void test_dateModel_getDateStep() throws Exception {
        Field[] declaredFields;
        Field[] fieldArray = declaredFields = Calendar.class.getDeclaredFields();
        int n = declaredFields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            int modifiers = field.getModifiers();
            if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers)) {
                String expectedName = field.getName();
                if (expectedName.equals("DATE")) {
                    expectedName = "DAY_OF_MONTH";
                }
                if (expectedName.equals("ZONE_OFFSET")) break;
                String actualName = (String)ReflectionUtils.invokeMethod2(SpinnerModelPropertyEditor.class, (String)"getDateStep", Integer.TYPE, (Object)field.getInt(null));
                JSpinnerTest.assertEquals((Object)expectedName, (Object)actualName);
            }
            ++n2;
        }
        JSpinnerTest.assertNull((Object)ReflectionUtils.invokeMethod2(SpinnerModelPropertyEditor.class, (String)"getDateStep", Integer.TYPE, (Object)-559038737));
    }

    @Ignore
    @Test
    public void test_dateModel() throws Exception {
        String source = "new SpinnerDateModel(new java.util.Date(0), null, null, java.util.Calendar.SECOND)";
        String expectedText = Expectations.get("01.01.1970 03:00:00, null, null, SECOND", new Expectations.StrValue("America/New_York", "31.12.1969 19:00:00, null, null, SECOND"), new Expectations.StrValue("America/Los_Angeles", "31.12.1969 16:00:00, null, null, SECOND"));
        String expectedTooltip = Expectations.get("value=01.01.1970 03:00:00\nstart=null\nend=null\nstep=SECOND", new Expectations.StrValue("America/New_York", "value=31.12.1969 19:00:00\nstart=null\nend=null\nstep=SECOND"), new Expectations.StrValue("America/Los_Angeles", "value=31.12.1969 16:00:00\nstart=null\nend=null\nstep=SECOND"));
        this.assertEditorTextTooltip(source, expectedText, expectedTooltip);
    }

    private void assertEditorTextTooltip(String modelSource, String expectedText, String expectedTooltip) throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    JSpinner spinner = new JSpinner();", "    spinner.setModel(" + modelSource + ");", "    add(spinner);", "  }", "}");
        panel.refresh();
        ComponentInfo spinner = (ComponentInfo)panel.getChildrenComponents().get(0);
        Property modelProperty = spinner.getPropertyByTitle("model");
        PropertyEditor modelEditor = modelProperty.getEditor();
        String text = (String)ReflectionUtils.invokeMethod2((Object)modelEditor, (String)"getText", Property.class, (Object)modelProperty);
        JSpinnerTest.assertEquals((Object)expectedText, (Object)text);
        String tooltip = JSpinnerTest.getPropertyTooltipText((IAdaptable)modelEditor, modelProperty);
        JSpinnerTest.assertEquals((Object)expectedTooltip, (Object)tooltip);
        PropertyTooltipProvider provider = (PropertyTooltipProvider)modelEditor.getAdapter(PropertyTooltipProvider.class);
        JSpinnerTest.assertSame((Object)1, (Object)provider.getTooltipPosition());
    }
}

