/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.forms.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.jface.action.IAction;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.model.forms.AbstractFormsTest;
import org.junit.Test;

public class TableWrapLayoutSelectionActionsTest
extends AbstractFormsTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    private static void hasAction(List<Object> actions, String title, boolean checked) {
        IAction action = TableWrapLayoutSelectionActionsTest.findAction(actions, title);
        TableWrapLayoutSelectionActionsTest.assertNotNull((Object)action);
        TableWrapLayoutSelectionActionsTest.assertEquals((Object)checked, (Object)action.isChecked());
    }

    @Test
    public void test_selectionActions_emptySelection() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      setLayout(layout);", "    }", "  }", "}");
        shell.refresh();
        ArrayList actions = new ArrayList();
        List selectedObjects = Collections.emptyList();
        shell.getBroadcastObject().addSelectionActions(selectedObjects, actions);
        Assertions.assertThat(actions).isEmpty();
    }

    @Test
    public void test_selectionActions_invalidSelection() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      setLayout(layout);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        ArrayList actions = new ArrayList();
        List<CompositeInfo> selectedObjects = List.of(button, shell);
        shell.getBroadcastObject().addSelectionActions(selectedObjects, actions);
        Assertions.assertThat(actions).isEmpty();
    }

    @Test
    public void test_selectionActions_state() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Label label = new Label(this, SWT.NONE);", "      label.setText(\"Label:\");", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData(TableWrapData.LEFT, TableWrapData.TOP);", "        tableWrapData.grabHorizontal = true;", "        button.setLayoutData(tableWrapData);", "      }", "    }", "  }", "}");
        shell.refresh();
        ControlInfo label = (ControlInfo)shell.getChildrenControls().get(0);
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(1);
        ArrayList<Object> actions = new ArrayList<Object>();
        List<ControlInfo> selectedObjects = List.of(button);
        shell.getBroadcastObject().addSelectionActions(selectedObjects, actions);
        TableWrapLayoutSelectionActionsTest.hasAction(actions, "Left", true);
        TableWrapLayoutSelectionActionsTest.hasAction(actions, "Center", false);
        TableWrapLayoutSelectionActionsTest.hasAction(actions, "Right", false);
        TableWrapLayoutSelectionActionsTest.hasAction(actions, "Fill horizontal", false);
        TableWrapLayoutSelectionActionsTest.hasAction(actions, "Top", true);
        TableWrapLayoutSelectionActionsTest.hasAction(actions, "Middle", false);
        TableWrapLayoutSelectionActionsTest.hasAction(actions, "Bottom", false);
        TableWrapLayoutSelectionActionsTest.hasAction(actions, "Fill vertical", false);
        TableWrapLayoutSelectionActionsTest.hasAction(actions, "Horizontal grab", true);
        TableWrapLayoutSelectionActionsTest.hasAction(actions, "Vertical grab", false);
        actions = new ArrayList();
        selectedObjects = List.of(label, button);
        shell.getBroadcastObject().addSelectionActions(selectedObjects, actions);
        TableWrapLayoutSelectionActionsTest.hasAction(actions, "Left", true);
        TableWrapLayoutSelectionActionsTest.hasAction(actions, "Top", true);
        TableWrapLayoutSelectionActionsTest.hasAction(actions, "Horizontal grab", false);
    }

    @Test
    public void test_grabAction() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      setLayout(layout);", "    }", "    {", "      Label label = new Label(this, SWT.NONE);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData();", "        tableWrapData.grabHorizontal = true;", "        button.setLayoutData(tableWrapData);", "      }", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(1);
        ArrayList actions = new ArrayList();
        List<ControlInfo> selectedObjects = List.of(button);
        shell.getBroadcastObject().addSelectionActions(selectedObjects, actions);
        IAction verticalGrab = TableWrapLayoutSelectionActionsTest.findAction(actions, "Vertical grab");
        TableWrapLayoutSelectionActionsTest.assertFalse((boolean)verticalGrab.isChecked());
        verticalGrab.setChecked(true);
        verticalGrab.run();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      setLayout(layout);", "    }", "    {", "      Label label = new Label(this, SWT.NONE);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData();", "        tableWrapData.grabVertical = true;", "        tableWrapData.grabHorizontal = true;", "        button.setLayoutData(tableWrapData);", "      }", "    }", "  }", "}");
        IAction horizontalGrab = TableWrapLayoutSelectionActionsTest.findAction(actions, "Horizontal grab");
        TableWrapLayoutSelectionActionsTest.assertTrue((boolean)horizontalGrab.isChecked());
        horizontalGrab.setChecked(false);
        horizontalGrab.run();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      setLayout(layout);", "    }", "    {", "      Label label = new Label(this, SWT.NONE);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData();", "        tableWrapData.grabVertical = true;", "        button.setLayoutData(tableWrapData);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_alignmentAction() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Label label = new Label(this, SWT.NONE);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      {", "        TableWrapData tableWrapData = new TableWrapData(TableWrapData.LEFT, TableWrapData.TOP);", "        button.setLayoutData(tableWrapData);", "      }", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(1);
        ArrayList actions = new ArrayList();
        List<ControlInfo> selectedObjects = List.of(button);
        shell.getBroadcastObject().addSelectionActions(selectedObjects, actions);
        IAction rightAlignment = TableWrapLayoutSelectionActionsTest.findAction(actions, "Right");
        rightAlignment.setChecked(true);
        rightAlignment.run();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Label label = new Label(this, SWT.NONE);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new TableWrapData(TableWrapData.RIGHT, TableWrapData.TOP));", "    }", "  }", "}");
        IAction bottomAction = TableWrapLayoutSelectionActionsTest.findAction(actions, "Bottom");
        bottomAction.setChecked(true);
        bottomAction.run();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    {", "      TableWrapLayout layout = new TableWrapLayout();", "      layout.numColumns = 2;", "      setLayout(layout);", "    }", "    {", "      Label label = new Label(this, SWT.NONE);", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new TableWrapData(TableWrapData.RIGHT, TableWrapData.BOTTOM));", "    }", "  }", "}");
    }
}

