/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.util;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;

public class WorkspaceUtils {
    private WorkspaceUtils() {
    }

    public static void delay(long waitTimeMillis) {
        Display display = Display.getCurrent();
        if (display != null) {
            long endTimeMillis = System.currentTimeMillis() + waitTimeMillis;
            while (System.currentTimeMillis() < endTimeMillis) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            display.update();
        } else {
            try {
                Thread.sleep(waitTimeMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static void waitForJobs() {
        while (Job.getJobManager().currentJob() != null) {
            WorkspaceUtils.delay(10L);
        }
    }

    public static IType waitForType(IJavaProject project, String fullClassName) {
        while (true) {
            try {
                IType type = project.findType(fullClassName);
                if (type != null) {
                    return type;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            WorkspaceUtils.delay(10L);
        }
    }

    public static void waitForClass(AstEditor editor, String fullClassName) {
        Job.getJobManager().wakeUp(ResourcesPlugin.FAMILY_AUTO_BUILD);
        IJavaProject project = editor.getJavaProject();
        ClassLoader editorLoader = EditorState.get(editor).getEditorLoader();
        while (true) {
            IType type = null;
            try {
                type = project.findType(fullClassName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (type != null) {
                try {
                    editorLoader.loadClass(fullClassName);
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (Throwable e) {
                    throw ReflectionUtils.propagate((Throwable)e);
                }
            }
            WorkspaceUtils.delay(10L);
        }
    }
}

