/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.parts;

import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.internal.InternalGEFPlugin;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.views.palette.PalettePage;
import org.eclipse.gef.ui.views.palette.PaletteViewerPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class GraphicalEditorWithFlyoutPalette
extends GraphicalEditor {
    private PaletteViewerProvider provider;
    private FlyoutPaletteComposite splitter;
    private CustomPalettePage page;

    @Override
    protected void initializeGraphicalViewer() {
        this.splitter.hookDropTargetListener(this.getGraphicalViewer());
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        return new PaletteViewerProvider(this.getEditDomain());
    }

    protected CustomPalettePage createPalettePage() {
        return new CustomPalettePage(this.getPaletteViewerProvider());
    }

    @Override
    public void createPartControl(Composite parent) {
        this.splitter = this.createPaletteComposite(parent);
        super.createPartControl(this.splitter);
        this.splitter.setGraphicalControl(this.getGraphicalControl());
        if (this.page != null) {
            this.splitter.setExternalViewer(this.page.getPaletteViewer());
            this.page = null;
        }
    }

    protected FlyoutPaletteComposite createPaletteComposite(Composite parent) {
        return new FlyoutPaletteComposite(parent, 0, this.getSite().getPage(), this.getPaletteViewerProvider(), this.getPalettePreferences());
    }

    @Override
    public <T> T getAdapter(Class<T> type) {
        if (type == PalettePage.class) {
            if (this.splitter == null) {
                this.page = this.createPalettePage();
                return type.cast(this.page);
            }
            return type.cast(this.createPalettePage());
        }
        return super.getAdapter(type);
    }

    protected Control getGraphicalControl() {
        return this.getGraphicalViewer().getControl();
    }

    protected FlyoutPaletteComposite.FlyoutPreferences getPalettePreferences() {
        return FlyoutPaletteComposite.createFlyoutPreferences(InternalGEFPlugin.getDefault().getPluginPreferences());
    }

    protected abstract PaletteRoot getPaletteRoot();

    protected final PaletteViewerProvider getPaletteViewerProvider() {
        if (this.provider == null) {
            this.provider = this.createPaletteViewerProvider();
        }
        return this.provider;
    }

    @Override
    protected void setEditDomain(DefaultEditDomain ed) {
        super.setEditDomain(ed);
        this.getEditDomain().setPaletteRoot(this.getPaletteRoot());
    }

    protected class CustomPalettePage
    extends PaletteViewerPage {
        public CustomPalettePage(PaletteViewerProvider provider) {
            super(provider);
        }

        @Override
        public void createControl(Composite parent) {
            super.createControl(parent);
            if (GraphicalEditorWithFlyoutPalette.this.splitter != null) {
                GraphicalEditorWithFlyoutPalette.this.splitter.setExternalViewer(this.viewer);
            }
        }

        @Override
        public void dispose() {
            if (GraphicalEditorWithFlyoutPalette.this.splitter != null) {
                GraphicalEditorWithFlyoutPalette.this.splitter.setExternalViewer(null);
            }
            super.dispose();
        }

        public PaletteViewer getPaletteViewer() {
            return this.viewer;
        }
    }
}

