/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.io;

import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.io.FileSystemItem;
import org.burningwave.core.io.PathHelperImpl;

public interface PathHelper {
    public static PathHelper create(Map<?, ?> config) {
        return new PathHelperImpl(config);
    }

    public String getBurningwaveRuntimeClassPath();

    public Collection<String> getMainClassPaths();

    public Collection<String> getAllMainClassPaths();

    public Collection<String> getAllPaths();

    public Collection<String> getPaths(String ... var1);

    public Collection<String> loadAndMapPaths(String var1, String var2);

    public Collection<FileSystemItem> findResources(Predicate<String> var1);

    public Collection<String> getAbsolutePathsOfResources(Predicate<String> var1);

    public String getAbsolutePathOfResource(String var1);

    public Collection<String> getAbsolutePathsOfResource(String ... var1);

    public Collection<FileSystemItem> getResources(String ... var1);

    public FileSystemItem getResource(String var1);

    public <T> Collection<T> getResources(BiConsumer<Collection<T>, FileSystemItem> var1, String ... var2);

    public <T> T getResource(BiConsumer<Collection<T>, FileSystemItem> var1, String var2);

    public Collection<InputStream> getResourcesAsStreams(String ... var1);

    public InputStream getResourceAsStream(String var1);

    public StringBuffer getResourceAsStringBuffer(String var1);

    public Collection<String> optimize(String ... var1);

    public Collection<String> optimize(Collection<String> var1);

    public Collection<FileSystemItem> optimizeFileSystemItems(FileSystemItem ... var1);

    public Collection<FileSystemItem> optimizeFileSystemItems(Collection<FileSystemItem> var1);

    public Collection<String> getPaths(Predicate<String> var1);

    public String getPath(Predicate<String> var1);

    public static abstract class Configuration {
        public static final Map<String, Object> DEFAULT_VALUES;

        static {
            HashMap<String, String> defaultValues = new HashMap<String, String>();
            defaultValues.put(Key.MAIN_CLASS_PATHS, "${system.properties:java.class.path}");
            defaultValues.put(Key.MAIN_CLASS_PATHS_EXTENSION, "//${system.properties:java.home}/lib//children:.*?\\.jar" + StaticComponentContainer.IterableObjectHelper.getDefaultValuesSeparator() + "//${system.properties:java.home}/lib/ext//children:.*?\\.jar" + StaticComponentContainer.IterableObjectHelper.getDefaultValuesSeparator() + "//${system.properties:java.home}/../lib//children:.*?\\.jar" + StaticComponentContainer.IterableObjectHelper.getDefaultValuesSeparator());
            defaultValues.put(Key.MAIN_CLASS_REPOSITORIES, "//${system.properties:java.home}/jmods//children:.*?\\.jmod" + StaticComponentContainer.IterableObjectHelper.getDefaultValuesSeparator());
            DEFAULT_VALUES = Collections.unmodifiableMap(defaultValues);
        }

        public static abstract class Key {
            public static String PATHS_PREFIX = "paths.";
            public static String MAIN_CLASS_PATHS = PATHS_PREFIX + "main-class-paths";
            public static String MAIN_CLASS_PATHS_PLACE_HOLDER = "${" + MAIN_CLASS_PATHS + "}";
            public static String MAIN_CLASS_PATHS_EXTENSION = MAIN_CLASS_PATHS + ".extension";
            public static String MAIN_CLASS_REPOSITORIES = PATHS_PREFIX + "main-class-repositories";
        }
    }
}

