/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.dev.builder;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.MessageDigest;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.wb.internal.dev.Activator;
import org.eclipse.wb.internal.dev.builder.BuilderHandler;

public final class MetaDataModificationHandler
implements BuilderHandler {
    @Override
    public void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        final AtomicBoolean done = new AtomicBoolean();
        delta.accept(new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) throws CoreException {
                if (!done.get()) {
                    IResource resource = delta.getResource();
                    boolean processed = MetaDataModificationHandler.processResource(resource);
                    done.set(processed);
                }
                return true;
            }
        });
    }

    @Override
    public void fullBuild(IProject project, IProgressMonitor monitor) throws CoreException {
        final AtomicBoolean done = new AtomicBoolean();
        project.accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (!done.get()) {
                    boolean processed = MetaDataModificationHandler.processResource(resource);
                    done.set(processed);
                }
                return true;
            }
        });
    }

    private static boolean processResource(IResource resource) {
        if (MetaDataModificationHandler.isInterestingResource(resource)) {
            IFile presentationsFile = resource.getProject().getFile((IPath)new Path("wbp-meta/.wbp-cache-presentations"));
            if (presentationsFile.exists()) {
                try {
                    String oldCheckSum = MetaDataModificationHandler.getCheckSum(presentationsFile);
                    String newCheckSum = MetaDataModificationHandler.getMetaDataCheckSum(resource.getProject());
                    if (!newCheckSum.equals(oldCheckSum)) {
                        MetaDataModificationHandler.setFileContents(presentationsFile, newCheckSum);
                    }
                }
                catch (Throwable e) {
                    Activator.log(e);
                }
            }
            return true;
        }
        return false;
    }

    private static boolean isInterestingResource(IResource resource) {
        if (resource instanceof IFile) {
            String path = resource.getFullPath().toPortableString().toLowerCase();
            return path.contains("/wbp-meta/") && (path.endsWith(".wbp-component.xml") || path.endsWith(".png") || path.endsWith(".gif"));
        }
        return false;
    }

    private static String getMetaDataCheckSum(IProject project) throws Exception {
        MessageDigest algorithm = MessageDigest.getInstance("MD5");
        SortedSet<IFile> files = MetaDataModificationHandler.getMetaDataFiles(project);
        for (IFile file : files) {
            byte[] bytes = MetaDataModificationHandler.getByteArray(file);
            algorithm.update(bytes);
        }
        return MetaDataModificationHandler.getHexDigest(algorithm);
    }

    private static byte[] getByteArray(IFile file) throws Exception {
        InputStream inputStream = file.getContents(true);
        try {
            if (MetaDataModificationHandler.isTextFile(file)) {
                byte[] byArray = MetaDataModificationHandler.getTextFileBytes(inputStream);
                return byArray;
            }
            byte[] byArray = IOUtils.toByteArray((InputStream)inputStream);
            return byArray;
        }
        catch (Throwable e) {
            byte[] byArray = new byte[]{};
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    private static byte[] getTextFileBytes(InputStream inputStream) throws IOException {
        String content = IOUtils.toString((InputStream)inputStream);
        String normalizedContent = content.replaceAll("\r\n", "\n");
        return normalizedContent.getBytes();
    }

    private static boolean isTextFile(IFile file) throws Exception {
        IContentDescription contentDescription = file.getContentDescription();
        if (contentDescription != null) {
            IContentType contentType = contentDescription.getContentType();
            while (contentType != null) {
                if ("org.eclipse.core.runtime.text".equals(contentType.getId())) {
                    return true;
                }
                contentType = contentType.getBaseType();
            }
        }
        return false;
    }

    private static SortedSet<IFile> getMetaDataFiles(IProject project) throws CoreException {
        IFolder metaDataFolder = project.getFolder("wbp-meta");
        metaDataFolder.refreshLocal(2, null);
        final TreeSet<IFile> files = new TreeSet<IFile>(new Comparator<IFile>(){

            @Override
            public int compare(IFile o1, IFile o2) {
                String location1 = this.getLocation(o1);
                String location2 = this.getLocation(o2);
                return location1.compareTo(location2);
            }

            private String getLocation(IFile file) {
                return file.getFullPath().toPortableString().toLowerCase();
            }
        });
        metaDataFolder.accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (MetaDataModificationHandler.isInterestingResource(resource)) {
                    IFile file = (IFile)resource;
                    files.add(file);
                }
                return true;
            }
        });
        return files;
    }

    private static String getHexDigest(MessageDigest algorithm) {
        StringBuffer hexString = new StringBuffer();
        byte[] byArray = algorithm.digest();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            String s = Integer.toHexString(0xFF & b);
            if (s.length() == 1) {
                hexString.append("0");
            }
            hexString.append(s);
            ++n2;
        }
        return hexString.toString();
    }

    private static String getCheckSum(IFile presentationsFile) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(presentationsFile.getContents(true)));
        try {
            String string = br.readLine();
            return string;
        }
        finally {
            IOUtils.closeQuietly((Reader)br);
        }
    }

    public static void setFileContents(IFile file, InputStream inputStream) throws CoreException {
        try {
            if (file.exists()) {
                file.setContents(inputStream, false, true, null);
            } else {
                file.create(inputStream, false, null);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public static void setFileContents(IFile file, String contents) throws CoreException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(contents.getBytes());
        MetaDataModificationHandler.setFileContents(file, inputStream);
    }
}

