/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.gef.policy.layout.grid;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Interval;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.graphics.Color;
import org.eclipse.wb.core.gef.policy.PolicyUtils;
import org.eclipse.wb.core.gef.policy.helpers.BroadcastListenerHelper;
import org.eclipse.wb.core.gef.policy.layout.LayoutPolicyUtils;
import org.eclipse.wb.core.gef.policy.layout.grid.IGridInfo;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.draw2d.AbstractRelativeLocator;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.Layer;
import org.eclipse.wb.draw2d.RectangleFigure;
import org.eclipse.wb.draw2d.RelativeLocator;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.graphical.handles.Handle;
import org.eclipse.wb.gef.graphical.handles.MoveHandle;
import org.eclipse.wb.gef.graphical.handles.SquareHandle;
import org.eclipse.wb.gef.graphical.policies.SelectionEditPolicy;
import org.eclipse.wb.gef.graphical.tools.ResizeTracker;
import org.eclipse.wb.internal.core.DesignerPlugin;

public abstract class AbstractGridSelectionEditPolicy
extends SelectionEditPolicy {
    private final IAbstractComponentInfo m_component;
    protected final ObjectInfo m_object;
    private static final int MIN_LEFT_SPACE = 10;
    private static final int INITIAL_RIGHT_SPACE = 10;
    private static final int FIGURES_SPACE = 10;
    private List<Figure> m_alignmentFigures;
    protected RectangleFigure m_lineFeedback;
    private static final String REQ_RESIZE_SIZE = "resize_size";
    protected Command m_sizeCommand;
    private static final String REQ_RESIZE_SPAN = "resize_span";
    protected Command m_spanCommand;

    public AbstractGridSelectionEditPolicy(IAbstractComponentInfo component) {
        this.m_component = component;
        this.m_object = this.m_component.getUnderlyingModel();
        new BroadcastListenerHelper(this.m_object, this, new ObjectEventListener(){

            @Override
            public void refreshed() throws Exception {
                boolean activePolicy = AbstractGridSelectionEditPolicy.this.isActive();
                boolean activeLayout = AbstractGridSelectionEditPolicy.this.isActiveLayout();
                boolean isSelected = AbstractGridSelectionEditPolicy.this.getHost().getSelected() == 2;
                boolean isDeleted = AbstractGridSelectionEditPolicy.this.m_component.isDeleted();
                if (activePolicy && activeLayout && isSelected && !isDeleted) {
                    AbstractGridSelectionEditPolicy.this.hideSelection();
                    AbstractGridSelectionEditPolicy.this.showSelection();
                }
            }
        });
    }

    protected abstract boolean isActiveLayout();

    protected abstract IGridInfo getGridInfo();

    private Rectangle getComponentCells() throws Exception {
        return this.getGridInfo().getComponentCells(this.m_component);
    }

    private Rectangle getComponentCellBounds() throws Exception {
        Rectangle cells = this.getComponentCells();
        return this.getGridInfo().getCellsRectangle(cells);
    }

    private Rectangle getComponentCellBounds_atFeedback() throws Exception {
        Rectangle bounds = this.getComponentCellBounds();
        this.translateModelToFeedback(bounds);
        return bounds;
    }

    protected final MoveHandle createMoveHandle() {
        MoveHandle moveHandle = new MoveHandle(this.getHost(), new Locator(){

            public void relocate(IFigure target) {
                try {
                    Rectangle bounds = AbstractGridSelectionEditPolicy.this.getComponentCellBounds_atFeedback();
                    target.setBounds(bounds);
                }
                catch (Throwable e) {
                    DesignerPlugin.log(e);
                }
            }
        });
        moveHandle.setForegroundColor(ColorConstants.red);
        return moveHandle;
    }

    @Override
    protected void showSelection() {
        super.showSelection();
        if (this.getHost().getSelected() == 2) {
            this.showPrimarySelection();
            this.showAlignmentFigures();
        }
    }

    @Override
    protected void hideSelection() {
        super.hideSelection();
        this.hideAlignmentFigures();
    }

    protected void showPrimarySelection() {
    }

    protected abstract Figure createAlignmentFigure(IAbstractComponentInfo var1, boolean var2);

    public final void showAlignmentFigures() {
        if (this.m_alignmentFigures == null) {
            this.m_alignmentFigures = new ArrayList<Figure>();
            List<EditPart> editParts = this.getHost().getParent().getChildren();
            for (EditPart editPart : editParts) {
                this.showCellFigures(editPart);
            }
        }
    }

    public final void hideAlignmentFigures() {
        if (this.m_alignmentFigures != null) {
            for (Figure figure : this.m_alignmentFigures) {
                figure.getParent().remove((IFigure)figure);
            }
            this.m_alignmentFigures = null;
        }
    }

    private void showCellFigures(EditPart editPart) {
        Figure verticalFigure;
        Object model = editPart.getModel();
        if (!(model instanceof IAbstractComponentInfo)) {
            return;
        }
        IAbstractComponentInfo component = (IAbstractComponentInfo)model;
        String showFiguresString = null;
        if (!LayoutPolicyUtils.shouldShowSideFigures(showFiguresString, editPart)) {
            return;
        }
        int offset = 10;
        Figure horizontalFigure = this.createAlignmentFigure(component, true);
        if (horizontalFigure != null) {
            this.addAlignmentFigure(component, horizontalFigure, offset += horizontalFigure.getSize().width);
            offset += 10;
        }
        if ((verticalFigure = this.createAlignmentFigure(component, false)) != null) {
            this.addAlignmentFigure(component, verticalFigure, offset += verticalFigure.getSize().width);
            offset += 10;
        }
    }

    private void addAlignmentFigure(IAbstractComponentInfo component, Figure figure, int offset) {
        Layer layer = this.getLayer("Clickable Layer");
        IGridInfo gridInfo = this.getGridInfo();
        Rectangle cells = gridInfo.getComponentCells(component);
        Rectangle cellRect = gridInfo.getCellsRectangle(cells).getCopy();
        this.translateModelToFeedback(cellRect);
        Dimension figureSize = figure.getSize();
        Point figureLocation = new Point(cellRect.right() - offset, cellRect.y - figureSize.height / 2);
        if (figureLocation.x < cellRect.x + 10) {
            return;
        }
        layer.add((IFigure)figure);
        figure.setLocation(figureLocation);
        this.m_alignmentFigures.add(figure);
    }

    @Override
    public boolean understandsRequest(Request request) {
        return super.understandsRequest(request) || request.getType() == REQ_RESIZE_SPAN || request.getType() == REQ_RESIZE_SIZE;
    }

    @Override
    public void showSourceFeedback(Request request) {
        try {
            if (request instanceof ChangeBoundsRequest) {
                ChangeBoundsRequest cbRequest = (ChangeBoundsRequest)request;
                if (REQ_RESIZE_SIZE.equals(request.getType())) {
                    this.showSizeFeedback(cbRequest);
                }
                if (REQ_RESIZE_SPAN.equals(request.getType())) {
                    this.showSpanFeedback(cbRequest);
                }
            }
        }
        catch (Throwable e) {
            DesignerPlugin.log(e);
        }
    }

    @Override
    public void eraseSourceFeedback(Request request) {
        if (this.m_lineFeedback != null) {
            this.removeFeedback(this.m_lineFeedback);
            this.m_lineFeedback = null;
        }
    }

    @Override
    public Command getCommand(Request request) {
        Object type = request.getType();
        if (REQ_RESIZE_SIZE.equals(type)) {
            return this.m_sizeCommand;
        }
        if (REQ_RESIZE_SPAN.equals(type)) {
            return this.m_spanCommand;
        }
        return null;
    }

    protected final Handle createSizeHandle(int direction, double percent) {
        return this.createSizeHandle(direction, this.createComponentLocator(direction, percent));
    }

    protected final Handle createSizeHandle(int direction, Locator locator) {
        return new SizeHandle(direction, locator);
    }

    private void showSizeFeedback(ChangeBoundsRequest request) throws Exception {
        Rectangle bounds = this.m_component.getModelBounds().getCopy();
        bounds.performTranslate(request.getMoveDelta());
        bounds.resize(request.getSizeDelta());
        boolean isHorizontal = request.getResizeDirection() == 8 || request.getResizeDirection() == 16;
        this.m_sizeCommand = this.createSizeCommand(isHorizontal, bounds.getSize());
        if (this.m_lineFeedback == null) {
            this.m_lineFeedback = new RectangleFigure();
            this.m_lineFeedback.setForegroundColor(ColorConstants.green);
            this.addFeedback(this.m_lineFeedback);
        }
        this.translateModelToFeedback(bounds);
        this.m_lineFeedback.setBounds(bounds);
    }

    protected Command createSizeCommand(boolean horizontal, Dimension size) {
        return null;
    }

    protected final Handle createSpanHandle(int direction, double percent) {
        return this.createSpanHandle(direction, this.createCellLocator(direction, percent));
    }

    protected final Handle createSpanHandle(int direction, Locator locator) {
        return new SpanHandle(direction, locator);
    }

    private void showSpanFeedback(ChangeBoundsRequest request) throws Exception {
        boolean isSouth;
        IGridInfo gridInfo = this.getGridInfo();
        Rectangle cells = this.getComponentCells().getCopy();
        Rectangle bounds = this.getGridInfo().getCellsRectangle(cells).getCopy();
        bounds.performTranslate(request.getMoveDelta());
        bounds.resize(request.getSizeDelta());
        int direction = request.getResizeDirection();
        boolean isWest = direction == 8;
        boolean isEast = direction == 16;
        boolean isNorth = direction == 1;
        boolean bl = isSouth = direction == 4;
        if (isWest || isEast) {
            Interval[] columnIntervals = gridInfo.getColumnIntervals();
            if (isWest) {
                int begin = 1 + Interval.getRightMostIntervalIndex((Interval[])columnIntervals, (int)bounds.x);
                begin = Math.max(begin, 0);
                begin = Math.min(begin, cells.right() - 1);
                begin = this.fixSpanLocation(true, begin, -1, cells, gridInfo);
                cells.width += cells.x - begin;
                cells.x = begin;
            } else if (isEast) {
                int end = Interval.getRightMostIntervalIndex((Interval[])columnIntervals, (int)bounds.right());
                end = Math.min(end, columnIntervals.length - 1);
                end = Math.max(end, cells.x);
                end = this.fixSpanLocation(true, end, 1, cells, gridInfo);
                cells.setRight(1 + end);
            }
            this.m_spanCommand = this.createSpanCommand(true, cells);
        } else if (isNorth || isSouth) {
            Interval[] rowIntervals = gridInfo.getRowIntervals();
            if (isNorth) {
                int begin = 1 + Interval.getRightMostIntervalIndex((Interval[])rowIntervals, (int)bounds.y);
                begin = Math.max(begin, 0);
                begin = Math.min(begin, cells.bottom() - 1);
                begin = this.fixSpanLocation(false, begin, -1, cells, gridInfo);
                cells.height += cells.y - begin;
                cells.y = begin;
            } else if (isSouth) {
                int end = Interval.getRightMostIntervalIndex((Interval[])rowIntervals, (int)bounds.bottom());
                end = Math.min(end, rowIntervals.length - 1);
                end = Math.max(end, cells.y);
                end = this.fixSpanLocation(false, end, 1, cells, gridInfo);
                cells.setBottom(1 + end);
            }
            this.m_spanCommand = this.createSpanCommand(false, cells);
        }
        if (this.m_lineFeedback == null) {
            this.m_lineFeedback = new RectangleFigure();
            this.m_lineFeedback.setForegroundColor(ColorConstants.green);
            this.addFeedback(this.m_lineFeedback);
        }
        bounds = gridInfo.getCellsRectangle(cells);
        this.translateModelToFeedback(bounds);
        this.m_lineFeedback.setBounds(bounds);
    }

    private int fixSpanLocation(boolean horizontal, int location, int locationStep, Rectangle cells, IGridInfo gridInfo) {
        if (horizontal) {
            int column = locationStep == 1 ? cells.right() : cells.x;
            while (!(locationStep == 1 ? column > location : column < location)) {
                int row = cells.y;
                while (row < cells.bottom()) {
                    IAbstractComponentInfo occupied = gridInfo.getOccupied(column, row);
                    if (occupied != null && occupied != this.m_component) {
                        return column - locationStep;
                    }
                    ++row;
                }
                column += locationStep;
            }
            return location;
        }
        int row = locationStep == 1 ? cells.bottom() : cells.y;
        while (!(locationStep == 1 ? row > location : row < location)) {
            int column = cells.x;
            while (column < cells.right()) {
                IAbstractComponentInfo occupied = gridInfo.getOccupied(column, row);
                if (occupied != null && occupied != this.m_component) {
                    return row - locationStep;
                }
                ++column;
            }
            row += locationStep;
        }
        return location;
    }

    protected abstract Command createSpanCommand(boolean var1, Rectangle var2);

    protected final Locator createComponentLocator(int direction, double percent) {
        Figure reference = this.getHostFigure();
        if (direction == 8) {
            return new RelativeLocator(reference, 0.0, percent);
        }
        if (direction == 16) {
            return new RelativeLocator(reference, 1.0, percent);
        }
        if (direction == 1) {
            return new RelativeLocator(reference, percent, percent);
        }
        if (direction == 4) {
            return new RelativeLocator(reference, percent, 1.0);
        }
        throw new IllegalArgumentException("Unknown direction: " + direction);
    }

    protected final Locator createCellLocator(int direction, double percent) {
        class SideLocator
        extends AbstractRelativeLocator {
            public SideLocator(double relativeX, double relativeY) {
                super(relativeX, relativeY);
            }

            @Override
            protected Rectangle getReferenceRectangle() {
                try {
                    Rectangle bounds = AbstractGridSelectionEditPolicy.this.getComponentCellBounds_atFeedback();
                    return bounds;
                }
                catch (Throwable e) {
                    return new Rectangle();
                }
            }
        }
        if (direction == 8) {
            return new SideLocator(0.0, percent);
        }
        if (direction == 16) {
            return new SideLocator(1.0, percent);
        }
        if (direction == 1) {
            return new SideLocator(percent, 0.0);
        }
        if (direction == 4) {
            return new SideLocator(percent, 1.0);
        }
        throw new IllegalArgumentException("Unknown direction: " + direction);
    }

    protected void translateModelToFeedback(Rectangle bounds) {
        PolicyUtils.translateModelToFeedback(this, (Translatable)bounds);
    }

    private class SizeHandle
    extends SquareHandle {
        public SizeHandle(int direction, Locator locator) {
            super(AbstractGridSelectionEditPolicy.this.getHost(), locator);
            this.setCursor(Cursors.getDirectionalCursor((int)direction));
            this.setDragTrackerTool(new ResizeTracker(direction, AbstractGridSelectionEditPolicy.REQ_RESIZE_SIZE));
        }

        @Override
        protected Color getFillColor() {
            return this.isPrimary() ? ColorConstants.black : ColorConstants.white;
        }

        @Override
        protected Color getBorderColor() {
            return ColorConstants.white;
        }
    }

    private class SpanHandle
    extends SquareHandle {
        public SpanHandle(int direction, Locator locator) {
            super(AbstractGridSelectionEditPolicy.this.getHost(), locator);
            this.setCursor(Cursors.getDirectionalCursor((int)direction));
            this.setDragTrackerTool(new ResizeTracker(direction, AbstractGridSelectionEditPolicy.REQ_RESIZE_SPAN));
        }

        @Override
        protected Color getFillColor() {
            return this.isPrimary() ? ColorConstants.green : ColorConstants.white;
        }

        @Override
        protected Color getBorderColor() {
            return ColorConstants.black;
        }
    }
}

