/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.burningwave.core.assembler.StaticComponentContainer;

public final class ByteBufferInputStream
extends InputStream {
    private ByteBuffer buffer;
    private ByteBuffer bufferCopy;

    public ByteBufferInputStream(ByteBuffer buffer) {
        this.buffer = StaticComponentContainer.BufferHandler.shareContent(buffer);
        this.bufferCopy = StaticComponentContainer.BufferHandler.shareContent(buffer);
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public ByteBuffer toByteBuffer() {
        return StaticComponentContainer.BufferHandler.duplicate(this.bufferCopy);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.buffer = StaticComponentContainer.BufferHandler.duplicate(this.toByteBuffer());
    }

    @Override
    public int read() {
        if (!this.buffer.hasRemaining()) {
            return -1;
        }
        return this.buffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] bytes, int off, int len) {
        if (!this.buffer.hasRemaining()) {
            return -1;
        }
        len = Math.min(len, this.buffer.remaining());
        this.buffer.get(bytes, off, len);
        return len;
    }

    @Override
    public void close() throws IOException {
        this.buffer = null;
        this.bufferCopy = null;
    }
}

