/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.layout;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.wb.core.eval.AstEvaluationEngine;
import org.eclipse.wb.core.eval.EvaluationContext;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.JavaEventListener;
import org.eclipse.wb.core.model.broadcast.JavaInfoAddProperties;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.core.model.broadcast.ObjectInfoTreeComplete;
import org.eclipse.wb.internal.core.model.JavaInfoEvaluationHelper;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.generation.GenerationSettings;
import org.eclipse.wb.internal.core.model.generation.statement.block.BlockStatementGeneratorDescription;
import org.eclipse.wb.internal.core.model.presentation.IObjectPresentation;
import org.eclipse.wb.internal.core.model.property.ComplexProperty;
import org.eclipse.wb.internal.core.model.property.GenericPropertyImpl;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.util.ScriptUtils;
import org.eclipse.wb.internal.core.model.variable.EmptyVariableSupport;
import org.eclipse.wb.internal.core.model.variable.LocalUniqueVariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.swt.model.layout.ILayoutDataInfo;
import org.eclipse.wb.internal.swt.model.layout.LayoutDataNameSupport;
import org.eclipse.wb.internal.swt.model.layout.LayoutDataPresentation;
import org.eclipse.wb.internal.swt.model.layout.LayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.VirtualLayoutDataVariableSupport;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;

public abstract class LayoutDataInfo
extends JavaInfo
implements ILayoutDataInfo {
    final LayoutDataInfo m_this = this;
    private ComplexProperty m_complexProperty;

    public LayoutDataInfo(AstEditor editor, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        super(editor, description, creationSupport);
        this.removeIfCompositeHasNoLayout();
        this.contributeLayoutDataProperties_toControl();
        this.addMaterializeSupport();
        this.turnIntoBlock_whenEnsureVariable();
        new LayoutDataNameSupport(this);
    }

    private void removeIfCompositeHasNoLayout() {
        this.addBroadcastListener(new ObjectInfoTreeComplete(){

            public void invoke() throws Exception {
                LayoutDataInfo.this.removeBroadcastListener(this);
                if (LayoutDataInfo.this.getParent() == null) {
                    return;
                }
                if (!LayoutDataInfo.this.getParent().getChildren().contains(LayoutDataInfo.this.m_this)) {
                    return;
                }
                if (!this.hasCompositeLayout()) {
                    LayoutDataInfo.this.getParent().removeChild((ObjectInfo)LayoutDataInfo.this.m_this);
                }
            }

            private boolean hasCompositeLayout() {
                ObjectInfo composite = LayoutDataInfo.this.getParent().getParent();
                if (composite != null && this.wantsLayoutData_forChildChild(composite.getParent())) {
                    return true;
                }
                if (composite instanceof CompositeInfo) {
                    List layouts = composite.getChildren(LayoutInfo.class);
                    if (layouts.isEmpty()) {
                        return false;
                    }
                    return LayoutDataInfo.this.isCompatibleWithLayout((LayoutInfo)layouts.get(0));
                }
                return false;
            }

            private boolean wantsLayoutData_forChildChild(ObjectInfo object) {
                if (object != null) {
                    List children = object.getChildren(JavaInfo.class);
                    for (JavaInfo child : children) {
                        if (!JavaInfoUtils.hasTrueParameter((JavaInfo)child, (String)"layout.managesChildChild")) continue;
                        return true;
                    }
                }
                return false;
            }
        });
    }

    protected boolean isCompatibleWithLayout(LayoutInfo layout) {
        String compatibleLayout = JavaInfoUtils.getParameter((JavaInfo)this, (String)"layoutData.compatibleLayout");
        if (compatibleLayout != null) {
            return ReflectionUtils.isSuccessorOf((Class)layout.getDescription().getComponentClass(), (String)compatibleLayout);
        }
        return true;
    }

    private void contributeLayoutDataProperties_toControl() {
        this.addBroadcastListener(new JavaInfoAddProperties(){

            public void invoke(JavaInfo javaInfo, List<Property> properties) throws Exception {
                if (this.isActiveForControl(javaInfo)) {
                    LayoutDataInfo.this.addLayoutDataProperties(properties);
                }
            }

            private boolean isActiveForControl(JavaInfo control) {
                return control.getChildren().contains(LayoutDataInfo.this.m_this);
            }
        });
    }

    private void addMaterializeSupport() {
        this.addBroadcastListener(new JavaEventListener(){

            public void setPropertyExpression(GenericPropertyImpl property, String[] source, Object[] value, boolean[] shouldSet) throws Exception {
                if (property.getJavaInfo() == LayoutDataInfo.this.m_this) {
                    LayoutDataInfo.this.materialize();
                }
            }
        });
    }

    protected final void materialize() throws Exception {
        if (this.isVirtual()) {
            ((VirtualLayoutDataVariableSupport)this.getVariableSupport()).materialize();
        }
    }

    private boolean isVirtual() {
        return this.getVariableSupport() instanceof VirtualLayoutDataVariableSupport;
    }

    private void turnIntoBlock_whenEnsureVariable() {
        this.addBroadcastListener(new JavaEventListener(){

            public void variable_emptyMaterializeBefore(EmptyVariableSupport variableSupport) throws Exception {
                if (variableSupport.getJavaInfo() == LayoutDataInfo.this.m_this && this.isBlockMode()) {
                    Expression creationNode = variableSupport.getInitializer();
                    Statement creationStatement = AstNodeUtils.getEnclosingStatement((ASTNode)creationNode);
                    LayoutDataInfo.this.getEditor().encloseInBlock(creationStatement);
                }
            }

            private boolean isBlockMode() {
                GenerationSettings settings = LayoutDataInfo.this.getDescription().getToolkit().getGenerationSettings();
                return settings.getStatement() == BlockStatementGeneratorDescription.INSTANCE;
            }
        });
        this.addBroadcastListener(new ObjectEventListener(){

            public void endEdit_aboutToRefresh() throws Exception {
                LocalUniqueVariableSupport variableSupport;
                if (LayoutDataInfo.this.getVariableSupport() instanceof LocalUniqueVariableSupport && (variableSupport = (LocalUniqueVariableSupport)LayoutDataInfo.this.getVariableSupport()).canInline()) {
                    variableSupport.inline();
                    this.inlineBlockIfSingleStatement();
                }
            }

            private void inlineBlockIfSingleStatement() throws Exception {
                Block block;
                Expression node = ((EmptyVariableSupport)LayoutDataInfo.this.getVariableSupport()).getInitializer();
                Statement statement = AstNodeUtils.getEnclosingStatement((ASTNode)node);
                if (statement != null && (block = (Block)statement.getParent()).statements().size() == 1) {
                    LayoutDataInfo.this.getEditor().inlineBlock(block);
                }
            }
        });
        this.addBroadcastListener(new ObjectEventListener(){

            public void endEdit_aboutToRefresh() throws Exception {
                if (!LayoutDataInfo.this.isDeleted() && LayoutDataInfo.this.getCreationSupport() instanceof ConstructorCreationSupport && LayoutDataInfo.this.getMethodInvocations().isEmpty() && LayoutDataInfo.this.getFieldAssignments().isEmpty()) {
                    ConstructorCreationSupport creationSupport = (ConstructorCreationSupport)LayoutDataInfo.this.getCreationSupport();
                    ClassInstanceCreation creation = creationSupport.getCreation();
                    String signature = creationSupport.getDescription().getSignature();
                    List arguments = DomGenerics.arguments((ClassInstanceCreation)creation);
                    if (!AstNodeUtils.areLiterals((List)arguments)) {
                        return;
                    }
                    EditorState state = JavaInfoUtils.getState((JavaInfo)LayoutDataInfo.this.m_this);
                    EvaluationContext context = new EvaluationContext(state.getEditorLoader(), state.getFlowDescription());
                    ArrayList<Object> argumentValues = new ArrayList<Object>();
                    for (Expression argument : arguments) {
                        Object value = AstEvaluationEngine.evaluate((EvaluationContext)context, (Expression)argument);
                        JavaInfoEvaluationHelper.setValue((Expression)argument, (Object)value);
                        argumentValues.add(value);
                    }
                    if (this.isDefault(signature, argumentValues)) {
                        LayoutDataInfo.this.delete();
                    }
                }
            }

            private boolean isDefault(String signature, List<Object> args) throws Exception {
                String script = JavaInfoUtils.getParameter((JavaInfo)LayoutDataInfo.this.m_this, (String)"isDefault");
                if (script != null) {
                    Map<String, List<Object>> variables = Map.of("signature", signature, "args", args);
                    return (Boolean)ScriptUtils.evaluate((ClassLoader)JavaInfoUtils.getClassLoader((JavaInfo)LayoutDataInfo.this.m_this), (String)script, variables);
                }
                return false;
            }
        });
    }

    private void addLayoutDataProperties(List<Property> properties) throws Exception {
        if (this.m_complexProperty == null) {
            Class componentClass = this.getDescription().getComponentClass();
            String text = "(" + componentClass.getName() + ")";
            this.m_complexProperty = new ComplexProperty("LayoutData", text){

                public boolean isModified() throws Exception {
                    return true;
                }

                public void setValue(Object value) throws Exception {
                    if (value == UNKNOWN_VALUE) {
                        LayoutDataInfo.this.delete();
                    }
                }
            };
            this.m_complexProperty.setCategory(PropertyCategory.system((int)5));
            this.m_complexProperty.setProperties(this.getFilteredProperties());
        }
        properties.add((Property)this.m_complexProperty);
    }

    private Property[] getFilteredProperties() throws Exception {
        Property[] properties = this.getProperties();
        String propertiesExcludeString = JavaInfoUtils.getParameter((JavaInfo)this, (String)"layoutData.exclude-properties");
        if (propertiesExcludeString != null) {
            ArrayList<Property> filteredProperties = new ArrayList<Property>();
            String[] propertiesExclude = StringUtils.split((String)propertiesExcludeString);
            Property[] propertyArray = properties;
            int n = properties.length;
            int n2 = 0;
            while (n2 < n) {
                block4: {
                    Property property = propertyArray[n2];
                    String[] stringArray = propertiesExclude;
                    int n3 = propertiesExclude.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String propertyExclude = stringArray[n4];
                        if (!property.getTitle().equals(propertyExclude)) {
                            ++n4;
                            continue;
                        }
                        break block4;
                    }
                    filteredProperties.add(property);
                }
                ++n2;
            }
            properties = filteredProperties.toArray(new Property[filteredProperties.size()]);
        }
        return properties;
    }

    public final IObjectPresentation getPresentation() {
        return new LayoutDataPresentation(this);
    }
}

