/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.jface.resource;

import java.util.Collections;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.presentation.DefaultObjectPresentation;
import org.eclipse.wb.internal.core.model.presentation.IObjectPresentation;
import org.eclipse.wb.internal.swt.Activator;
import org.eclipse.wb.internal.swt.model.ModelMessages;
import org.eclipse.wb.internal.swt.model.jface.resource.AbstractContainerInfo;
import org.eclipse.wb.internal.swt.model.jface.resource.LocalResourceManagerInfo;
import org.eclipse.wb.internal.swt.model.jface.resource.ResourceManagerInfo;

public final class ManagerContainerInfo
extends AbstractContainerInfo {
    public static ManagerContainerInfo get(JavaInfo root) throws Exception {
        return ManagerContainerInfo.get(root, new ManagerContainerInfo());
    }

    public static <T extends ResourceManagerInfo> List<T> getManagers(JavaInfo root, Class<T> componentClass) throws Exception {
        ManagerContainerInfo container = ManagerContainerInfo.findContainer(root, ManagerContainerInfo.class);
        if (container != null) {
            return container.getChildren(componentClass);
        }
        return Collections.emptyList();
    }

    public static ResourceManagerInfo getResourceManagerInfo(JavaInfo root) throws Exception {
        List<ResourceManagerInfo> resourceManagers = ManagerContainerInfo.getManagers(root, ResourceManagerInfo.class);
        if (resourceManagers.isEmpty()) {
            return LocalResourceManagerInfo.createNew(root);
        }
        return resourceManagers.get(0);
    }

    public IObjectPresentation getPresentation() {
        return new DefaultObjectPresentation(this){

            public String getText() throws Exception {
                return ModelMessages.ManagerContainerInfo_jfaceManagers;
            }

            public ImageDescriptor getIcon() throws Exception {
                return Activator.getImageDescriptor("components/manager_container.png");
            }
        };
    }
}

