/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.databinding.parser;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wb.internal.core.databinding.model.AstObjectInfo;
import org.eclipse.wb.internal.core.databinding.model.IASTObjectInfo2;
import org.eclipse.wb.internal.core.databinding.parser.IModelSupport;
import org.eclipse.wb.internal.core.databinding.utils.CoreUtils;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;

public class AstModelSupport
implements IModelSupport {
    private static final String REFERENCE_VALUE_KEY = "Reference value for this Expression";
    private final AstObjectInfo m_model;
    private Expression m_expression;
    private String m_nameReference;

    protected AstModelSupport(AstObjectInfo model) {
        this.m_model = model;
    }

    public AstModelSupport(AstObjectInfo model, Expression creation) {
        this.m_model = model;
        this.m_expression = creation;
        this.calculateNameReference(this.m_expression);
    }

    /*
     * WARNING - void declaration
     */
    protected final void calculateNameReference(Expression expression) {
        if (this.m_nameReference == null) {
            ASTNode parent = expression.getParent();
            ASTNode aSTNode = parent;
            if (aSTNode instanceof VariableDeclarationFragment) {
                void fragment;
                VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)aSTNode;
                VariableDeclarationFragment cfr_ignored_0 = (VariableDeclarationFragment)aSTNode;
                this.m_nameReference = fragment.getName().getIdentifier();
            } else {
                ASTNode aSTNode2 = parent;
                if (aSTNode2 instanceof Assignment) {
                    TypeDeclaration typeDeclaration;
                    VariableDeclarationFragment fragment;
                    void assignment;
                    Assignment assignment2 = (Assignment)aSTNode2;
                    Assignment cfr_ignored_1 = (Assignment)aSTNode2;
                    this.m_nameReference = CoreUtils.getNodeReference((ASTNode)assignment.getLeftHandSide());
                    if (this.m_nameReference != null && this.m_model instanceof IASTObjectInfo2 && (fragment = AstNodeUtils.getFieldFragmentByName((TypeDeclaration)(typeDeclaration = AstNodeUtils.getEnclosingTypeTop((ASTNode)expression)), (String)this.m_nameReference)) != null) {
                        IASTObjectInfo2 model = (IASTObjectInfo2)((Object)this.m_model);
                        model.setField();
                    }
                }
            }
            if (this.m_nameReference != null) {
                this.m_model.setVariableIdentifier(this.m_nameReference);
            }
        }
    }

    @Override
    public final AstObjectInfo getModel() {
        return this.m_model;
    }

    @Override
    public boolean isRepresentedBy(Expression expression) throws Exception {
        if (this.m_expression == expression) {
            return true;
        }
        return this.isRepresentedOverReference(expression);
    }

    protected final boolean isRepresentedOverReference(Expression expression) throws Exception {
        if (this.m_nameReference != null) {
            String nameReference = (String)expression.getProperty(REFERENCE_VALUE_KEY);
            if (nameReference != null) {
                return this.m_nameReference.equals(nameReference);
            }
            if (AstNodeUtils.isVariable((ASTNode)expression)) {
                nameReference = CoreUtils.getNodeReference((ASTNode)expression);
                expression.setProperty(REFERENCE_VALUE_KEY, (Object)nameReference);
                return this.m_nameReference.equals(nameReference);
            }
        }
        return false;
    }
}

