/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.java6.model;

import java.awt.Component;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.LayoutStyle;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.wb.core.model.AbstractComponentInfo;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.association.Association;
import org.eclipse.wb.core.model.association.EmptyAssociation;
import org.eclipse.wb.internal.core.model.JavaInfoEvaluationHelper;
import org.eclipse.wb.internal.core.parser.JavaInfoResolver;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.java6.Messages;
import org.eclipse.wb.internal.swing.java6.model.GapSpringInfo;
import org.eclipse.wb.internal.swing.java6.model.GroupInfo;
import org.eclipse.wb.internal.swing.java6.model.ParallelGroupInfo;
import org.eclipse.wb.internal.swing.java6.model.SequentialGroupInfo;
import org.eclipse.wb.internal.swing.java6.model.SpringInfo;
import org.eclipse.wb.internal.swing.java6.model.WidgetSpringInfo;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;

final class GroupLayoutParserVisitor
extends ASTVisitor {
    private final String m_methodName;
    private final ContainerInfo m_container;
    private final Map<IAbstractComponentInfo, WidgetSpringInfo> m_mappedWidgets;
    private SpringInfo m_rootGroup;

    public GroupLayoutParserVisitor(Map<IAbstractComponentInfo, WidgetSpringInfo> mappedWidgets, String methodName, ContainerInfo container) {
        this.m_mappedWidgets = mappedWidgets;
        this.m_methodName = methodName;
        this.m_container = container;
    }

    /*
     * WARNING - void declaration
     */
    public void endVisit(MethodInvocation node) {
        try {
            ASTNode arg0;
            ASTNode aSTNode;
            String identifier = node.getName().getIdentifier();
            Expression nodeExpression = node.getExpression();
            int argumentsSize = node.arguments().size();
            if (identifier.equals("addGroup") || identifier.equals("addComponent") || identifier.equals("addGap")) {
                GapSpringInfo gapSpring;
                JavaInfo widget;
                GroupInfo group;
                Expression arg1;
                GroupInfo group2;
                if (argumentsSize == 0) {
                    throw new IllegalArgumentException(Messages.GroupLayoutParserVisitor_addWithoutArguments);
                }
                Expression arg02 = (Expression)node.arguments().get(0);
                GroupInfo parentGroup = (GroupInfo)nodeExpression.getProperty("group");
                if (AstNodeUtils.isSuccessorOf((Expression)arg02, (String)"javax.swing.GroupLayout.Group")) {
                    group2 = (GroupInfo)arg02.getProperty("group");
                    parentGroup.add(group2);
                    node.setProperty("group", (Object)parentGroup);
                }
                if (argumentsSize == 2 && AstNodeUtils.isSuccessorOf((Expression)(arg1 = (Expression)node.arguments().get(1)), (String)"javax.swing.GroupLayout.Group") && identifier.equals("addGroup")) {
                    group = (ParallelGroupInfo)arg1.getProperty("group");
                    this.setGroupAlignment((ParallelGroupInfo)group, arg02);
                    parentGroup.add(group);
                    node.setProperty("group", (Object)parentGroup);
                }
                if ((argumentsSize == 1 || argumentsSize == 4) && AstNodeUtils.isSuccessorOf((Expression)arg02, Component.class)) {
                    widget = JavaInfoResolver.getJavaInfo((JavaInfo)this.m_container, (Expression)arg02);
                    group = (GroupInfo)nodeExpression.getProperty("group");
                    if (widget != null) {
                        WidgetSpringInfo widgetSpring = this.addChild((IAbstractComponentInfo)widget, this.m_container);
                        if (argumentsSize == 4) {
                            this.setSizes(widgetSpring, (Expression)node.arguments().get(1), (Expression)node.arguments().get(2), (Expression)node.arguments().get(3));
                        }
                        group.add(widgetSpring);
                    }
                    node.setProperty("group", (Object)group);
                }
                if (AstNodeUtils.isSuccessorOf((Expression)arg02, Integer.TYPE) && argumentsSize == 1) {
                    group2 = (GroupInfo)nodeExpression.getProperty("group");
                    gapSpring = new GapSpringInfo();
                    this.setSize(gapSpring, (Expression)node.arguments().get(0));
                    group2.add(gapSpring);
                    node.setProperty("group", (Object)group2);
                }
                if (AstNodeUtils.isSuccessorOf((Expression)arg02, Integer.TYPE) && argumentsSize == 3) {
                    group2 = (GroupInfo)nodeExpression.getProperty("group");
                    gapSpring = new GapSpringInfo();
                    this.setSizes(gapSpring, (Expression)node.arguments().get(0), (Expression)node.arguments().get(1), (Expression)node.arguments().get(2));
                    group2.add(gapSpring);
                    node.setProperty("group", (Object)group2);
                }
                if (argumentsSize > 1 && argumentsSize != 4) {
                    widget = null;
                    group = (GroupInfo)nodeExpression.getProperty("group");
                    Expression arg12 = (Expression)node.arguments().get(1);
                    if (AstNodeUtils.isSuccessorOf((Expression)arg02, Component.class) && identifier.equals("addComponent")) {
                        widget = JavaInfoResolver.getJavaInfo((JavaInfo)this.m_container, (Expression)arg02);
                    }
                    if (widget != null) {
                        WidgetSpringInfo widgetSpring = this.addChild((IAbstractComponentInfo)widget, this.m_container);
                        GroupLayout.Alignment alignment = (GroupLayout.Alignment)((Object)JavaInfoEvaluationHelper.getValue((Expression)arg12));
                        widgetSpring.setAlignment(alignment);
                        if (argumentsSize == 5) {
                            this.setSizes(widgetSpring, (Expression)node.arguments().get(2), (Expression)node.arguments().get(3), (Expression)node.arguments().get(4));
                        }
                        group.add(widgetSpring);
                    }
                    node.setProperty("group", (Object)group);
                }
            } else if (identifier.equals("addPreferredGap")) {
                GroupInfo group = (GroupInfo)nodeExpression.getProperty("group");
                Assert.instanceOf(SequentialGroupInfo.class, (Object)group);
                GapSpringInfo gapSpring = new GapSpringInfo();
                switch (argumentsSize) {
                    case 1: {
                        this.setPlacementType(gapSpring, (Expression)node.arguments().get(0));
                        break;
                    }
                    case 3: {
                        Expression arg03 = (Expression)node.arguments().get(0);
                        Expression arg1 = (Expression)node.arguments().get(1);
                        Expression arg2 = (Expression)node.arguments().get(2);
                        if (AstNodeUtils.isSuccessorOf((Expression)arg03, JComponent.class)) {
                            this.setGapWidgets(gapSpring, arg03, arg1);
                            this.setPlacementType(gapSpring, arg2);
                            break;
                        }
                        this.setPlacementType(gapSpring, arg03);
                        this.setGapSizes(gapSpring, arg1, arg2);
                        break;
                    }
                    case 5: {
                        Expression arg04 = (Expression)node.arguments().get(0);
                        Expression arg1 = (Expression)node.arguments().get(1);
                        Expression arg2 = (Expression)node.arguments().get(2);
                        Expression arg3 = (Expression)node.arguments().get(3);
                        Expression arg4 = (Expression)node.arguments().get(4);
                        this.setGapWidgets(gapSpring, arg04, arg1);
                        this.setPlacementType(gapSpring, arg2);
                        this.setGapSizes(gapSpring, arg3, arg4);
                    }
                }
                group.add(gapSpring);
                node.setProperty("group", (Object)group);
            } else if (identifier.equals("addContainerGap")) {
                GroupInfo group = (GroupInfo)nodeExpression.getProperty("group");
                Assert.instanceOf(SequentialGroupInfo.class, (Object)group);
                GapSpringInfo gapSpring = new GapSpringInfo(true);
                if (argumentsSize == 2) {
                    this.setGapSizes(gapSpring, (Expression)node.arguments().get(0), (Expression)node.arguments().get(1));
                }
                group.add(gapSpring);
                node.setProperty("group", (Object)group);
            } else if (identifier.equals("createSequentialGroup") && argumentsSize == 0) {
                SequentialGroupInfo sequentialGroup = new SequentialGroupInfo();
                node.setProperty("group", (Object)sequentialGroup);
            } else if (identifier.equals("createParallelGroup")) {
                ParallelGroupInfo parallelGroup = new ParallelGroupInfo();
                if (argumentsSize > 0) {
                    this.setGroupAlignment(parallelGroup, (Expression)node.arguments().get(0));
                    if (argumentsSize > 1) {
                        this.setGroupResizeable(parallelGroup, (Expression)node.arguments().get(1));
                    }
                }
                node.setProperty("group", (Object)parallelGroup);
            } else if (identifier.equals("createBaselineGroup") && argumentsSize == 2) {
                ParallelGroupInfo parallelGroup = new ParallelGroupInfo();
                parallelGroup.setGroupAlignment(GroupLayout.Alignment.BASELINE);
                this.setGroupResizeable(parallelGroup, (Expression)node.arguments().get(0));
                this.setGroupAnchorBaselineToTop(parallelGroup, (Expression)node.arguments().get(1));
                node.setProperty("group", (Object)parallelGroup);
            } else if (this.m_methodName.startsWith(identifier) && node.arguments().size() == 1 && (aSTNode = (arg0 = (ASTNode)node.arguments().get(0))) instanceof MethodInvocation) {
                void mi;
                MethodInvocation gapSpring = (MethodInvocation)aSTNode;
                MethodInvocation cfr_ignored_0 = (MethodInvocation)aSTNode;
                this.m_rootGroup = (SpringInfo)mi.getProperty("group");
            }
        }
        catch (Throwable e) {
            throw ReflectionUtils.propagate((Throwable)e);
        }
    }

    private WidgetSpringInfo addChild(IAbstractComponentInfo component, ContainerInfo container) throws Exception {
        ComponentInfo widget = (ComponentInfo)component.getUnderlyingModel();
        if (widget.getParent() == null && !container.getChildren().contains(widget)) {
            container.addChild((ObjectInfo)widget);
            widget.setAssociation((Association)new EmptyAssociation());
        }
        WidgetSpringInfo widgetSpringInfo = new WidgetSpringInfo((AbstractComponentInfo)widget);
        this.m_mappedWidgets.put((IAbstractComponentInfo)widget, widgetSpringInfo);
        return widgetSpringInfo;
    }

    private void setSize(SpringInfo spring, Expression val) throws Exception {
        Number value = (Number)JavaInfoEvaluationHelper.getValue((Expression)val);
        int intValue = value.intValue();
        spring.setSizes(intValue, intValue, intValue);
    }

    private void setSizes(SpringInfo spring, Expression min, Expression pref, Expression max) throws Exception {
        Number minValue = (Number)JavaInfoEvaluationHelper.getValue((Expression)min);
        Number prefValue = (Number)JavaInfoEvaluationHelper.getValue((Expression)pref);
        Number maxValue = (Number)JavaInfoEvaluationHelper.getValue((Expression)max);
        spring.setSizes(minValue.intValue(), prefValue.intValue(), maxValue.intValue());
    }

    private void setGapSizes(GapSpringInfo spring, Expression pref, Expression max) throws Exception {
        Number prefValue = (Number)JavaInfoEvaluationHelper.getValue((Expression)pref);
        Number maxValue = (Number)JavaInfoEvaluationHelper.getValue((Expression)max);
        spring.setPreferredSize(prefValue.intValue());
        spring.setMaximumSize(maxValue.intValue());
    }

    private void setGroupAlignment(ParallelGroupInfo group, Expression arg0) {
        GroupLayout.Alignment alignment = (GroupLayout.Alignment)((Object)JavaInfoEvaluationHelper.getValue((Expression)arg0));
        group.setGroupAlignment(alignment);
    }

    private void setGroupResizeable(ParallelGroupInfo group, Expression arg0) {
        Boolean resizeable = (Boolean)JavaInfoEvaluationHelper.getValue((Expression)arg0);
        group.setGroupResizeable(resizeable);
    }

    private void setGroupAnchorBaselineToTop(ParallelGroupInfo group, Expression arg0) {
        Boolean anchorToTop = (Boolean)JavaInfoEvaluationHelper.getValue((Expression)arg0);
        group.setGroupAnchorBaselineToTop(anchorToTop);
    }

    private void setGapWidgets(GapSpringInfo gapSpring, Expression arg0, Expression arg1) {
        JavaInfo widget1 = JavaInfoResolver.getJavaInfo((JavaInfo)this.m_container, (Expression)arg0);
        JavaInfo widget2 = JavaInfoResolver.getJavaInfo((JavaInfo)this.m_container, (Expression)arg1);
        gapSpring.setGapWidgets((IAbstractComponentInfo)widget1, (IAbstractComponentInfo)widget2);
    }

    private void setPlacementType(GapSpringInfo gapSpring, Expression arg0) {
        LayoutStyle.ComponentPlacement placement = (LayoutStyle.ComponentPlacement)((Object)JavaInfoEvaluationHelper.getValue((Expression)arg0));
        gapSpring.setPlacementType(placement);
    }

    public final SpringInfo getRootGroup() {
        return this.m_rootGroup;
    }
}

