/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.gef.policy.layout.generic;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.wb.core.gef.command.EditCommand;
import org.eclipse.wb.core.gef.figure.TextFeedback;
import org.eclipse.wb.core.model.IObjectInfo;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.RectangleFigure;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.graphical.handles.Handle;
import org.eclipse.wb.gef.graphical.handles.MoveHandle;
import org.eclipse.wb.gef.graphical.handles.SideResizeHandle;
import org.eclipse.wb.gef.graphical.policies.SelectionEditPolicy;
import org.eclipse.wb.gef.graphical.tools.ResizeTracker;

public class AbstractColumnSelectionEditPolicy
extends SelectionEditPolicy {
    private final IObjectInfo m_column;
    private Figure m_resizeFeedback;
    private TextFeedback m_textFeedback;

    public AbstractColumnSelectionEditPolicy(IObjectInfo column) {
        this.m_column = column;
    }

    @Override
    protected List<Handle> createSelectionHandles() {
        ArrayList<Handle> handles = new ArrayList<Handle>();
        MoveHandle moveHandle = new MoveHandle(this.getHost());
        moveHandle.setForegroundColor(ColorConstants.red);
        handles.add(moveHandle);
        return handles;
    }

    @Override
    protected List<Handle> createStaticHandles() {
        ArrayList<Handle> handles = new ArrayList<Handle>();
        SideResizeHandle resizeHandle = new SideResizeHandle(this.getHost(), 4, 10, true);
        resizeHandle.setDragTrackerTool(new ResizeTracker(this.getHost(), 16, "resize"));
        handles.add(resizeHandle);
        return handles;
    }

    @Override
    public boolean understandsRequest(Request request) {
        return super.understandsRequest(request) || request.getType() == "resize";
    }

    @Override
    public Command getCommand(Request request) {
        return this.getResizeCommand((ChangeBoundsRequest)request);
    }

    @Override
    public void showSourceFeedback(Request request) {
        this.showResizeFeedback((ChangeBoundsRequest)request);
    }

    @Override
    public void eraseSourceFeedback(Request request) {
        this.eraseResizeFeedback((ChangeBoundsRequest)request);
    }

    protected void setWidth(int width) throws Exception {
        this.m_column.getPropertyByTitle("width").setValue(width);
    }

    private Command getResizeCommand(ChangeBoundsRequest request) {
        final Rectangle newBounds = request.getTransformedRectangle(this.getHostFigure().getBounds());
        return new EditCommand(this.m_column){

            @Override
            protected void executeEdit() throws Exception {
                AbstractColumnSelectionEditPolicy.this.setWidth(newBounds.width);
            }
        };
    }

    private void showResizeFeedback(ChangeBoundsRequest request) {
        if (this.m_resizeFeedback == null) {
            this.m_resizeFeedback = new RectangleFigure();
            this.m_resizeFeedback.setForegroundColor(ColorConstants.red);
            this.addFeedback(this.m_resizeFeedback);
            this.m_textFeedback = new TextFeedback(this.getFeedbackLayer());
            this.m_textFeedback.add();
        }
        Figure hostFigure = this.getHostFigure();
        Rectangle bounds = request.getTransformedRectangle(hostFigure.getBounds());
        FigureUtils.translateFigureToAbsolute((IFigure)hostFigure, (Translatable)bounds.shrink(-1, -1));
        this.m_resizeFeedback.setBounds(bounds);
        this.m_textFeedback.setText(Integer.toString(bounds.width - 2));
        this.m_textFeedback.setLocation(request.getLocation().getTranslated(10, 10));
    }

    private void eraseResizeFeedback(ChangeBoundsRequest request) {
        this.removeFeedback(this.m_resizeFeedback);
        this.m_resizeFeedback = null;
        this.m_textFeedback.remove();
        this.m_textFeedback = null;
    }
}

