/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.support;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.swt.support.ContainerSupport;
import org.eclipse.wb.internal.swt.support.ControlSupport;
import org.eclipse.wb.os.OSSupport;

public final class CoordinateUtils {
    private CoordinateUtils() {
    }

    public static Point getDisplayLocation(Object composite) throws Exception {
        org.eclipse.draw2d.geometry.Rectangle bounds = ControlSupport.getBounds(composite);
        int x = bounds.x;
        int y = bounds.y;
        return CoordinateUtils.getDisplayLocation(composite, x, y);
    }

    public static Point getDisplayLocation(Object composite, int x, int y) throws Exception {
        Object parent;
        if (EnvironmentUtils.IS_LINUX && ContainerSupport.isShell(composite)) {
            Point point = ControlSupport.toDisplay(composite, 0, 0);
            y = point.y;
            Menu menuBar = ((Shell)composite).getMenuBar();
            if (menuBar != null) {
                Rectangle menuBounds = OSSupport.get().getMenuBarBounds(menuBar);
                y -= menuBounds.height;
            }
        }
        if (!ContainerSupport.isShell(composite) && (parent = ControlSupport.getParent(composite)) != null) {
            Point location = ControlSupport.toDisplay(parent, x, y);
            x = location.x;
            y = location.y;
        }
        return new Point(x, y);
    }

    public static org.eclipse.draw2d.geometry.Rectangle getBounds(Object parent, Object child) throws Exception {
        org.eclipse.draw2d.geometry.Rectangle bounds = ControlSupport.getBounds(child);
        Point childLocation = CoordinateUtils.getDisplayLocation(child);
        Point parentLocation = CoordinateUtils.getDisplayLocation(parent);
        bounds.x = childLocation.x - parentLocation.x;
        bounds.y = childLocation.y - parentLocation.y;
        return bounds;
    }

    public static Insets getClientAreaInsets(Object composite) throws Exception {
        Point displayLocation = CoordinateUtils.getDisplayLocation(composite);
        Point clientAreaLocation = ControlSupport.toDisplay(composite, 0, 0);
        boolean isRTL = ContainerSupport.isRTL(composite);
        boolean isParentRTL = ContainerSupport.isRTL(ControlSupport.getParent(composite));
        if (isRTL && !isParentRTL) {
            org.eclipse.draw2d.geometry.Rectangle clientArea = ContainerSupport.getClientArea(composite);
            clientAreaLocation.x -= clientArea.width;
        }
        int top = Math.abs(clientAreaLocation.y - displayLocation.y);
        int left = Math.abs(clientAreaLocation.x - displayLocation.x);
        if (top == 0 && left == 0) {
            return IFigure.NO_INSETS;
        }
        org.eclipse.draw2d.geometry.Rectangle bounds = ControlSupport.getBounds(composite);
        org.eclipse.draw2d.geometry.Rectangle clientArea = ContainerSupport.getClientArea(composite);
        int bottom = bounds.height - top - clientArea.height;
        int right = bounds.width - left - clientArea.width;
        return new Insets(top, left, bottom, right);
    }

    public static Insets getClientAreaInsets2(Object composite) throws Exception {
        Insets trimInsets = CoordinateUtils.getClientAreaInsets(composite);
        if (trimInsets.top != 0 || trimInsets.left != 0) {
            return IFigure.NO_INSETS;
        }
        org.eclipse.draw2d.geometry.Rectangle bounds = ControlSupport.getBounds(composite);
        org.eclipse.draw2d.geometry.Rectangle clientArea = ContainerSupport.getClientArea(composite);
        int top = clientArea.y;
        int left = clientArea.x;
        int bottom = bounds.height - top - clientArea.height;
        int right = bounds.width - left - clientArea.width;
        return new Insets(top, left, bottom, right);
    }
}

