/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.table;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.ModelMessages;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategoryProvider;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategoryProviders;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.complex.IComplexPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.presentation.PropertyEditorPresentation;
import org.eclipse.wb.internal.core.model.property.table.IPropertyExceptionHandler;
import org.eclipse.wb.internal.core.model.property.table.PropertyTableTooltipHelper;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.ui.DrawUtils;

public class PropertyTable
extends Canvas
implements ISelectionProvider {
    private static final Color COLOR_BACKGROUND = ColorConstants.listBackground;
    private static final Color COLOR_NO_PROPERTIES = ColorConstants.gray;
    private static final Color COLOR_LINE = ColorConstants.lightGray;
    private static final Color COLOR_COMPLEX_LINE = DrawUtils.getShiftedColor(ColorConstants.lightGray, -32);
    private static final Color COLOR_PROPERTY_BG = DrawUtils.getShiftedColor(COLOR_BACKGROUND, -12);
    private static final Color COLOR_PROPERTY_BG_MODIFIED = COLOR_BACKGROUND;
    private static final Color COLOR_PROPERTY_FG_TITLE = ColorConstants.listForeground;
    private static final Color COLOR_PROPERTY_FG_VALUE = DrawUtils.isDarkColor(ColorConstants.listBackground) ? ColorConstants.lightBlue : ColorConstants.darkBlue;
    private static final Color COLOR_PROPERTY_BG_SELECTED = Display.getCurrent().getSystemColor(26);
    private static final Color COLOR_PROPERTY_FG_SELECTED = Display.getCurrent().getSystemColor(27);
    private static final Color COLOR_PROPERTY_FG_ADVANCED = ColorConstants.gray;
    private static final int MIN_COLUMN_WIDTH = 75;
    private static final int MARGIN_LEFT = 2;
    private static final int MARGIN_RIGHT = 1;
    private static final int STATE_IMAGE_MARGIN_RIGHT = 4;
    private static final Image m_plusImage = DesignerPlugin.getImage("properties/plus.gif");
    private static final Image m_minusImage = DesignerPlugin.getImage("properties/minus.gif");
    private static int m_stateWidth = 9;
    private final PropertyTableTooltipHelper m_tooltipHelper;
    private boolean m_showAdvancedProperties;
    private Property[] m_rawProperties;
    private List<PropertyInfo> m_properties;
    private final Set<String> m_expandedIds = new TreeSet<String>();
    private Image m_bufferedImage;
    private int m_rowHeight;
    private int m_selection;
    private int m_page;
    private int m_splitter = -1;
    private boolean m_splitterResizing;
    private long m_lastExpandCollapseTime;
    private PropertyInfo m_activePropertyInfo;
    private String m_activePropertyId;
    private PropertyEditor m_activeEditor;
    private IPropertyExceptionHandler m_exceptionHandler;
    private final List<ISelectionChangedListener> m_selectionListeners = new ArrayList<ISelectionChangedListener>();
    private boolean m_painting;
    private Font m_baseFont;
    private Font m_boldFont;
    private Font m_italicFont;
    private PropertyCategoryProvider m_propertyCategoryProvider = PropertyCategoryProviders.fromProperty();

    public PropertyTable(Composite parent, int style) {
        super(parent, style | 0x200 | 0x40000 | 0x100000);
        this.hookControlEvents();
        GC gc = new GC((Drawable)this);
        try {
            this.m_rowHeight = 1 + gc.getFontMetrics().getHeight() + 1;
        }
        finally {
            gc.dispose();
        }
        this.m_tooltipHelper = new PropertyTableTooltipHelper(this);
    }

    private void hookControlEvents() {
        this.addListener(12, event -> this.disposeBufferedImage());
        this.addListener(11, event -> this.handleResize());
        this.addListener(9, event -> this.handlePaint(event.gc, event.x, event.y, event.width, event.height));
        this.getVerticalBar().addListener(13, event -> this.handleVerticalScrolling());
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                PropertyTable.this.forceFocus();
                PropertyTable.this.handleMouseDown(event);
            }

            public void mouseUp(MouseEvent event) {
                PropertyTable.this.handleMouseUp(event);
            }

            public void mouseDoubleClick(MouseEvent event) {
                PropertyTable.this.handleMouseDoubleClick(event);
            }
        });
        this.addMouseMoveListener(event -> this.handleMouseMove(event));
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                PropertyTable.this.handleKeyDown(e);
            }
        });
    }

    private void disposeBufferedImage() {
        if (this.m_bufferedImage != null) {
            this.m_bufferedImage.dispose();
            this.m_bufferedImage = null;
        }
    }

    private void handleResize() {
        this.disposeBufferedImage();
        this.configureScrolling();
        if (this.m_splitter <= 75) {
            this.m_splitter = Math.max((int)((double)this.getClientArea().width * 0.4), 75);
        }
        this.configureSplitter();
    }

    private void handleVerticalScrolling() {
        ScrollBar verticalBar = this.getVerticalBar();
        if (verticalBar.getEnabled()) {
            this.m_selection = verticalBar.getSelection();
            Rectangle clientArea = this.getClientArea();
            this.redraw(clientArea.x, clientArea.y, clientArea.width, clientArea.height, false);
        }
    }

    private void handleKeyDown(KeyEvent e) {
        if (this.m_activePropertyInfo != null) {
            try {
                Property property = this.m_activePropertyInfo.getProperty();
                if (this.m_activePropertyInfo.isComplex()) {
                    if (!(this.m_activePropertyInfo.isExpanded() || e.character != '+' && e.keyCode != 0x1000004)) {
                        this.m_activePropertyInfo.expand();
                        this.configureScrolling();
                        return;
                    }
                    if (this.m_activePropertyInfo.isExpanded() && (e.character == '-' || e.keyCode == 0x1000003)) {
                        this.m_activePropertyInfo.collapse();
                        this.configureScrolling();
                        return;
                    }
                }
                if (this.navigate(e)) {
                    return;
                }
                if (e.character == ' ' || e.character == '\r') {
                    this.activateEditor(property, null);
                    return;
                }
                if (e.keyCode == 127) {
                    e.doit = false;
                    property.setValue(Property.UNKNOWN_VALUE);
                    return;
                }
                property.getEditor().keyDown(this, property, e);
            }
            catch (Throwable ex) {
                DesignerPlugin.log(ex);
            }
        }
    }

    public boolean navigate(KeyEvent e) {
        int index = this.m_properties.indexOf(this.m_activePropertyInfo);
        Rectangle clientArea = this.getClientArea();
        int newIndex = index;
        if (e.keyCode == 0x1000007) {
            newIndex = 0;
        } else if (e.keyCode == 0x1000008) {
            newIndex = this.m_properties.size() - 1;
        } else if (e.keyCode == 0x1000005) {
            newIndex = Math.max(index - this.m_page + 1, 0);
        } else if (e.keyCode == 0x1000006) {
            newIndex = Math.min(index + this.m_page - 1, this.m_properties.size() - 1);
        } else if (e.keyCode == 0x1000001) {
            newIndex = Math.max(index - 1, 0);
        } else if (e.keyCode == 0x1000002) {
            newIndex = Math.min(index + 1, this.m_properties.size() - 1);
        }
        if (newIndex != index && newIndex < this.m_properties.size()) {
            this.setActivePropertyInfo(this.m_properties.get(newIndex));
            int y = this.m_rowHeight * (newIndex - this.m_selection);
            if (y < 0) {
                this.m_selection = newIndex;
                this.configureScrolling();
            } else if (y + this.m_rowHeight > clientArea.height) {
                this.m_selection = newIndex - this.m_page + 1;
                this.configureScrolling();
            }
            this.redraw();
            return true;
        }
        return false;
    }

    private void handleMouseDown(MouseEvent event) {
        boolean bl = this.m_splitterResizing = event.button == 1 && this.m_properties != null && this.isLocationSplitter(event.x);
        if (!this.m_splitterResizing && this.m_properties != null) {
            int propertyIndex = this.getPropertyIndex(event.y);
            if (propertyIndex >= this.m_properties.size()) {
                return;
            }
            this.setActivePropertyInfo(this.m_properties.get(propertyIndex));
            Property property = this.m_activePropertyInfo.getProperty();
            this.deactivateEditor(true);
            this.redraw();
            if (this.isLocationValue(event.x)) {
                this.activateEditor(property, this.getValueRelativeLocation(event.x, event.y));
            }
        }
    }

    private void handleMouseUp(MouseEvent event) {
        if (event.button == 1) {
            PropertyInfo propertyInfo;
            int index;
            if (this.m_splitterResizing) {
                this.m_splitterResizing = false;
                return;
            }
            if (!this.getClientArea().contains(event.x, event.y)) {
                return;
            }
            if (this.m_properties != null && (index = this.getPropertyIndex(event.y)) < this.m_properties.size() && this.isLocationState(propertyInfo = this.m_properties.get(index), event.x)) {
                try {
                    this.m_lastExpandCollapseTime = System.currentTimeMillis();
                    propertyInfo.flip();
                    this.configureScrolling();
                }
                catch (Throwable e) {
                    DesignerPlugin.log(e);
                }
            }
        }
    }

    private void handleMouseDoubleClick(MouseEvent event) {
        if (System.currentTimeMillis() - this.m_lastExpandCollapseTime > (long)this.getDisplay().getDoubleClickTime()) {
            try {
                if (this.m_activePropertyInfo != null) {
                    if (this.m_activePropertyInfo.isComplex()) {
                        this.m_activePropertyInfo.flip();
                        this.configureScrolling();
                    } else {
                        Property property = this.m_activePropertyInfo.getProperty();
                        property.getEditor().doubleClick(property, this.getValueRelativeLocation(event.x, event.y));
                    }
                }
            }
            catch (Throwable e) {
                this.handleException(e);
            }
        }
    }

    private void handleMouseMove(MouseEvent event) {
        int x = event.x;
        if (this.m_splitterResizing) {
            this.m_splitter = x;
            this.configureSplitter();
            this.redraw();
            return;
        }
        if (!this.getClientArea().contains(event.x, event.y)) {
            return;
        }
        if (this.m_properties != null) {
            if (this.isLocationSplitter(x)) {
                this.setCursor(Cursors.SIZEWE);
            } else {
                this.setCursor(null);
            }
            this.updateTooltip(event);
        } else {
            this.updateTooltipNoProperty();
        }
    }

    private void updateTooltip(MouseEvent event) {
        int x = event.x;
        int propertyIndex = this.getPropertyIndex(event.y);
        if (propertyIndex < this.m_properties.size()) {
            PropertyInfo propertyInfo = this.m_properties.get(propertyIndex);
            Property property = propertyInfo.getProperty();
            int y = (propertyIndex - this.m_selection) * this.m_rowHeight;
            int titleX = this.getTitleTextX(propertyInfo);
            int titleRight = this.m_splitter - 2;
            if (titleX <= x && x < titleRight) {
                this.m_tooltipHelper.update(property, true, false, titleX, titleRight, y, this.m_rowHeight);
                return;
            }
            int valueX = this.m_splitter + 3;
            if (x > valueX) {
                this.m_tooltipHelper.update(property, false, true, valueX, this.getClientArea().width, y, this.m_rowHeight);
            }
        } else {
            this.updateTooltipNoProperty();
        }
    }

    private void updateTooltipNoProperty() {
        this.m_tooltipHelper.update(null, false, false, 0, 0, 0, 0);
    }

    public void activateEditor(Property property, Point location) {
        try {
            this.deactivateEditor(true);
            PropertyEditor editor = property.getEditor();
            try {
                if (editor.activate(this, property, location)) {
                    this.m_activeEditor = editor;
                }
            }
            catch (Throwable e) {
                this.handleException(e);
            }
            this.setActiveEditorBounds();
        }
        catch (Throwable e) {
            DesignerPlugin.log(e);
        }
    }

    public void deactivateEditor(boolean save) {
        if (this.m_activeEditor != null) {
            PropertyEditor activeEditor = this.m_activeEditor;
            this.m_activeEditor = null;
            if (this.m_activePropertyInfo != null && this.m_activePropertyInfo.m_property != null) {
                activeEditor.deactivate(this, this.m_activePropertyInfo.m_property, save);
            }
        }
    }

    private void setActiveEditorBounds() {
        if (this.m_activeEditor != null) {
            int index = this.m_properties.indexOf(this.m_activePropertyInfo);
            if (index == -1) {
                this.deactivateEditor(true);
            } else {
                Rectangle clientArea = this.getClientArea();
                int x = this.m_splitter + 1;
                int width = clientArea.width - x - 1;
                int y = this.m_rowHeight * (index - this.m_selection) + 1;
                int height = this.m_rowHeight - 1;
                Rectangle bounds = new Rectangle(x, y, width, height);
                PropertyEditorPresentation presentation = this.m_activeEditor.getPresentation();
                if (presentation != null) {
                    int presentationWidth = presentation.show(this, this.m_activePropertyInfo.m_property, bounds.x, bounds.y, bounds.width, bounds.height);
                    bounds.width -= presentationWidth;
                }
                this.m_activeEditor.setBounds(bounds);
            }
        }
    }

    public void setExceptionHandler(IPropertyExceptionHandler exceptionHandler) {
        this.m_exceptionHandler = exceptionHandler;
    }

    public void handleException(Throwable e) {
        this.m_exceptionHandler.handle(e);
    }

    private void configureScrolling() {
        ScrollBar verticalBar = this.getVerticalBar();
        if (this.m_properties == null) {
            verticalBar.setEnabled(false);
        } else {
            this.m_page = this.getClientArea().height / this.m_rowHeight;
            this.m_selection = Math.max(0, Math.min(this.m_properties.size() - this.m_page, this.m_selection));
            verticalBar.setValues(this.m_selection, 0, this.m_properties.size(), this.m_page, 1, this.m_page);
            if (this.m_properties.size() <= this.m_page) {
                verticalBar.setEnabled(false);
            } else {
                verticalBar.setEnabled(true);
            }
        }
        this.redraw();
    }

    private int getTitleX(PropertyInfo propertyInfo) {
        return 2 + this.getLevelIndent() * propertyInfo.getLevel();
    }

    private int getTitleTextX(PropertyInfo propertyInfo) {
        return this.getTitleX(propertyInfo) + this.getLevelIndent();
    }

    private int getLevelIndent() {
        return m_stateWidth + 4;
    }

    private void configureSplitter() {
        Rectangle clientArea = this.getClientArea();
        if (this.m_splitter < 75) {
            this.m_splitter = 75;
        }
        if (clientArea.width - this.m_splitter < 75) {
            this.m_splitter = clientArea.width - 75;
        }
    }

    private int getPropertyIndex(int y) {
        return this.m_selection + y / this.m_rowHeight;
    }

    private boolean isLocationState(PropertyInfo propertyInfo, int x) {
        int levelX = this.getTitleX(propertyInfo);
        return propertyInfo.isComplex() && levelX <= x && x <= levelX + m_stateWidth;
    }

    private boolean isLocationSplitter(int x) {
        return Math.abs(this.m_splitter - x) < 2;
    }

    private boolean isLocationValue(int x) {
        return x > this.m_splitter + 2;
    }

    private Point getValueRelativeLocation(int x, int y) {
        return new Point(x - (this.m_splitter + 2), y - this.m_rowHeight * this.getPropertyIndex(y));
    }

    public void setShowAdvancedProperties(boolean showAdvancedProperties) {
        this.m_showAdvancedProperties = showAdvancedProperties;
        this.setInput0();
    }

    public void setInput(Property[] properties) {
        this.m_rawProperties = properties;
        this.setInput0();
    }

    private void setInput0() {
        if (this.m_properties != null) {
            for (PropertyInfo propertyInfo : this.m_properties) {
                Property property = propertyInfo.getProperty();
                PropertyEditorPresentation presentation = property.getEditor().getPresentation();
                if (presentation == null) continue;
                presentation.hide(this, property);
            }
        }
        if (this.m_rawProperties == null || this.m_rawProperties.length == 0) {
            this.deactivateEditor(false);
            this.m_properties = new ArrayList<PropertyInfo>();
        } else {
            try {
                boolean expanded;
                this.m_properties = new ArrayList<PropertyInfo>();
                Property[] propertyArray = this.m_rawProperties;
                int property = this.m_rawProperties.length;
                int n = 0;
                while (n < property) {
                    Property property2 = propertyArray[n];
                    if (this.rawProperties_shouldShow(property2)) {
                        PropertyInfo propertyInfo = new PropertyInfo(property2);
                        this.m_properties.add(propertyInfo);
                    }
                    ++n;
                }
                do {
                    expanded = false;
                    ArrayList<PropertyInfo> currentProperties = new ArrayList<PropertyInfo>(this.m_properties);
                    for (PropertyInfo propertyInfo : currentProperties) {
                        expanded |= propertyInfo.expandFromHistory();
                    }
                } while (expanded);
            }
            catch (Throwable e) {
                DesignerPlugin.log(e);
            }
        }
        if (this.m_activePropertyId != null) {
            PropertyInfo newActivePropertyInfo = null;
            if (this.m_properties != null) {
                for (PropertyInfo propertyInfo : this.m_properties) {
                    if (!propertyInfo.m_id.equals(this.m_activePropertyId)) continue;
                    newActivePropertyInfo = propertyInfo;
                    break;
                }
            }
            this.setActivePropertyInfo(newActivePropertyInfo);
        }
        this.configureScrolling();
    }

    private boolean rawProperties_shouldShow(Property property) throws Exception {
        PropertyCategory category = this.getCategory(property);
        if (category.isHidden()) {
            return false;
        }
        if (category.isAdvanced() && !this.m_showAdvancedProperties && !property.isModified()) {
            return false;
        }
        if (category.isAdvancedReally()) {
            return this.m_showAdvancedProperties;
        }
        return true;
    }

    public void setActiveProperty(Property property) {
        for (PropertyInfo propertyInfo : this.m_properties) {
            if (propertyInfo.m_property != property) continue;
            this.setActivePropertyInfo(propertyInfo);
            break;
        }
    }

    public int forTests_getPropertiesCount() {
        return this.m_properties.size();
    }

    public Property forTests_getProperty(int index) {
        return this.m_properties.get(index).getProperty();
    }

    public void forTests_expand(int index) throws Exception {
        this.m_properties.get(index).expand();
    }

    public int forTests_getSplitter() {
        return this.m_splitter;
    }

    public Point forTests_getStateLocation(Property property) {
        PropertyInfo propertyInfo = this.getPropertyInfo(property);
        if (propertyInfo != null) {
            int index = this.m_properties.indexOf(propertyInfo);
            int x = this.getTitleX(propertyInfo);
            int y = this.m_rowHeight * (index - this.m_selection) + 1;
            return new Point(x, y);
        }
        return null;
    }

    public Point forTests_getValueLocation(Property property) {
        PropertyInfo propertyInfo = this.getPropertyInfo(property);
        if (propertyInfo != null) {
            int index = this.m_properties.indexOf(propertyInfo);
            int x = this.m_splitter + 5;
            int y = this.m_rowHeight * (index - this.m_selection) + 1;
            return new Point(x, y);
        }
        return null;
    }

    public PropertyEditor forTests_getActiveEditor() {
        return this.m_activeEditor;
    }

    public PropertyCategory forTests_getCategory(Property property) {
        return this.getCategory(property);
    }

    private PropertyInfo getPropertyInfo(Property property) {
        for (PropertyInfo propertyInfo : this.m_properties) {
            if (propertyInfo.getProperty() != property) continue;
            return propertyInfo;
        }
        return null;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (!this.m_selectionListeners.contains(listener)) {
            this.m_selectionListeners.add(listener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.m_selectionListeners.add(listener);
    }

    public ISelection getSelection() {
        if (this.m_activePropertyInfo != null) {
            return new StructuredSelection((Object)this.m_activePropertyInfo.getProperty());
        }
        return StructuredSelection.EMPTY;
    }

    public void setSelection(ISelection selection) {
        throw new NotImplementedException(PropertyTable.class.getName());
    }

    private void setActivePropertyInfo(PropertyInfo activePropertyInfo) {
        int row;
        this.m_activePropertyInfo = activePropertyInfo;
        if (this.m_activePropertyInfo != null) {
            this.m_activePropertyId = this.m_activePropertyInfo.m_id;
        }
        if (this.m_activePropertyInfo != null && (this.m_selection > (row = this.m_properties.indexOf(this.m_activePropertyInfo)) || row >= this.m_selection + this.m_page)) {
            this.m_selection = row;
            this.configureScrolling();
        }
        SelectionChangedEvent selectionEvent = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        for (ISelectionChangedListener listener : this.m_selectionListeners) {
            listener.selectionChanged(selectionEvent);
        }
        this.redraw();
    }

    private void handlePaint(GC gc, int x, int y, int width, int height) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.m_painting) {
            return;
        }
        this.m_painting = true;
        try {
            this.setActiveEditorBounds();
            if (this.m_bufferedImage == null || this.m_bufferedImage.isDisposed()) {
                Point size = this.getSize();
                this.m_bufferedImage = new Image((Device)DesignerPlugin.getStandardDisplay(), size.x, size.y);
            }
            GC bufferedGC = null;
            try {
                bufferedGC = new GC((Drawable)this.m_bufferedImage);
                bufferedGC.setClipping(x, y, width, height);
                bufferedGC.setBackground(gc.getBackground());
                bufferedGC.setForeground(gc.getForeground());
                bufferedGC.setFont(gc.getFont());
                bufferedGC.setLineStyle(gc.getLineStyle());
                bufferedGC.setLineWidth(gc.getLineWidth());
                Rectangle clientArea = this.getClientArea();
                bufferedGC.setBackground(COLOR_BACKGROUND);
                bufferedGC.fillRectangle(clientArea);
                if (this.m_properties == null) {
                    this.drawEmptyContent(bufferedGC);
                } else {
                    this.drawContent(bufferedGC);
                }
            }
            finally {
                if (bufferedGC != null) {
                    bufferedGC.dispose();
                }
            }
            gc.drawImage(this.m_bufferedImage, 0, 0);
        }
        finally {
            this.m_painting = false;
        }
    }

    private void drawEmptyContent(GC gc) {
        Rectangle area = this.getClientArea();
        gc.setForeground(COLOR_NO_PROPERTIES);
        DrawUtils.drawStringCHCV(gc, ModelMessages.PropertyTable_noProperties, 0, 0, area.width, area.height);
    }

    private void drawContent(GC gc) {
        Rectangle clientArea = this.getClientArea();
        this.m_baseFont = gc.getFont();
        this.m_boldFont = DrawUtils.getBoldFont(this.m_baseFont);
        this.m_italicFont = DrawUtils.getItalicFont(this.m_baseFont);
        int[] presentationsWidth = this.showPresentations(clientArea);
        int y = clientArea.y - this.m_rowHeight * this.m_selection;
        int i = 0;
        while (i < this.m_properties.size()) {
            if (y + this.m_rowHeight < 0) {
                y += this.m_rowHeight;
            } else {
                if (y > clientArea.height) break;
                PropertyInfo propertyInfo = this.m_properties.get(i);
                this.drawProperty(gc, propertyInfo, y + 1, this.m_rowHeight - 1, clientArea.width - presentationsWidth[i]);
                gc.setForeground(COLOR_LINE);
                gc.drawLine(0, y += this.m_rowHeight, clientArea.width, y);
            }
            ++i;
        }
        this.drawExpandLines(gc, clientArea);
        gc.setForeground(COLOR_LINE);
        gc.drawRectangle(0, 0, clientArea.width - 1, clientArea.height - 1);
        gc.setForeground(COLOR_LINE);
        gc.drawLine(this.m_splitter, 0, this.m_splitter, clientArea.height);
        this.m_boldFont.dispose();
        this.m_italicFont.dispose();
    }

    private int[] showPresentations(Rectangle clientArea) {
        int[] presentationsWidth = new int[this.m_properties.size()];
        int x = this.m_splitter + 4;
        int w = clientArea.width - x - 1;
        int y = clientArea.y - this.m_rowHeight * this.m_selection;
        int i = 0;
        while (i < this.m_properties.size()) {
            PropertyInfo propertyInfo = this.m_properties.get(i);
            Property property = propertyInfo.getProperty();
            PropertyEditorPresentation presentation = property.getEditor().getPresentation();
            if (presentation != null) {
                presentationsWidth[i] = presentation.show(this, property, x, y + 1, w, this.m_rowHeight - 1);
            }
            y += this.m_rowHeight;
            ++i;
        }
        return presentationsWidth;
    }

    private void drawExpandLines(GC gc, Rectangle clientArea) {
        int height = this.m_rowHeight - 1;
        int xOffset = PropertyTable.m_plusImage.getBounds().width / 2;
        int yOffset = (height - PropertyTable.m_plusImage.getBounds().width) / 2;
        int y = clientArea.y - this.m_selection * this.m_rowHeight;
        gc.setForeground(COLOR_COMPLEX_LINE);
        int i = 0;
        while (i < this.m_properties.size()) {
            PropertyInfo propertyInfo = this.m_properties.get(i);
            if (propertyInfo.isExpanded()) {
                int index;
                int index2 = index = this.m_properties.indexOf(propertyInfo);
                while (index2 < this.m_properties.size()) {
                    PropertyInfo nextPropertyInfo = this.m_properties.get(index2);
                    if (nextPropertyInfo != propertyInfo && nextPropertyInfo.getLevel() <= propertyInfo.getLevel()) break;
                    ++index2;
                }
                if (--index2 > index) {
                    int x = this.getTitleX(propertyInfo) + xOffset;
                    int y1 = y + height - yOffset;
                    int y2 = y + this.m_rowHeight * (index2 - index) + this.m_rowHeight / 2;
                    gc.drawLine(x, y1, x, y2);
                    gc.drawLine(x, y2, x + this.m_rowHeight / 3, y2);
                }
            }
            y += this.m_rowHeight;
            ++i;
        }
    }

    private void drawProperty(GC gc, PropertyInfo propertyInfo, int y, int height, int width) {
        Color oldBackground = gc.getBackground();
        Color oldForeground = gc.getForeground();
        try {
            try {
                boolean isActiveProperty;
                Property property = propertyInfo.getProperty();
                boolean bl = isActiveProperty = this.m_activePropertyInfo != null && this.m_activePropertyInfo.getProperty() == property;
                if (isActiveProperty) {
                    gc.setBackground(COLOR_PROPERTY_BG_SELECTED);
                } else if (property.isModified()) {
                    gc.setBackground(COLOR_PROPERTY_BG_MODIFIED);
                } else {
                    gc.setBackground(COLOR_PROPERTY_BG);
                }
                gc.fillRectangle(0, y, width, height);
                if (propertyInfo.isShowComplex()) {
                    Image stateImage = propertyInfo.isExpanded() ? m_minusImage : m_plusImage;
                    DrawUtils.drawImageCV(gc, stateImage, this.getTitleX(propertyInfo), y, height);
                }
                gc.setForeground(COLOR_PROPERTY_FG_TITLE);
                if (this.getCategory(property).isAdvanced()) {
                    gc.setForeground(COLOR_PROPERTY_FG_ADVANCED);
                    gc.setFont(this.m_italicFont);
                } else if (this.getCategory(property).isPreferred() || this.getCategory(property).isSystem()) {
                    gc.setFont(this.m_boldFont);
                }
                if (isActiveProperty) {
                    gc.setForeground(COLOR_PROPERTY_FG_SELECTED);
                }
                int x = this.getTitleTextX(propertyInfo);
                DrawUtils.drawStringCV(gc, property.getTitle(), x, y, this.m_splitter - x, height);
                gc.setFont(this.m_baseFont);
                if (!isActiveProperty) {
                    gc.setForeground(COLOR_PROPERTY_FG_VALUE);
                }
                x = this.m_splitter + 4;
                int w = width - x - 1;
                SWTGraphics graphics = new SWTGraphics(gc);
                try {
                    property.getEditor().paint(property, (Graphics)graphics, x, y, w, height);
                }
                finally {
                    ReflectionUtils.invokeMethod(graphics, "checkGC()", new Object[0]);
                    graphics.dispose();
                }
            }
            catch (Throwable e) {
                DesignerPlugin.log(e);
                gc.setBackground(oldBackground);
                gc.setForeground(oldForeground);
            }
        }
        finally {
            gc.setBackground(oldBackground);
            gc.setForeground(oldForeground);
        }
    }

    public void setPropertyCategoryProvider(PropertyCategoryProvider propertyCategoryProvider) {
        this.m_propertyCategoryProvider = propertyCategoryProvider;
    }

    private PropertyCategory getCategory(Property property) {
        return this.m_propertyCategoryProvider.getCategory(property);
    }

    private final class PropertyInfo {
        private final String m_id;
        private final int m_level;
        private final Property m_property;
        private final boolean m_stateComplex;
        private boolean m_stateExpanded;
        private List<PropertyInfo> m_children;

        public PropertyInfo(Property property) {
            this(property, "", 0);
        }

        private PropertyInfo(Property property, String idPrefix, int level) {
            this.m_id = idPrefix + "|" + property.getTitle();
            this.m_level = level;
            this.m_property = property;
            this.m_stateComplex = property.getEditor() instanceof IComplexPropertyEditor;
        }

        public boolean isComplex() {
            return this.m_stateComplex;
        }

        public boolean isShowComplex() throws Exception {
            if (this.m_stateComplex) {
                this.prepareChildren();
                return !CollectionUtils.isEmpty(this.m_children);
            }
            return false;
        }

        public boolean isExpanded() {
            return this.m_stateExpanded;
        }

        public int getLevel() {
            return this.m_level;
        }

        public Property getProperty() {
            return this.m_property;
        }

        public void flip() throws Exception {
            Assert.isTrue(this.m_stateComplex);
            if (this.m_stateExpanded) {
                this.collapse();
            } else {
                this.expand();
            }
        }

        public void expand() throws Exception {
            Assert.isTrue(this.m_stateComplex);
            Assert.isTrue(!this.m_stateExpanded);
            this.m_stateExpanded = true;
            PropertyTable.this.m_expandedIds.add(this.m_id);
            this.prepareChildren();
            int index = PropertyTable.this.m_properties.indexOf(this);
            this.addChildren(index + 1);
        }

        public void collapse() throws Exception {
            Assert.isTrue(this.m_stateComplex);
            Assert.isTrue(this.m_stateExpanded);
            this.m_stateExpanded = false;
            PropertyTable.this.m_expandedIds.remove(this.m_id);
            this.prepareChildren();
            int index = PropertyTable.this.m_properties.indexOf(this);
            this.removeChildren(index + 1);
        }

        private int addChildren(int index) throws Exception {
            this.prepareChildren();
            for (PropertyInfo child : this.m_children) {
                if (!PropertyTable.this.rawProperties_shouldShow(child.m_property)) continue;
                PropertyTable.this.m_properties.add(index++, child);
                if (!child.isExpanded()) continue;
                index = child.addChildren(index);
            }
            return index;
        }

        private void removeChildren(int index) throws Exception {
            this.prepareChildren();
            for (PropertyInfo child : this.m_children) {
                if (!PropertyTable.this.rawProperties_shouldShow(child.m_property)) continue;
                PropertyEditorPresentation presentation = child.getProperty().getEditor().getPresentation();
                if (presentation != null) {
                    presentation.hide(PropertyTable.this, child.getProperty());
                }
                PropertyTable.this.m_properties.remove(index);
                if (!child.isExpanded()) continue;
                child.removeChildren(index);
            }
        }

        private void prepareChildren() throws Exception {
            if (this.m_children == null) {
                this.m_children = new ArrayList<PropertyInfo>();
                Property[] propertyArray = this.getSubProperties();
                int n = propertyArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Property subProperty = propertyArray[n2];
                    PropertyInfo subPropertyInfo = this.createSubPropertyInfo(subProperty);
                    this.m_children.add(subPropertyInfo);
                    ++n2;
                }
            }
        }

        private PropertyInfo createSubPropertyInfo(Property subProperty) {
            return new PropertyInfo(subProperty, this.m_id, this.m_level + 1);
        }

        private Property[] getSubProperties() throws Exception {
            IComplexPropertyEditor complexEditor = (IComplexPropertyEditor)((Object)this.m_property.getEditor());
            ArrayList<Property> subProperties = new ArrayList<Property>();
            Property[] propertyArray = complexEditor.getProperties(this.m_property);
            int n = propertyArray.length;
            int n2 = 0;
            while (n2 < n) {
                Property subProperty = propertyArray[n2];
                if (!PropertyTable.this.getCategory(subProperty).isHidden() || subProperty.isModified()) {
                    subProperties.add(subProperty);
                }
                ++n2;
            }
            return subProperties.toArray(new Property[subProperties.size()]);
        }

        public boolean expandFromHistory() throws Exception {
            if (this.isComplex() && !this.isExpanded() && PropertyTable.this.m_expandedIds.contains(this.m_id)) {
                this.expand();
                return true;
            }
            return false;
        }
    }
}

