/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.wb.core.eval.AstEvaluationEngine;
import org.eclipse.wb.core.eval.EvaluationContext;
import org.eclipse.wb.core.eval.ExecutionFlowUtils;
import org.eclipse.wb.core.eval.IExpressionEvaluator;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.eval.evaluators.AnonymousEvaluationError;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.IMethodParameterEvaluator;
import org.eclipse.wb.internal.core.model.creation.IThisMethodParameterEvaluator;
import org.eclipse.wb.internal.core.model.creation.ThisCreationSupport;
import org.eclipse.wb.internal.core.model.description.MethodDescription;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.exception.DesignerExceptionUtils;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;

public abstract class JavaInfoEvaluationHelper {
    public static final String KEY_EDITOR = "KEY_EXPRESSION_VALUE";
    public static final String KEY_PARAMETER_HAS_VALUE = "KEY_PARAMETER_HAS_VALUE";
    public static final String KEY_PARAMETER_VALUE = "KEY_PARAMETER_VALUE";
    private static final String KEY_EXPRESSION_VALUE = "KEY_EXPRESSION_VALUE";
    private static final Object NULL_VALUE = new Object(){

        public String toString() {
            return "NULL_VALUE";
        }
    };
    private static final String KEY_RETURN_VALUE = "KEY_RETURN_VALUE";
    private static final String KEY_EVALUATE_RETURN_VALUE = "KEY_EVALUATE_RETURN_VALUE";
    private final AstEditor m_editor;
    private final EditorState m_state;
    private final ExecutionFlowUtils.ExecutionFlowFrameVisitor m_visitor;
    private final EvaluationContext m_context;
    private final Set<MethodInvocation> m_impossibleJavaInfo = new HashSet<MethodInvocation>();
    private final Set<Expression> m_evaluatedExpressions = new HashSet<Expression>();

    public static boolean hasValue(Expression expression) {
        return expression.properties().containsKey("KEY_EXPRESSION_VALUE");
    }

    public static Object getValue(Expression expression) {
        Object value = expression.getProperty("KEY_EXPRESSION_VALUE");
        if (value == NULL_VALUE) {
            return null;
        }
        return value;
    }

    public static void setValue(Expression expression, Object value) {
        if (value == null) {
            value = NULL_VALUE;
        }
        if (expression != null) {
            expression.setProperty("KEY_EXPRESSION_VALUE", value);
        }
    }

    public static Object getReturnValue(MethodDeclaration methodDeclaration) {
        return methodDeclaration.getProperty(KEY_RETURN_VALUE);
    }

    private static void setReturnValue(MethodDeclaration methodDeclaration, Object value) {
        methodDeclaration.setProperty(KEY_RETURN_VALUE, value);
    }

    public static void shouldEvaluateReturnValue(MethodDeclaration methodDeclaration, boolean evaluate) {
        methodDeclaration.setProperty(KEY_EVALUATE_RETURN_VALUE, (Object)(evaluate ? Boolean.TRUE : null));
    }

    private static boolean shouldEvaluateReturnValue(MethodDeclaration methodDeclaration) {
        return methodDeclaration.getProperty(KEY_EVALUATE_RETURN_VALUE) == Boolean.TRUE;
    }

    public JavaInfoEvaluationHelper(AstEditor editor, ExecutionFlowUtils.ExecutionFlowFrameVisitor visitor) {
        this.m_editor = editor;
        this.m_state = EditorState.get(editor);
        this.m_visitor = visitor;
        this.m_context = this.createEvaluationContext();
        this.m_context.putArbitraryValue("KEY_EXPRESSION_VALUE", editor);
        this.m_context.addEvaluator(new IExpressionEvaluator(){

            @Override
            public Object evaluate(EvaluationContext context, Expression expression, ITypeBinding typeBinding, String typeQualifiedName) throws Exception {
                Object object;
                if (JavaInfoEvaluationHelper.this.m_impossibleJavaInfo.contains(expression)) {
                    return AstEvaluationEngine.UNKNOWN;
                }
                if (this.isChainedInvocation(expression)) {
                    return AstEvaluationEngine.UNKNOWN;
                }
                JavaInfo javaInfo = JavaInfoEvaluationHelper.this.getJavaInfoRepresentedBy(expression);
                if (javaInfo != null && (object = javaInfo.getObject()) != null) {
                    return object;
                }
                return AstEvaluationEngine.UNKNOWN;
            }

            /*
             * WARNING - void declaration
             */
            private boolean isChainedInvocation(Expression expression) {
                Expression expression2 = expression;
                if (expression2 instanceof MethodInvocation) {
                    void invocation;
                    MethodInvocation methodInvocation = (MethodInvocation)expression2;
                    MethodInvocation cfr_ignored_0 = (MethodInvocation)expression2;
                    JavaInfo javaInfo = JavaInfoEvaluationHelper.this.getJavaInfoRepresentedBy(invocation.getExpression());
                    if (javaInfo != null) {
                        String signature = AstNodeUtils.getMethodSignature((MethodInvocation)invocation);
                        MethodDescription method = javaInfo.getDescription().getMethod(signature);
                        return method != null && method.hasTrueTag("returnThis");
                    }
                }
                return false;
            }
        });
    }

    private EvaluationContext createEvaluationContext() {
        return new EvaluationContext(this.m_state.getEditorLoader(), this.m_state.getFlowDescription()){
            private MethodInvocation m_invocation;

            @Override
            public String getSource(ASTNode node) {
                if (node == null) {
                    return "<null>";
                }
                return JavaInfoEvaluationHelper.this.m_editor.getSource(node);
            }

            @Override
            public void evaluationRequested(Expression expression) throws Exception {
                super.evaluationRequested(expression);
                JavaInfoEvaluationHelper.this.m_state.getVisitedNodes().add((ASTNode)expression);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void evaluationSuccessful(Expression expression, Object value) throws Exception {
                Expression expression2;
                super.evaluationSuccessful(expression, value);
                JavaInfoEvaluationHelper.setValue(expression, value);
                JavaInfo javaInfo = JavaInfoEvaluationHelper.this.getJavaInfoRepresentedBy(expression);
                if (javaInfo != null) {
                    boolean noObjectYet;
                    boolean bl = noObjectYet = javaInfo.getObject() == null;
                    if (noObjectYet) {
                        javaInfo.setObject(value);
                    }
                }
                if ((expression2 = expression) instanceof Assignment) {
                    void assignment;
                    Expression leftHandExpression;
                    javaInfo = (Assignment)expression2;
                    Assignment cfr_ignored_0 = (Assignment)expression2;
                    Expression expression3 = leftHandExpression = assignment.getLeftHandSide();
                    if (expression3 instanceof QualifiedName) {
                        void leftQualifiedName;
                        QualifiedName qualifiedName = (QualifiedName)expression3;
                        QualifiedName cfr_ignored_1 = (QualifiedName)expression3;
                        Name leftQualifier = leftQualifiedName.getQualifier();
                        JavaInfo javaInfo2 = JavaInfoEvaluationHelper.this.getJavaInfoRepresentedBy((Expression)leftQualifier);
                        if (javaInfo2 != null) {
                            Object javaInfoObject = javaInfo2.getObject();
                            Assert.isNotNull((Object)javaInfoObject);
                            String fieldName = leftQualifiedName.getName().getIdentifier();
                            ReflectionUtils.setField((Object)javaInfoObject, (String)fieldName, (Object)value);
                        }
                    }
                }
            }

            @Override
            public Object evaluationFailed(Expression expression, Throwable e) throws Exception {
                if (DesignerExceptionUtils.isFatal((Throwable)e)) {
                    return AstEvaluationEngine.UNKNOWN;
                }
                if (!JavaInfoEvaluationHelper.isStrictEvaluationMode() && JavaInfoEvaluationHelper.this.getJavaInfoRepresentedBy(expression) == null) {
                    JavaInfoEvaluationHelper.this.m_state.getBadRefreshNodes().add((ASTNode)expression, e);
                    ITypeBinding binding = AstNodeUtils.getTypeBinding(expression);
                    return JavaInfoEvaluationHelper.getDefaultValue(binding);
                }
                return super.evaluationFailed(expression, e);
            }

            @Override
            public void addException(ASTNode node, Throwable e) {
                JavaInfoEvaluationHelper.this.m_state.getBadRefreshNodes().add(node, e);
            }

            @Override
            public Object evaluate(Expression expression) throws Exception {
                CreationSupport creationSupport;
                JavaInfo javaInfo;
                if ((expression == null || expression instanceof ThisExpression) && (javaInfo = JavaInfoEvaluationHelper.this.getThisJavaInfo()) != null) {
                    if (expression == null) {
                        JavaInfoEvaluationHelper.this.thisJavaInfoNodeProcessed(javaInfo, (ASTNode)this.m_invocation);
                    }
                    return javaInfo.getObject();
                }
                javaInfo = JavaInfoEvaluationHelper.this.getJavaInfoRepresentedBy(expression);
                if (javaInfo != null && !(creationSupport = javaInfo.getCreationSupport()).canBeEvaluated()) {
                    Object object = javaInfo.getObject();
                    if (object != null) {
                        return object;
                    }
                    return JavaInfoEvaluationHelper.this.evaluateJavaInfoUsingCreationSupport(javaInfo);
                }
                this.m_invocation = expression instanceof MethodInvocation ? (MethodInvocation)expression : null;
                return AstEvaluationEngine.UNKNOWN;
            }

            @Override
            public Object evaluateUnknownParameter(MethodDeclaration methodDeclaration, SingleVariableDeclaration parameter) throws Exception {
                Object value = JavaInfoEvaluationHelper.this.evaluateUnknownParameter0(methodDeclaration, parameter);
                if (value != AstEvaluationEngine.UNKNOWN) {
                    return value;
                }
                return super.evaluateUnknownParameter(methodDeclaration, parameter);
            }
        };
    }

    private Object evaluateUnknownParameter0(MethodDeclaration method, SingleVariableDeclaration parameter) throws Exception {
        if (parameter.getProperty(KEY_PARAMETER_HAS_VALUE) == Boolean.TRUE) {
            return parameter.getProperty(KEY_PARAMETER_VALUE);
        }
        Object value = JavaInfoEvaluationHelper.evaluateJavadocTagExpression(this.m_editor, this.m_context, method.getJavadoc(), "@wbp.eval.method.parameter", parameter.getName().getIdentifier());
        if (value != AstEvaluationEngine.UNKNOWN) {
            return value;
        }
        String signature = AstNodeUtils.getMethodSignature(method);
        int index = DomGenerics.parameters(method).indexOf(parameter);
        JavaInfo thisJavaInfo = this.getThisJavaInfo();
        JavaInfo javaInfo = thisJavaInfo;
        if (javaInfo instanceof IThisMethodParameterEvaluator) {
            IMethodParameterEvaluator evaluator;
            IThisMethodParameterEvaluator iThisMethodParameterEvaluator = (IThisMethodParameterEvaluator)((Object)javaInfo);
            IThisMethodParameterEvaluator cfr_ignored_0 = (IThisMethodParameterEvaluator)((Object)javaInfo);
            Object value2 = evaluator.evaluateParameter(this.m_context, method, signature, parameter, index);
            if (value2 != AstEvaluationEngine.UNKNOWN) {
                return value2;
            }
        }
        List evaluators = ExternalFactoriesHelper.getElementsInstances(IMethodParameterEvaluator.class, (String)"org.eclipse.wb.core.java.unknownParameterEvaluators", (String)"evaluator");
        for (IMethodParameterEvaluator evaluator : evaluators) {
            Object value3 = evaluator.evaluateParameter(this.m_context, method, signature, parameter, index);
            if (value3 == AstEvaluationEngine.UNKNOWN) continue;
            return value3;
        }
        if (!JavaInfoEvaluationHelper.isStrictEvaluationMode()) {
            ITypeBinding binding = AstNodeUtils.getTypeBinding(parameter);
            return JavaInfoEvaluationHelper.getDefaultValue(binding);
        }
        return AstEvaluationEngine.UNKNOWN;
    }

    public static Object getDefaultValue(ITypeBinding binding) {
        if (binding == null) {
            return null;
        }
        if (binding.isPrimitive()) {
            String className = AstNodeUtils.getFullyQualifiedName(binding, true);
            return ReflectionUtils.getDefaultValue((String)className);
        }
        if (AstNodeUtils.isSuccessorOf(binding, "java.lang.String")) {
            return "<dynamic>";
        }
        if (AstNodeUtils.isSuccessorOf(binding, "java.util.LinkedList")) {
            return new LinkedList();
        }
        if (AstNodeUtils.isSuccessorOf(binding, "java.util.Vector")) {
            return new Vector();
        }
        if (AstNodeUtils.isSuccessorOf(binding, "java.util.List")) {
            return new ArrayList();
        }
        if (AstNodeUtils.isSuccessorOf(binding, "java.util.Set")) {
            return new HashSet();
        }
        if (AstNodeUtils.isSuccessorOf(binding, "java.util.Map")) {
            return new HashMap();
        }
        return null;
    }

    private static boolean isStrictEvaluationMode() {
        return DesignerPlugin.getDefault().getPreferenceStore().getBoolean("evaluation.strictMode");
    }

    public final EvaluationContext getContext() {
        return this.m_context;
    }

    /*
     * WARNING - void declaration
     */
    public final void evaluate(ASTNode node) {
        try {
            ASTNode aSTNode;
            ExpressionStatement expression;
            Expression expression2;
            JavaInfo javaInfo;
            if (JavaInfoEvaluationHelper.isPossibleJavaInfoCreationExpression(node) && (javaInfo = this.getJavaInfoRepresentedBy(expression2 = (Expression)node)) != null) {
                this.evaluateExpression(expression2);
                return;
            }
            ASTNode aSTNode2 = node;
            if (aSTNode2 instanceof ReturnStatement) {
                void returnStatement;
                expression2 = (ReturnStatement)aSTNode2;
                ReturnStatement cfr_ignored_0 = (ReturnStatement)aSTNode2;
                if (this.shouldEvaluateReturnStatement((ReturnStatement)returnStatement)) {
                    expression = returnStatement.getExpression();
                    Object object = this.evaluateExpression((Expression)expression);
                    JavaInfoEvaluationHelper.setReturnValue(AstNodeUtils.getEnclosingMethod((ASTNode)returnStatement), object);
                }
            }
            if ((aSTNode = node) instanceof ExpressionStatement) {
                Expression expression3;
                Object javaInfo2;
                void expressionStatement;
                Expression expression4;
                expression = (ExpressionStatement)aSTNode;
                ExpressionStatement cfr_ignored_1 = (ExpressionStatement)aSTNode;
                Expression expression5 = expression4 = expressionStatement.getExpression();
                if (expression5 instanceof MethodInvocation) {
                    void invocation;
                    MethodInvocation methodInvocation = (MethodInvocation)expression5;
                    MethodInvocation cfr_ignored_2 = (MethodInvocation)expression5;
                    javaInfo2 = this.getJavaInfoRepresentedBy(invocation.getExpression());
                    if (javaInfo2 != null) {
                        Class<?> componentClass;
                        if (invocation.getExpression() == null && ReflectionUtils.getMethodBySignature(componentClass = ((JavaInfo)((Object)javaInfo2)).getDescription().getComponentClass(), (String)AstNodeUtils.getMethodSignature((MethodInvocation)invocation)) != null) {
                            ((JavaInfo)((Object)javaInfo2)).addRelatedNode((ASTNode)invocation);
                        }
                        if (!((JavaInfo)((Object)javaInfo2)).shouldEvaluateInvocation((MethodInvocation)invocation)) {
                            return;
                        }
                        this.m_impossibleJavaInfo.add((MethodInvocation)invocation);
                        this.evaluateMethodInvocation((JavaInfo)((Object)javaInfo2), (MethodInvocation)invocation);
                        return;
                    }
                }
                if ((expression3 = expression4) instanceof SuperMethodInvocation) {
                    void invocation;
                    javaInfo2 = (SuperMethodInvocation)expression3;
                    SuperMethodInvocation cfr_ignored_3 = (SuperMethodInvocation)expression3;
                    this.evaluateExpression((Expression)invocation);
                }
                if (expression4 instanceof Assignment) {
                    this.evaluateAssignment(expression4);
                }
            }
        }
        catch (Throwable e) {
            ReflectionUtils.propagate((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isPossibleJavaInfoCreationExpression(ASTNode node) {
        ASTNode aSTNode = node;
        if (aSTNode instanceof CastExpression) {
            void castExpression;
            CastExpression castExpression2 = (CastExpression)aSTNode;
            CastExpression cfr_ignored_0 = (CastExpression)aSTNode;
            return JavaInfoEvaluationHelper.isPossibleJavaInfoCreationExpression((ASTNode)castExpression.getExpression());
        }
        return node instanceof ClassInstanceCreation || node instanceof MethodInvocation || node instanceof SuperMethodInvocation;
    }

    private void evaluateAssignment(Expression expression) throws Exception {
        JavaInfo javaInfo;
        Expression leftQualifier;
        Assignment assignment = (Assignment)expression;
        Expression leftHandExpression = assignment.getLeftHandSide();
        Expression rightHandExpression = assignment.getRightHandSide();
        if (this.getJavaInfoRepresentedBy(rightHandExpression) != null) {
            this.evaluateExpression(rightHandExpression);
        }
        if ((leftQualifier = AstNodeUtils.getFieldAccessQualifier(leftHandExpression)) != null && (javaInfo = this.getJavaInfoRepresentedBy(leftQualifier)) != null) {
            this.evaluateExpression(leftQualifier);
            Object javaInfoObject = javaInfo.getObject();
            Assert.isNotNull((Object)javaInfoObject);
            String fieldName = AstNodeUtils.getFieldAccessName(leftHandExpression).getIdentifier();
            Field field = ReflectionUtils.getFieldByName(javaInfoObject.getClass(), (String)fieldName);
            if (field != null) {
                Object value = this.evaluateExpression(rightHandExpression);
                field.set(javaInfoObject, value);
            }
        }
    }

    public final void evaluateMethodInvocation(JavaInfo javaInfo, MethodInvocation invocation) throws Exception {
        block2: {
            try {
                this.evaluateExpression((Expression)invocation);
            }
            catch (Error e) {
                if (AnonymousEvaluationError.is(e)) break block2;
                throw e;
            }
        }
    }

    public final Object evaluateExpression(Expression expression) throws Exception {
        if (this.m_evaluatedExpressions.contains(expression)) {
            return JavaInfoEvaluationHelper.getValue(expression);
        }
        this.m_evaluatedExpressions.add(expression);
        Object result = AstEvaluationEngine.evaluate(this.m_context, expression);
        Assert.isTrue((result != AstEvaluationEngine.UNKNOWN ? 1 : 0) != 0);
        return result;
    }

    public final Object evaluateJavaInfoUsingCreationSupport(JavaInfo javaInfo) throws Exception {
        Object object = javaInfo.getCreationSupport().create(this.m_context, this.m_visitor);
        Assert.isNotNull((Object)object);
        javaInfo.setObject(object);
        return object;
    }

    protected JavaInfo getRootJavaInfo() {
        throw new NotImplementedException(this.getClass().getName());
    }

    protected void thisJavaInfoNodeProcessed(JavaInfo javaInfo, ASTNode node) throws Exception {
        throw new NotImplementedException(this.getClass().getName());
    }

    protected abstract JavaInfo getJavaInfoRepresentedBy(Expression var1);

    private JavaInfo getThisJavaInfo() {
        JavaInfo rootJavaInfo = this.getRootJavaInfo();
        if (rootJavaInfo != null && rootJavaInfo.getCreationSupport() instanceof ThisCreationSupport) {
            return rootJavaInfo;
        }
        return null;
    }

    private boolean shouldEvaluateReturnStatement(ReturnStatement returnStatement) throws Exception {
        MethodDeclaration enclosingMethod = AstNodeUtils.getEnclosingMethod((ASTNode)returnStatement);
        if (JavaInfoEvaluationHelper.shouldEvaluateReturnValue(enclosingMethod)) {
            return true;
        }
        Expression expression = returnStatement.getExpression();
        return this.getJavaInfoRepresentedBy(expression) != null;
    }

    public static Object evaluateJavadocTagExpression(AstEditor editor, EvaluationContext context, Javadoc javadoc, String tagName, String expectedName) throws Exception {
        if (javadoc != null) {
            for (TagElement tag : DomGenerics.tags(javadoc)) {
                if (!tagName.equals(tag.getTagName())) continue;
                String errorMessage = "'" + tagName + " <name> = <expression>' expected but '" + String.valueOf(tag) + "' found.";
                Assert.isLegal((tag.fragments().size() == 1 ? 1 : 0) != 0, (String)errorMessage);
                TextElement textElement = (TextElement)tag.fragments().get(0);
                String text = textElement.getText().trim();
                String[] parts = StringUtils.split((String)text);
                Assert.isLegal((parts.length >= 2 ? 1 : 0) != 0, (String)errorMessage);
                String name = parts[0];
                String expressionText = text.substring(name.length()).trim();
                if (!name.equals(expectedName)) continue;
                Object value = tag.getProperty("KEY_EXPRESSION_VALUE");
                if (value == null) {
                    Expression expression = editor.getParser().parseExpression(javadoc.getStartPosition(), expressionText);
                    value = AstEvaluationEngine.evaluate(context, expression);
                    tag.setProperty("KEY_EXPRESSION_VALUE", value);
                }
                return value;
            }
        }
        return AstEvaluationEngine.UNKNOWN;
    }
}

