/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.rcp.databinding.xwt.model.widgets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.databinding.model.IObserveInfo;
import org.eclipse.wb.internal.core.databinding.model.IObservePresentation;
import org.eclipse.wb.internal.core.databinding.model.ISynchronizeProcessor;
import org.eclipse.wb.internal.core.databinding.model.SynchronizeManager;
import org.eclipse.wb.internal.core.databinding.model.reference.IReferenceProvider;
import org.eclipse.wb.internal.core.databinding.ui.ObserveType;
import org.eclipse.wb.internal.core.databinding.utils.CoreUtils;
import org.eclipse.wb.internal.core.utils.xml.DocumentElement;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.rcp.databinding.model.BindableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.widgets.bindables.PropertiesSupport;
import org.eclipse.wb.internal.rcp.databinding.model.widgets.bindables.WidgetPropertyBindableInfo;
import org.eclipse.wb.internal.rcp.databinding.xwt.model.widgets.XmlObjectObservePresentation;
import org.eclipse.wb.internal.rcp.databinding.xwt.model.widgets.XmlObjectReferenceProvider;

public class WidgetBindableInfo
extends BindableInfo {
    private final XmlObjectInfo m_xmlObjectInfo;
    private final WidgetBindableInfo m_parent;
    private final List<WidgetBindableInfo> m_children = new ArrayList<WidgetBindableInfo>();
    private final List<WidgetPropertyBindableInfo> m_properties;
    private final XmlObjectObservePresentation m_presentation;

    public WidgetBindableInfo(XmlObjectInfo xmlObjectInfo, WidgetBindableInfo parent) throws Exception {
        super(xmlObjectInfo.getDescription().getComponentClass(), (IReferenceProvider)new XmlObjectReferenceProvider(xmlObjectInfo));
        this.m_xmlObjectInfo = xmlObjectInfo;
        this.m_parent = parent;
        this.m_presentation = new XmlObjectObservePresentation((ObjectInfo)xmlObjectInfo);
        List childrenInfos = SynchronizeManager.getChildren((ObjectInfo)xmlObjectInfo, XmlObjectInfo.class);
        for (XmlObjectInfo childInfo : childrenInfos) {
            this.m_children.add(new WidgetBindableInfo(childInfo, this));
        }
        this.m_properties = PropertiesSupport.getProperties((ClassLoader)this.getClassLoader(), (Class)this.getObjectType());
    }

    public XmlObjectInfo getXMLObjectInfo() {
        return this.m_xmlObjectInfo;
    }

    public ClassLoader getClassLoader() {
        return this.m_xmlObjectInfo.getContext().getClassLoader();
    }

    public WidgetBindableInfo resolve(XmlObjectInfo xmlObjectInfo) {
        if (this.m_xmlObjectInfo == xmlObjectInfo) {
            return this;
        }
        for (WidgetBindableInfo child : this.m_children) {
            WidgetBindableInfo result = child.resolve(xmlObjectInfo);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public WidgetBindableInfo resolve(DocumentElement element) {
        if (this.m_xmlObjectInfo.getElement() == element) {
            return this;
        }
        for (WidgetBindableInfo child : this.m_children) {
            WidgetBindableInfo result = child.resolve(element);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public WidgetPropertyBindableInfo resolvePropertyByText(String text) throws Exception {
        for (WidgetPropertyBindableInfo property : this.m_properties) {
            if (!text.equalsIgnoreCase(property.getPresentation().getText())) continue;
            return property;
        }
        return null;
    }

    public void update() throws Exception {
        List objectInfos = SynchronizeManager.getChildren((ObjectInfo)this.m_xmlObjectInfo, XmlObjectInfo.class);
        SynchronizeManager.synchronizeObjects(this.m_children, (List)objectInfos, (ISynchronizeProcessor)new ISynchronizeProcessor<XmlObjectInfo, WidgetBindableInfo>(){

            public boolean handleObject(WidgetBindableInfo object) {
                return true;
            }

            public XmlObjectInfo getKeyObject(WidgetBindableInfo widget) {
                return widget.m_xmlObjectInfo;
            }

            public boolean equals(XmlObjectInfo key0, XmlObjectInfo key1) {
                return key0 == key1;
            }

            public WidgetBindableInfo findObject(Map<XmlObjectInfo, WidgetBindableInfo> keyObjectToObject, XmlObjectInfo key) throws Exception {
                return null;
            }

            public WidgetBindableInfo createObject(XmlObjectInfo objectInfo) throws Exception {
                return new WidgetBindableInfo(objectInfo, WidgetBindableInfo.this);
            }

            public void update(WidgetBindableInfo widget) throws Exception {
                widget.update();
            }
        });
    }

    protected List<BindableInfo> getChildren() {
        return CoreUtils.cast(this.m_children);
    }

    public IObserveInfo getParent() {
        return this.m_parent;
    }

    public List<IObserveInfo> getChildren(IObserveInfo.ChildrenContext context) {
        if (context == IObserveInfo.ChildrenContext.ChildrenForMasterTable) {
            return CoreUtils.cast(this.m_children);
        }
        if (context == IObserveInfo.ChildrenContext.ChildrenForPropertiesTable) {
            return CoreUtils.cast(this.m_properties);
        }
        return Collections.emptyList();
    }

    public IObservePresentation getPresentation() {
        return this.m_presentation;
    }

    public ObserveType getType() {
        return ObserveType.WIDGETS;
    }
}

