/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.model.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.internal.core.utils.xml.DocumentAttribute;
import org.eclipse.wb.internal.core.utils.xml.DocumentElement;

public class NamespacesHelper {
    protected final DocumentElement m_rootElement;
    protected final Set<String> m_names = new HashSet<String>();
    protected final Map<String, String> m_nameForURI = new HashMap<String, String>();
    protected final Map<String, String> m_uriForName = new HashMap<String, String>();

    public NamespacesHelper(DocumentElement element) {
        this.m_rootElement = element;
    }

    public void prepareNamespaces() {
        this.m_names.clear();
        this.m_nameForURI.clear();
        for (DocumentAttribute attribute : this.m_rootElement.getDocumentAttributes()) {
            String name = attribute.getName();
            if (!name.startsWith("xmlns")) continue;
            name = StringUtils.removeStart((String)name, (String)"xmlns");
            name = StringUtils.removeStart((String)name, (String)":");
            this.m_nameForURI.put(attribute.getValue(), name);
            this.m_uriForName.put(name, attribute.getValue());
            this.m_names.add(name);
        }
    }

    public String generateUniqueName(String base) {
        String name;
        int index = 1;
        do {
            name = base + index;
            ++index;
        } while (this.m_names.contains(name));
        return name;
    }

    public void add(String name, String uri) {
        this.m_rootElement.setAttribute("xmlns:" + name, uri);
    }

    public String getURI(String name) {
        this.prepareNamespaces();
        return this.m_uriForName.get(name);
    }

    public String getName(String uri) {
        this.prepareNamespaces();
        return this.m_nameForURI.get(uri);
    }

    public String ensureName(String uri, String base) {
        this.prepareNamespaces();
        String name = this.m_nameForURI.get(uri);
        if (name != null) {
            return name;
        }
        name = this.getNewName(uri, base);
        this.add(name, uri);
        return name;
    }

    protected String getNewName(String uri, String base) {
        return this.generateUniqueName(base);
    }

    public static String getURI(DocumentElement element, String name) {
        NamespacesHelper helper = new NamespacesHelper(element.getRoot());
        return helper.getURI(name);
    }

    public static String getName(DocumentElement element, String uri) {
        NamespacesHelper helper = new NamespacesHelper(element.getRoot());
        return helper.getName(uri);
    }

    public static String ensureName(DocumentElement element, String uri, String base) {
        NamespacesHelper helper = new NamespacesHelper(element.getRoot());
        return helper.ensureName(uri, base);
    }
}

