/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.gef.policy;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.wb.core.gef.command.EditCommand;
import org.eclipse.wb.core.gef.figure.TextFeedback;
import org.eclipse.wb.core.model.AbstractComponentInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.draw2d.Layer;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.gef.graphical.policies.GraphicalEditPolicy;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.gef.tools.TabOrderContainerRequest;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.order.TabOrderInfo;

public final class TabOrderContainerEditPolicy
extends GraphicalEditPolicy {
    public static final Request TAB_ORDER_REQUEST = new Request((Object)"tab order");
    public static final String TAB_CONTAINER_ROLE = "tab container role";
    public static final String REQ_CONTAINER_TAB_ORDER = "container tab order";
    private List<TextFeedback> m_indexFeedbacks;

    public boolean understandsRequest(Request request) {
        return request.getType() == REQ_CONTAINER_TAB_ORDER;
    }

    public void showTargetFeedback(Request request) {
        TabOrderContainerRequest containerRequest = (TabOrderContainerRequest)request;
        if (containerRequest.getChildren() == null) {
            try {
                TabOrderInfo tabOrderInfo = this.getTabOrderValue();
                containerRequest.setPossibleChildren(tabOrderInfo.getInfos());
                containerRequest.setChildren(tabOrderInfo.getOrderedInfos());
            }
            catch (Throwable e) {
                DesignerPlugin.log((Throwable)e);
                return;
            }
        }
        this.showChildrenIndexes(containerRequest.getChildren(), containerRequest.getSelectedChild());
    }

    private void showChildrenIndexes(List<?> children, Object selectedChild) {
        this.eraseChildrenIndexes();
        this.m_indexFeedbacks = new ArrayList<TextFeedback>();
        Layer layer = this.getLayer("Clickable Layer");
        IEditPartViewer viewer = this.getHost().getViewer();
        int index = 0;
        while (index < children.size()) {
            Object child = children.get(index);
            GraphicalEditPart part = (GraphicalEditPart)viewer.getEditPartRegistry().get(child);
            Figure figure = part.getFigure();
            Point location = figure.getBounds().getLocation();
            FigureUtils.translateFigureToFigure((Figure)figure, (Figure)layer, (Translatable)location);
            TextFeedback feedback = new TextFeedback(layer);
            feedback.setText(Integer.toString(index));
            feedback.add();
            feedback.moveTopLeftCenter(location);
            this.m_indexFeedbacks.add(feedback);
            feedback.setData((Object)part);
            feedback.setBackground(IColorConstants.yellow);
            if (child == selectedChild) {
                feedback.setBackground(IColorConstants.lightGreen);
            }
            ++index;
        }
    }

    public void eraseTargetFeedback(Request request) {
        this.eraseChildrenIndexes();
        TabOrderContainerRequest containerRequest = (TabOrderContainerRequest)request;
        TabOrderCommand command = new TabOrderCommand(this.getContainer(), containerRequest.getChildren());
        containerRequest.setCommand((Command)command);
    }

    private void eraseChildrenIndexes() {
        if (this.m_indexFeedbacks != null) {
            for (TextFeedback feedback : this.m_indexFeedbacks) {
                feedback.remove();
            }
            this.m_indexFeedbacks = null;
        }
    }

    private TabOrderInfo getTabOrderValue() throws Exception {
        JavaInfo container = this.getContainer();
        Property property = container.getPropertyByTitle("tab order");
        return (TabOrderInfo)property.getValue();
    }

    private JavaInfo getContainer() {
        return (JavaInfo)((Object)this.getHostModel());
    }

    private static class TabOrderCommand
    extends EditCommand {
        private final JavaInfo m_container;
        private final List<AbstractComponentInfo> m_orderedInfos;

        public TabOrderCommand(JavaInfo container, List<AbstractComponentInfo> orderedInfos) {
            super((ObjectInfo)container);
            this.m_container = container;
            this.m_orderedInfos = orderedInfos;
        }

        protected void executeEdit() throws Exception {
            TabOrderInfo tabOrderInfo = new TabOrderInfo();
            tabOrderInfo.getOrderedInfos().addAll(this.m_orderedInfos);
            Property property = this.m_container.getPropertyByTitle("tab order");
            property.setValue((Object)tabOrderInfo);
        }
    }
}

