/*******************************************************************************
 * Copyright (c) 2011 Google, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Google, Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.wb.internal.core.xml.model;

/**
 * Participator of {@link XmlObjectInfo} initialization, used from
 * {@link XmlObjectInfo#initialize()}.
 *
 * @author scheglov_ke
 * @coverage XML.model
 */
public interface IXMLObjectInitializationParticipator {
	/**
	 * Participates in given {@link XmlObjectInfo} initialization.
	 */
	void process(XmlObjectInfo object) throws Exception;
}
