/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.rcp.databinding.xwt.model;

import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.wb.internal.core.databinding.model.CodeGenerationSupport;
import org.eclipse.wb.internal.core.databinding.model.IObserveInfo;
import org.eclipse.wb.internal.core.databinding.ui.editor.IPageListener;
import org.eclipse.wb.internal.core.databinding.ui.editor.IUiContentProvider;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.LabelUiContentProvider;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.SeparatorUiContentProvider;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.xml.DocumentElement;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.rcp.databinding.DatabindingsProvider;
import org.eclipse.wb.internal.rcp.databinding.model.AbstractBindingInfo;
import org.eclipse.wb.internal.rcp.databinding.model.BindableInfo;
import org.eclipse.wb.internal.rcp.databinding.model.context.DataBindingContextInfo;
import org.eclipse.wb.internal.rcp.databinding.xwt.Messages;
import org.eclipse.wb.internal.rcp.databinding.xwt.model.ConverterInfo;
import org.eclipse.wb.internal.rcp.databinding.xwt.model.IDocumentEditor;
import org.eclipse.wb.internal.rcp.databinding.xwt.model.ValidationInfo;
import org.eclipse.wb.internal.rcp.databinding.xwt.model.widgets.WidgetBindableInfo;
import org.eclipse.wb.internal.rcp.databinding.xwt.ui.contentproviders.ModeContentProvider;
import org.eclipse.wb.internal.rcp.databinding.xwt.ui.contentproviders.TriggerContentProvider;

public class BindingInfo
extends AbstractBindingInfo {
    public static final String[] MODES = new String[]{"TwoWay", "OneWay", "OneTime"};
    private static final String[] modes = new String[]{"twoway", "oneway", "onetime"};
    public static final String[] TRIGGERS = new String[]{"Default", "PropertyChanged", "LostFocus"};
    private static final String[] triggers = new String[]{"default", "propertychanged", "lostfocus"};
    private final BindableInfo m_target;
    private final BindableInfo m_targetProperty;
    private final BindableInfo m_model;
    private final BindableInfo m_modelProperty;
    private int m_mode;
    private int m_trigger;
    private final ConverterInfo m_converter = new ConverterInfo();
    private final ValidationInfo m_validator = new ValidationInfo();
    private IDocumentEditor m_documentEditor;

    public BindingInfo(BindableInfo target, BindableInfo targetProperty, BindableInfo model, BindableInfo modelProperty) {
        this.m_target = target;
        this.m_targetProperty = targetProperty;
        this.m_model = model;
        this.m_modelProperty = modelProperty;
    }

    public DocumentElement getTargetElement() {
        WidgetBindableInfo target = (WidgetBindableInfo)this.m_target;
        return target.getXMLObjectInfo().getElement();
    }

    public void modify(RunnableEx runnable) throws Exception {
        WidgetBindableInfo target = (WidgetBindableInfo)this.m_target;
        XmlObjectInfo objectInfo = target.getXMLObjectInfo();
        objectInfo.startEdit();
        runnable.run();
        objectInfo.endEdit();
    }

    public IObserveInfo getTarget() {
        return this.m_target;
    }

    public IObserveInfo getTargetProperty() {
        return this.m_targetProperty;
    }

    public String getTargetPresentationText() throws Exception {
        return this.m_target.getPresentation().getTextForBinding() + "." + this.m_targetProperty.getPresentation().getTextForBinding();
    }

    public IObserveInfo getModel() {
        return this.m_model;
    }

    public IObserveInfo getModelProperty() {
        return this.m_modelProperty;
    }

    public String getModelPresentationText() throws Exception {
        return this.m_model.getPresentation().getTextForBinding() + "." + this.m_modelProperty.getPresentation().getTextForBinding();
    }

    public int getMode() {
        return this.m_mode;
    }

    public void setMode(int mode) {
        this.m_mode = mode;
    }

    public void setMode(String mode) {
        if (mode == null) {
            this.m_mode = 0;
        } else {
            this.m_mode = ArrayUtils.indexOf((Object[])modes, (Object)mode.toLowerCase());
            if (this.m_mode == -1) {
                this.m_mode = 0;
            }
        }
    }

    public int getTriger() {
        return this.m_trigger;
    }

    public void setTrigger(int trigger) {
        this.m_trigger = trigger;
    }

    public void setTrigger(String trigger) {
        if (trigger == null) {
            this.m_trigger = 0;
        } else {
            this.m_trigger = ArrayUtils.indexOf((Object[])triggers, (Object)trigger.toLowerCase());
            if (this.m_trigger == -1) {
                this.m_trigger = 0;
            }
        }
    }

    public ConverterInfo getConverter() {
        return this.m_converter;
    }

    public ValidationInfo getValidator() {
        return this.m_validator;
    }

    public void addSourceCode(DataBindingContextInfo context, List<String> lines, CodeGenerationSupport generationSupport) throws Exception {
        throw new UnsupportedOperationException();
    }

    public IDocumentEditor getDocumentEditor() {
        return this.m_documentEditor;
    }

    public void setDocumentEditor(IDocumentEditor documentEditor) {
        this.m_documentEditor = documentEditor;
    }

    public int getDefinitionOffset() {
        return this.m_documentEditor.getDefinitionOffset();
    }

    public String getDefinitionSource(DatabindingsProvider provider) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void createContentProviders(List<IUiContentProvider> providers, IPageListener listener, org.eclipse.wb.internal.rcp.databinding.xwt.DatabindingsProvider provider) throws Exception {
        listener.setTitle(Messages.BindingInfo_listenerTitle);
        listener.setMessage(Messages.BindingInfo_listenerMessage);
        providers.add((IUiContentProvider)new LabelUiContentProvider(Messages.BindingInfo_targetTitle, this.getTargetPresentationText()));
        providers.add((IUiContentProvider)new LabelUiContentProvider(Messages.BindingInfo_modelTitle, this.getModelPresentationText()));
        providers.add((IUiContentProvider)new SeparatorUiContentProvider());
        providers.add((IUiContentProvider)new ModeContentProvider(this));
        providers.add((IUiContentProvider)new TriggerContentProvider(this));
        this.m_converter.createContentProviders(providers, listener, provider);
        this.m_validator.createContentProviders(providers, listener, provider);
    }

    public void createContentProviders(List<IUiContentProvider> providers, IPageListener listener, DatabindingsProvider provider) throws Exception {
        throw new UnsupportedOperationException();
    }
}

