/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.nls.edit;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.nls.Messages;
import org.eclipse.wb.internal.core.nls.commands.AddKeyCommand;
import org.eclipse.wb.internal.core.nls.commands.AddLocaleCommand;
import org.eclipse.wb.internal.core.nls.commands.ExternalizePropertyCommand;
import org.eclipse.wb.internal.core.nls.commands.ICommandQueue;
import org.eclipse.wb.internal.core.nls.commands.InternalizeKeyCommand;
import org.eclipse.wb.internal.core.nls.commands.RemoveLocaleCommand;
import org.eclipse.wb.internal.core.nls.commands.RenameKeyCommand;
import org.eclipse.wb.internal.core.nls.commands.SetValuesCommand;
import org.eclipse.wb.internal.core.nls.edit.IEditableSource;
import org.eclipse.wb.internal.core.nls.edit.IEditableSourceListener;
import org.eclipse.wb.internal.core.nls.edit.StringPropertyInfo;
import org.eclipse.wb.internal.core.nls.model.AbstractSource;
import org.eclipse.wb.internal.core.nls.model.IKeyGeneratorStrategy;
import org.eclipse.wb.internal.core.nls.model.KeyToComponentsSupport;
import org.eclipse.wb.internal.core.nls.model.LocaleInfo;

public final class EditableSource
implements IEditableSource {
    private String m_shortTitle;
    private String m_longTitle;
    private final Set<String> m_keys = new HashSet<String>();
    private final Set<String> m_formKeys = new HashSet<String>();
    private final HashMap<String, String> m_keyToValue = new HashMap();
    private KeyToComponentsSupport m_keyToComponentsSupport = new KeyToComponentsSupport(false);
    private final Map<LocaleInfo, EditableLocaleInfo> m_localeToInfo = new TreeMap<LocaleInfo, EditableLocaleInfo>();
    private ICommandQueue m_commandQueue;
    private IKeyGeneratorStrategy m_keyGeneratorStrategy;
    private final List<IEditableSourceListener> m_listeners = new ArrayList<IEditableSourceListener>();

    public void setShortTitle(String shortTitle) {
        this.m_shortTitle = shortTitle;
    }

    public void setLongTitle(String longTitle) {
        this.m_longTitle = longTitle;
    }

    public void add(LocaleInfo locale, Map<String, String> keyToValue) {
        this.m_localeToInfo.put(locale, new EditableLocaleInfo(locale, keyToValue));
        this.m_keys.addAll(keyToValue.keySet());
        this.m_keyToValue.putAll(keyToValue);
    }

    public void setFormKeys(Set<String> currentFormKeys) {
        this.m_formKeys.clear();
        this.m_formKeys.addAll(currentFormKeys);
    }

    public void setKeyToComponentsSupport(KeyToComponentsSupport keyToComponentsSupport) {
        this.m_keyToComponentsSupport = keyToComponentsSupport;
    }

    @Override
    public void setCommandQueue(ICommandQueue commandQueue) {
        this.m_commandQueue = commandQueue;
    }

    @Override
    public void setKeyGeneratorStrategy(IKeyGeneratorStrategy keyGeneratorStrategy) {
        this.m_keyGeneratorStrategy = keyGeneratorStrategy;
    }

    @Override
    public void addListener(IEditableSourceListener listener) {
        if (!this.m_listeners.contains(listener)) {
            this.m_listeners.add(listener);
        }
    }

    @Override
    public void removeListener(IEditableSourceListener listener) {
        this.m_listeners.remove(listener);
    }

    private void fire_keyAdded(String key, StringPropertyInfo propertyInfo) {
        for (IEditableSourceListener listener : this.m_listeners) {
            listener.keyAdded(key, propertyInfo);
        }
    }

    private void fire_keyRemoved(String key) {
        for (IEditableSourceListener listener : this.m_listeners) {
            listener.keyRemoved(key);
        }
    }

    private void fire_keyRenamed(String oldKey, String newKey) {
        for (IEditableSourceListener listener : this.m_listeners) {
            listener.keyRenamed(oldKey, newKey);
        }
    }

    @Override
    public String getShortTitle() {
        return this.m_shortTitle;
    }

    @Override
    public String getLongTitle() {
        return this.m_longTitle;
    }

    @Override
    public LocaleInfo[] getLocales() {
        return this.m_localeToInfo.keySet().toArray(new LocaleInfo[this.m_localeToInfo.keySet().size()]);
    }

    @Override
    public void addLocale(LocaleInfo locale, LocaleInfo baseLocale) {
        HashMap<String, String> keyToValue;
        if (baseLocale != null) {
            EditableLocaleInfo editableBaseLocale = this.getEditableLocale(baseLocale);
            keyToValue = new HashMap<String, String>(editableBaseLocale.m_keyToValue);
        } else {
            keyToValue = new HashMap<String, String>();
        }
        this.add(locale, keyToValue);
        this.m_commandQueue.addCommand(new AddLocaleCommand(this, locale, keyToValue));
    }

    @Override
    public void removeLocale(LocaleInfo locale) {
        this.m_localeToInfo.remove(locale);
        this.m_commandQueue.addCommand(new RemoveLocaleCommand(this, locale));
    }

    @Override
    public Set<String> getKeys() {
        return this.m_keys;
    }

    @Override
    public Set<String> getFormKeys() {
        return this.m_formKeys;
    }

    @Override
    public void renameKey(String oldKey, String newKey) {
        if (oldKey.equals(newKey)) {
            return;
        }
        boolean containsNewKey = false;
        for (EditableLocaleInfo editableLocale : this.m_localeToInfo.values()) {
            containsNewKey |= editableLocale.containsKey(newKey);
        }
        boolean keepNewKeyValue = false;
        if (containsNewKey) {
            MessageDialog dialog = new MessageDialog(DesignerPlugin.getShell(), Messages.EditableSource_renameConfirmTitle, null, MessageFormat.format(Messages.EditableSource_renameConfirmKeepExistingValue, newKey), 3, new String[]{Messages.EditableSource_renameConfirmYesKeep, Messages.EditableSource_renameConfirmNoUseRenaming}, 0);
            int openResult = dialog.open();
            if (openResult == -1) {
                return;
            }
            keepNewKeyValue = openResult == 0;
        }
        this.m_commandQueue.addCommand(new RenameKeyCommand(this, oldKey, newKey));
        for (EditableLocaleInfo editableLocale : this.m_localeToInfo.values()) {
            boolean renamed = editableLocale.renameKey(oldKey, newKey, keepNewKeyValue);
            if (!renamed) continue;
            this.addLocaleValuesCommand(editableLocale);
        }
        this.m_formKeys.remove(oldKey);
        this.m_formKeys.add(newKey);
        this.m_keys.remove(oldKey);
        this.m_keys.add(newKey);
        String valueOfRenamedKey = this.m_keyToValue.get(oldKey);
        this.m_keyToValue.remove(oldKey);
        this.m_keyToValue.put(newKey, valueOfRenamedKey);
        this.m_keyToComponentsSupport.rename(oldKey, newKey);
        this.fire_keyRenamed(oldKey, newKey);
    }

    @Override
    public void externalize(StringPropertyInfo propertyInfo, boolean copyToAllLocales) {
        JavaInfo component = propertyInfo.getComponent();
        GenericProperty property = propertyInfo.getProperty();
        String value = propertyInfo.getValue();
        Object baseKey = null;
        String key = null;
        IPreferenceStore preferences = component.getDescription().getToolkit().getPreferences();
        if (preferences.getBoolean("nls.useStringValueForKeyOnly")) {
            baseKey = AbstractSource.shrinkText(value);
            if (baseKey == null) {
                return;
            }
        } else {
            baseKey = this.m_keyGeneratorStrategy.generateBaseKey(component, property);
            if (preferences.getBoolean("nls.useStringValueForKey")) {
                baseKey = (String)baseKey + "_" + AbstractSource.shrinkText(value);
            }
        }
        key = AbstractSource.generateUniqueKey(this.m_keyToValue, (String)baseKey, value);
        this.m_keys.add(key);
        this.m_formKeys.add(key);
        this.m_keyToValue.put(key, value);
        this.m_keyToComponentsSupport.add(component, key);
        this.m_commandQueue.addCommand(new ExternalizePropertyCommand(this, component, property, key));
        for (LocaleInfo locale : this.m_localeToInfo.keySet()) {
            if (!locale.isDefault() && !copyToAllLocales) continue;
            this.setValue(locale, key, value);
        }
        this.fire_keyAdded(key, propertyInfo);
    }

    @Override
    public void internalizeKey(String key) {
        this.m_formKeys.remove(key);
        this.m_keys.remove(key);
        this.m_keyToValue.remove(key);
        this.m_keyToComponentsSupport.remove(key);
        this.m_commandQueue.addCommand(new InternalizeKeyCommand(this, key));
        for (EditableLocaleInfo editableLocale : this.m_localeToInfo.values()) {
            boolean removed = editableLocale.removeKey(key);
            if (!removed) continue;
            this.addLocaleValuesCommand(editableLocale);
        }
        this.fire_keyRemoved(key);
    }

    @Override
    public void addKey(String key, String value) {
        this.m_keys.add(key);
        this.m_keyToValue.put(key, value);
        this.m_commandQueue.addCommand(new AddKeyCommand(this, key));
        LocaleInfo[] localeInfoArray = this.getLocales();
        int n = localeInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            LocaleInfo locale = localeInfoArray[n2];
            this.setValue(locale, key, value);
            ++n2;
        }
        this.fire_keyAdded(key, null);
    }

    @Override
    public Set<JavaInfo> getComponentsByKey(String key) {
        return this.m_keyToComponentsSupport.getComponentsByKey(key);
    }

    @Override
    public String getValue(LocaleInfo locale, String key) {
        EditableLocaleInfo editableLocale = this.getEditableLocale(locale);
        if (editableLocale != null) {
            return editableLocale.getValue(key);
        }
        return null;
    }

    @Override
    public void setValue(LocaleInfo locale, String key, String value) {
        EditableLocaleInfo editableLocale = this.getEditableLocale(locale);
        boolean changed = editableLocale.setValue(key, value);
        if (changed) {
            this.addLocaleValuesCommand(editableLocale);
        }
    }

    private EditableLocaleInfo getEditableLocale(LocaleInfo locale) {
        return this.m_localeToInfo.get(locale);
    }

    private void addLocaleValuesCommand(EditableLocaleInfo editableLocale) {
        this.m_commandQueue.addCommand(new SetValuesCommand(this, editableLocale.m_locale, editableLocale.m_keyToValue));
    }

    private static class EditableLocaleInfo {
        private final LocaleInfo m_locale;
        private final Map<String, String> m_keyToValue;

        public EditableLocaleInfo(LocaleInfo locale, Map<String, String> keyToValue) {
            this.m_locale = locale;
            this.m_keyToValue = new HashMap<String, String>(keyToValue);
        }

        public boolean containsKey(String key) {
            return this.m_keyToValue.containsKey(key);
        }

        public boolean renameKey(String oldKey, String newKey, boolean keepNewKeyValue) {
            String value = this.m_keyToValue.remove(oldKey);
            if (value != null && !keepNewKeyValue) {
                this.m_keyToValue.put(newKey, value);
            }
            return value != null;
        }

        public boolean removeKey(String key) {
            return this.m_keyToValue.remove(key) != null;
        }

        public String getValue(String key) {
            return this.m_keyToValue.get(key);
        }

        public boolean setValue(String key, String value) {
            String oldValue = this.getValue(key);
            if (oldValue == null && StringUtils.isEmpty((String)value)) {
                return false;
            }
            if (oldValue != null && oldValue.equals(value)) {
                return false;
            }
            this.m_keyToValue.put(key, value);
            return true;
        }
    }
}

