/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.model.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.internal.core.utils.reflect.ClassMap;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.broadcast.XmlObjectEventListeners;
import org.eclipse.wb.internal.core.xml.model.property.event.AbstractListenerProperty;
import org.eclipse.wb.internal.core.xml.model.utils.XmlObjectUtils;
import org.eclipse.wb.internal.xwt.model.property.event.XwtListenerProperty;

public final class XwtListenerProperties {
    private static final ClassMap<List<String>> m_widgetEvents = ClassMap.create();

    public XwtListenerProperties(XmlObjectInfo rootObject) {
        rootObject.addBroadcastListener((Object)new XmlObjectEventListeners(){

            public void invoke(XmlObjectInfo object, List<AbstractListenerProperty> properties) throws Exception {
                XwtListenerProperties.this.addListeners(object, properties);
            }
        });
    }

    private void addListeners(XmlObjectInfo object, List<AbstractListenerProperty> properties) throws Exception {
        List<String> events = XwtListenerProperties.getWidgetEvents(object);
        for (String eventName : events) {
            properties.add(new XwtListenerProperty(object, eventName));
        }
    }

    private static List<String> getWidgetEvents(XmlObjectInfo widget) {
        Class componentClass = widget.getDescription().getComponentClass();
        ArrayList events = (ArrayList)m_widgetEvents.get(componentClass);
        if (events == null) {
            events = new ArrayList();
            m_widgetEvents.put(componentClass, events);
            while (componentClass != null) {
                String parameterName = "RCP.untyped.events: " + componentClass.getName();
                String namesString = XmlObjectUtils.getParameter((XmlObjectInfo)widget, (String)parameterName);
                if (namesString != null) {
                    String[] names = StringUtils.split((String)namesString);
                    Collections.addAll(events, names);
                }
                componentClass = componentClass.getSuperclass();
            }
            Collections.sort(events);
        }
        return events;
    }
}

