/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.model.property.editor;

import java.util.function.Predicate;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.TextDialogPropertyEditor;
import org.eclipse.wb.internal.core.model.util.ObjectsLabelProvider;
import org.eclipse.wb.internal.core.model.util.ObjectsTreeContentProvider;
import org.eclipse.wb.internal.core.utils.dialogfields.StatusUtils;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.property.GenericProperty;
import org.eclipse.wb.internal.xwt.model.util.NameSupport;

public final class ObjectPropertyEditor
extends TextDialogPropertyEditor {
    public static final PropertyEditor INSTANCE = new ObjectPropertyEditor();

    private ObjectPropertyEditor() {
    }

    public XmlObjectInfo getValueComponent(Property property) throws Exception {
        Object value = property.getValue();
        GenericProperty genericProperty = (GenericProperty)property;
        return genericProperty.getObject().getRootXML().getChildByObject(value);
    }

    protected String getText(Property property) throws Exception {
        XmlObjectInfo component = this.getValueComponent(property);
        if (component != null) {
            return ObjectInfo.getText((ObjectInfo)component);
        }
        return null;
    }

    protected void openDialog(Property property_) throws Exception {
        GenericProperty property = (GenericProperty)property_;
        XmlObjectInfo thisComponent = property.getObject();
        final Class propertyType = property.getType();
        ISelectionStatusValidator validator = new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length == 1 && ObjectPropertyEditor.this.isValidComponent(propertyType, selection[0])) {
                    return StatusUtils.OK_STATUS;
                }
                return StatusUtils.ERROR_STATUS;
            }
        };
        ITreeContentProvider contentProvider = this.createContentProvider(propertyType);
        ElementTreeSelectionDialog selectionDialog = new ElementTreeSelectionDialog(DesignerPlugin.getShell(), (ILabelProvider)new ObjectsLabelProvider(), contentProvider){

            public void create() {
                super.create();
                this.getTreeViewer().expandAll();
            }
        };
        selectionDialog.setAllowMultiple(false);
        selectionDialog.setTitle(property.getTitle());
        selectionDialog.setMessage("Select component:");
        selectionDialog.setValidator(validator);
        selectionDialog.setInput((Object)new Object[]{thisComponent.getRoot()});
        XmlObjectInfo component = this.getValueComponent((Property)property);
        selectionDialog.setInitialSelection((Object)component);
        if (selectionDialog.open() == 0) {
            XmlObjectInfo component2 = (XmlObjectInfo)selectionDialog.getFirstResult();
            this.setComponent(property, component2);
        }
    }

    private ITreeContentProvider createContentProvider(final Class<?> propertyType) {
        ITreeContentProvider[] contentProvider;
        contentProvider = new ITreeContentProvider[]{new ObjectsTreeContentProvider((Predicate)new Predicate<ObjectInfo>(){

            @Override
            public boolean test(ObjectInfo t) {
                return ObjectPropertyEditor.this.isValidComponent(propertyType, t) || this.hasValidComponents(t);
            }

            private boolean hasValidComponents(ObjectInfo t) {
                return contentProvider[0].getChildren((Object)t).length != 0;
            }
        })};
        return contentProvider[0];
    }

    /*
     * WARNING - void declaration
     */
    private boolean isValidComponent(Class<?> propertyType, Object element) {
        Object object = element;
        if (object instanceof XmlObjectInfo) {
            void component;
            XmlObjectInfo xmlObjectInfo = (XmlObjectInfo)object;
            XmlObjectInfo cfr_ignored_0 = (XmlObjectInfo)object;
            Class componentClass = component.getDescription().getComponentClass();
            return componentClass != null && propertyType.isAssignableFrom(componentClass);
        }
        return false;
    }

    public void setComponent(final GenericProperty property, final XmlObjectInfo component) throws Exception {
        ExecutionUtils.run((ObjectInfo)property.getObject(), (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                ObjectPropertyEditor.this.setComponent0(property, component);
            }
        });
    }

    private void setComponent0(GenericProperty property, XmlObjectInfo component) throws Exception {
        if (component != null) {
            String name = NameSupport.ensureName(component);
            String expression = "{Binding ElementName=" + name + "}";
            property.setExpression(expression, (Object)component);
        }
    }
}

