/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.errors.report2;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.core.branding.BrandingUtils;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.editor.errors.report2.FileReportEntry;
import org.eclipse.wb.internal.core.utils.IOUtils2;
import org.eclipse.wb.internal.core.utils.platform.PlatformInfo;
import org.eclipse.wb.internal.core.utils.platform.PluginUtilities;
import org.eclipse.wb.internal.core.utils.product.ProductInfo;

public final class EnvironmentFileReportInfo
extends FileReportEntry {
    private static final String CR = "\n";
    private final IProject m_project;

    public EnvironmentFileReportInfo(IProject project) {
        super("environment.txt");
        this.m_project = project;
    }

    @Override
    protected InputStream getContents() throws Exception {
        String contents = EnvironmentFileReportInfo.createContents(this.m_project);
        return IOUtils.toInputStream((String)contents);
    }

    private static String createContents(IProject project) {
        String m_mozillaResult;
        String c = "";
        c = String.valueOf(c) + "Product Name: " + BrandingUtils.getBranding().getProductName() + CR;
        c = String.valueOf(c) + "Product Version: " + ProductInfo.getProduct().getVersion() + "[" + ProductInfo.getProduct().getBuild() + "]" + CR;
        c = String.valueOf(c) + "Installation Path: " + EnvironmentFileReportInfo.getInstallationPath() + CR;
        c = String.valueOf(c) + "Eclipse Version: " + PlatformInfo.getEclipseVersion().toString() + CR;
        c = String.valueOf(c) + "Eclipse Build Name: " + PlatformInfo.getEclipseBuildName() + CR;
        c = String.valueOf(c) + "Eclipse Build ID: " + PlatformInfo.getEclipseBuildId() + CR;
        c = String.valueOf(c) + "IDE Name: " + PlatformInfo.getIDEName() + CR;
        c = String.valueOf(c) + "IDE Version: " + PlatformInfo.getIDEVersionString() + CR;
        c = String.valueOf(c) + "IDE NL: " + PlatformInfo.getIDENL() + CR;
        c = String.valueOf(c) + "Eclipse Commands: " + StringUtils.replaceChars((String)EnvironmentFileReportInfo.getSystemProperty("eclipse.commands"), (String)"\n\r", (String)" ") + CR;
        c = String.valueOf(c) + "Eclipse VM: " + EnvironmentFileReportInfo.getSystemProperty("eclipse.vm") + CR;
        c = String.valueOf(c) + "Eclipse VM Args: " + EnvironmentFileReportInfo.getSystemProperty("eclipse.vmargs") + CR;
        c = String.valueOf(c) + "OS Name: " + EnvironmentFileReportInfo.getSystemProperty("os.name") + CR;
        c = String.valueOf(c) + "OS Arch: " + EnvironmentFileReportInfo.getSystemProperty("os.arch") + CR;
        c = String.valueOf(c) + "OS Version: " + EnvironmentFileReportInfo.getSystemProperty("os.version") + CR;
        String linuxDescription = EnvironmentFileReportInfo.getLinuxDescription();
        if (!StringUtils.isEmpty((String)linuxDescription)) {
            c = String.valueOf(c) + "Linux Description: " + linuxDescription + CR;
        }
        if (!StringUtils.isEmpty((String)(m_mozillaResult = EnvironmentFileReportInfo.tryCreateMozilla()))) {
            c = String.valueOf(c) + "Browser Creation Result: " + m_mozillaResult + CR;
        }
        Runtime runtime = Runtime.getRuntime();
        c = String.valueOf(c) + "Available Processors: " + runtime.availableProcessors() + CR;
        c = String.valueOf(c) + "Memory Max: " + runtime.maxMemory() + CR;
        c = String.valueOf(c) + "Memory Total: " + runtime.totalMemory() + CR;
        c = String.valueOf(c) + "Memory Free: " + runtime.freeMemory() + CR;
        c = String.valueOf(c) + "Java Vendor: " + EnvironmentFileReportInfo.getSystemProperty("java.vendor") + CR;
        c = String.valueOf(c) + "Java Version: " + EnvironmentFileReportInfo.getSystemProperty("java.version") + CR;
        c = String.valueOf(c) + "Java Library Path: \n" + EnvironmentFileReportInfo.getSystemProperty("java.library.path") + CR;
        c = String.valueOf(c) + "Project Class Path: \n" + EnvironmentFileReportInfo.getClassPath(project) + CR;
        return c;
    }

    private static String getClassPath(IProject project) {
        String classPath = "";
        return classPath;
    }

    private static String getInstallationPath() {
        URL installUrl = PluginUtilities.getInstallUrl(ProductInfo.getProduct().getPluginId());
        String installationPath = "Unknown";
        try {
            if (installUrl != null && (installationPath = FileLocator.toFileURL((URL)installUrl).getPath()).length() > 3 && installationPath.charAt(0) == '/' && installationPath.charAt(2) == ':') {
                installationPath = installationPath.substring(1);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return installationPath;
    }

    private static String getSystemProperty(String prop) {
        String propValue = System.getProperty(prop);
        return propValue == null ? "" : propValue;
    }

    private static String getLinuxDescription() {
        StringBuilder result = new StringBuilder();
        if (EnvironmentUtils.IS_LINUX) {
            String[] files = new String[]{"/etc/lsb-release", "/etc/lsb_release", "/etc/system-release", "/etc/fedora-release", "/etc/SuSE-release", "/etc/redhat-release", "/etc/release", "/proc/version_signature", "/proc/version", "/etc/issue"};
            int i = 0;
            while (i < files.length) {
                File file = new File(files[i]);
                if (file.exists() && file.canRead()) {
                    try {
                        String version = IOUtils2.readString(file).trim();
                        if (version != null && result.indexOf(version) == -1) {
                            result.append(version);
                            result.append(CR);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        return result.toString();
    }

    /*
     * Loose catch block
     */
    private static String tryCreateMozilla() {
        if (EnvironmentUtils.IS_LINUX) {
            String string;
            PrintStream newOut;
            PrintStream oldOut;
            boolean oldDebug;
            block9: {
                oldDebug = Device.DEBUG;
                Device.DEBUG = true;
                oldOut = System.out;
                Shell shell = null;
                newOut = null;
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    newOut = new PrintStream(baos);
                    System.setOut(newOut);
                    shell = new Shell();
                    try {
                        new Browser((Composite)shell, 0);
                    }
                    catch (Throwable e) {
                        DesignerPlugin.log(e);
                    }
                    string = baos.toString();
                    if (shell == null) break block9;
                }
                catch (Throwable throwable) {
                    if (shell != null) {
                        shell.dispose();
                    }
                    System.setOut(oldOut);
                    IOUtils.closeQuietly((OutputStream)newOut);
                    Device.DEBUG = oldDebug;
                    catch (Throwable throwable2) {
                        if (shell != null) {
                            shell.dispose();
                        }
                        System.setOut(oldOut);
                        IOUtils.closeQuietly(newOut);
                        Device.DEBUG = oldDebug;
                        throw throwable2;
                    }
                }
                shell.dispose();
            }
            System.setOut(oldOut);
            IOUtils.closeQuietly((OutputStream)newOut);
            Device.DEBUG = oldDebug;
            return string;
        }
        return "";
    }
}

