/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.gef.policy.layout.generic;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.draw2d.ICursorConstants;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.internal.core.utils.ui.DrawUtils;

public abstract class AbstractPopupFigure
extends Figure {
    private static final int MARGIN = 6;
    private static final Color COLOR_BACKGROUND = DrawUtils.getShiftedColor(IColorConstants.white, -32);
    private static final Color COLOR_FOREGROUND = DrawUtils.getShiftedColor(IColorConstants.white, -64);
    private final IEditPartViewer m_viewer;

    public AbstractPopupFigure(IEditPartViewer viewer, int width, int height) {
        this.m_viewer = viewer;
        this.setSize(width + 6, height + 6);
        this.setBackgroundColor(COLOR_BACKGROUND);
        this.setForegroundColor(COLOR_FOREGROUND);
        this.setCursor(ICursorConstants.HAND);
        this.addMouseListener((MouseListener)new MouseListener.Stub(){

            public void mousePressed(MouseEvent event) {
                event.consume();
                MenuManager manager = new MenuManager();
                AbstractPopupFigure.this.fillMenu((IMenuManager)manager);
                Control control = AbstractPopupFigure.this.m_viewer.getControl();
                Menu menu = manager.createContextMenu(control);
                menu.setVisible(true);
            }
        });
    }

    @Override
    protected void paintClientArea(Graphics graphics) {
        org.eclipse.draw2d.geometry.Rectangle clientArea = this.getClientArea();
        graphics.fillRectangle(clientArea);
        graphics.drawRectangle(clientArea.getResized(-1, -1));
        ImageDescriptor imageDescriptor = this.getImageDescriptor();
        if (imageDescriptor != null) {
            Image image = imageDescriptor.createImage();
            Rectangle imageBounds = image.getBounds();
            int x = (clientArea.width - imageBounds.width) / 2;
            int y = (clientArea.height - imageBounds.height) / 2;
            graphics.drawImage(image, x, y);
            image.dispose();
        }
    }

    protected abstract ImageDescriptor getImageDescriptor();

    protected abstract void fillMenu(IMenuManager var1);
}

