/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.model.clipboard;

import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.clipboard.ClipboardCommand;
import org.eclipse.wb.internal.core.xml.model.clipboard.IClipboardObjectProperty;
import org.eclipse.wb.internal.core.xml.model.property.GenericProperty;
import org.eclipse.wb.internal.core.xml.model.property.GenericPropertyImpl;

public final class PropertiesClipboardCommand
extends ClipboardCommand {
    private static final long serialVersionUID = 0L;
    private final Map<String, String> m_propertyTitleToSource = Maps.newTreeMap();
    private final Map<String, Object> m_propertyTitleToObject = Maps.newTreeMap();

    /*
     * WARNING - void declaration
     */
    public PropertiesClipboardCommand(XmlObjectInfo object) throws Exception {
        Property[] propertyArray = object.getProperties();
        int n = propertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Property property;
            Object genericProperty;
            String clipboardSource;
            Property property2 = propertyArray[n2];
            String title = property2.getTitle();
            if (property2 instanceof GenericProperty && property2.isModified() && (clipboardSource = (genericProperty = (GenericPropertyImpl)property2).getClipboardSource()) != null) {
                this.m_propertyTitleToSource.put(title, clipboardSource);
            }
            if ((property = property2) instanceof IClipboardObjectProperty) {
                void objectProperty;
                IClipboardObjectProperty cfr_ignored_0 = (IClipboardObjectProperty)property;
                IClipboardObjectProperty cfr_ignored_1 = (IClipboardObjectProperty)property;
                Object value = objectProperty.getClipboardObject();
                if (value != Property.UNKNOWN_VALUE) {
                    this.m_propertyTitleToObject.put(title, value);
                }
            }
            ++n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void execute(XmlObjectInfo object) throws Exception {
        Property[] propertyArray = object.getProperties();
        int n = propertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Property property;
            Property property2 = propertyArray[n2];
            String title = property2.getTitle();
            Property property3 = property2;
            if (property3 instanceof GenericPropertyImpl) {
                GenericPropertyImpl cfr_ignored_0 = (GenericPropertyImpl)property3;
                GenericPropertyImpl cfr_ignored_1 = (GenericPropertyImpl)property3;
                String clipboardSource = this.m_propertyTitleToSource.get(title);
                if (clipboardSource != null) {
                    void genericProperty;
                    genericProperty.setExpression(clipboardSource, Property.UNKNOWN_VALUE);
                }
            }
            if ((property = property2) instanceof IClipboardObjectProperty) {
                IClipboardObjectProperty cfr_ignored_2 = (IClipboardObjectProperty)property;
                IClipboardObjectProperty cfr_ignored_3 = (IClipboardObjectProperty)property;
                Object value = this.m_propertyTitleToObject.get(title);
                if (value != null) {
                    void objectProperty;
                    objectProperty.setClipboardObject(value);
                }
            }
            ++n2;
        }
    }
}

