/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.gef.policy.layout.form;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.wb.core.gef.command.CompoundEditCommand;
import org.eclipse.wb.core.gef.command.EditCommand;
import org.eclipse.wb.core.gef.figure.TextFeedback;
import org.eclipse.wb.core.gef.policy.PolicyUtils;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.Graphics;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.draw2d.Polyline;
import org.eclipse.wb.draw2d.border.Border;
import org.eclipse.wb.draw2d.border.LineBorder;
import org.eclipse.wb.draw2d.events.IFigureListener;
import org.eclipse.wb.draw2d.events.IMouseMoveListener;
import org.eclipse.wb.draw2d.events.IMouseTrackListener;
import org.eclipse.wb.draw2d.events.MouseEvent;
import org.eclipse.wb.draw2d.geometry.PointList;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.gef.core.Command;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.Request;
import org.eclipse.wb.gef.core.tools.Tool;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.gef.graphical.handles.Handle;
import org.eclipse.wb.gef.graphical.handles.MoveHandle;
import org.eclipse.wb.gef.graphical.handles.ResizeHandle;
import org.eclipse.wb.gef.graphical.policies.SelectionEditPolicy;
import org.eclipse.wb.gef.graphical.tools.ResizeTracker;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.gef.policy.layout.absolute.AbsolutePolicyUtils;
import org.eclipse.wb.internal.core.gef.policy.layout.absolute.LineEndFigure;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;
import org.eclipse.wb.internal.swt.gef.policy.layout.form.AnchorFiguresClassic;
import org.eclipse.wb.internal.swt.gef.policy.layout.form.FormLayoutEditPolicyClassic;
import org.eclipse.wb.internal.swt.gef.policy.layout.form.FormUtils;
import org.eclipse.wb.internal.swt.model.layout.form.FormLayoutInfoImplClassic;
import org.eclipse.wb.internal.swt.model.layout.form.IFormAttachmentInfo;
import org.eclipse.wb.internal.swt.model.layout.form.IFormDataInfo;
import org.eclipse.wb.internal.swt.model.layout.form.IFormLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.ICompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.IControlInfo;

public final class FormSelectionEditPolicyClassic<C extends IControlInfo>
extends SelectionEditPolicy {
    private static final int EXTENSION = 8;
    private final Color baseColor = IColorConstants.blue;
    private final Color offsetColor = IColorConstants.lightBlue;
    private final IFormLayoutInfo<C> layoutInfo;
    private final FormLayoutInfoImplClassic<C> layoutImpl;
    private final AnchorFiguresClassic<C> anchorFigures;
    private final ObjectInfo layoutModel;
    private final Map<String, Figure> resizeFeedbacks = Maps.newHashMap();
    private Figure sourceFeedbackFigure;
    private Map<String, Figure> selectionFeedbacks;
    private IMouseTrackListener mouseTrackListener;
    private IMouseMoveListener mouseMoveListener;
    private IFigureListener figureListener;
    private Figure hoverFigure;
    private int mouseQuadrant;
    TextFeedback xTextFeedback;
    TextFeedback yTextFeedback;

    public FormSelectionEditPolicyClassic(IFormLayoutInfo<C> info) {
        this.layoutInfo = info;
        this.layoutModel = info.getUnderlyingModel();
        this.layoutImpl = (FormLayoutInfoImplClassic)this.layoutInfo.getImpl();
        this.anchorFigures = new AnchorFiguresClassic<C>(this, this.layoutImpl);
    }

    public void activate() {
        super.activate();
        this.installQuadrantHandler();
    }

    public void deactivate() {
        super.deactivate();
        this.uninstallQuadrantHandler();
    }

    protected List<Handle> createSelectionHandles() {
        ArrayList handles = Lists.newArrayList();
        MoveHandle moveHandle = new MoveHandle(this.getHost());
        moveHandle.setBorder((Border)new LineBorder(IColorConstants.lightBlue));
        handles.add(moveHandle);
        handles.add(this.createResizeHandle(1));
        handles.add(this.createResizeHandle(4));
        handles.add(this.createResizeHandle(8));
        handles.add(this.createResizeHandle(16));
        handles.add(this.createResizeHandle(20));
        handles.add(this.createResizeHandle(12));
        handles.add(this.createResizeHandle(9));
        handles.add(this.createResizeHandle(17));
        return handles;
    }

    private Handle createResizeHandle(int direction) {
        GraphicalEditPart owner = this.getHost();
        ResizeHandle handle = new ResizeHandle(owner, direction){

            protected Color getBorderColor() {
                return this.isPrimary() ? IColorConstants.white : IColorConstants.lightBlue;
            }

            protected Color getFillColor() {
                return this.isPrimary() ? IColorConstants.lightBlue : IColorConstants.white;
            }
        };
        handle.setDragTrackerTool((Tool)new ResizeTracker(direction, (Object)"_absolute_resize"));
        return handle;
    }

    public boolean understandsRequest(Request request) {
        return super.understandsRequest(request) || request.getType() == "_absolute_resize";
    }

    public void showSourceFeedback(final Request request) {
        if ("_absolute_resize".equals(request.getType())) {
            ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    FormSelectionEditPolicyClassic.this.showResizeFeedback((ChangeBoundsRequest)request);
                }
            });
        }
    }

    public void eraseSourceFeedback(Request request) {
        super.eraseSourceFeedback(request);
        if (this.sourceFeedbackFigure != null) {
            this.removeFeedback(this.sourceFeedbackFigure);
            this.sourceFeedbackFigure = null;
        }
        this.removeResizeFeedbacks();
        this.hideSizeHints();
    }

    private void showResizeFeedback(ChangeBoundsRequest request) throws Exception {
        Rectangle textBounds;
        int newY;
        List<Integer> formLayoutVPercents;
        int y;
        int newX;
        List<Integer> formLayoutHPercents;
        IControlInfo child;
        Iterator<IControlInfo> I;
        boolean componentFound;
        int x;
        FormLayoutEditPolicyClassic<C> layout = this.getLayoutEditPolicy();
        if (this.sourceFeedbackFigure == null) {
            this.sourceFeedbackFigure = new Figure();
            this.sourceFeedbackFigure.setBorder((Border)new LineBorder(AbsolutePolicyUtils.COLOR_OUTLINE));
            this.addFeedback(this.sourceFeedbackFigure);
        }
        int layoutMarginLeft = FormUtils.getLayoutMarginLeft(this.layoutInfo);
        int layoutMarginTop = FormUtils.getLayoutMarginTop(this.layoutInfo);
        int hMargin = this.layoutInfo.getPreferences().getHorizontalContainerGap();
        int phMargin = this.layoutInfo.getPreferences().getHorizontalPercentsGap();
        int hwMargin = this.layoutInfo.getPreferences().getHorizontalComponentGap();
        int sens = this.layoutInfo.getPreferences().getSnapSensitivity();
        int vMargin = this.layoutInfo.getPreferences().getVerticalContainerGap();
        int pvMargin = this.layoutInfo.getPreferences().getVerticalPercentsGap();
        int vwMargin = this.layoutInfo.getPreferences().getVerticalComponentGap();
        this.removeResizeFeedbacks();
        IControlInfo control = (IControlInfo)this.getHost().getModel();
        Rectangle bounds = FormSelectionEditPolicyClassic.getControlModelBounds(control);
        bounds.performTranslate(request.getMoveDelta());
        bounds.resize(request.getSizeDelta());
        Point requestLocation = request.getLocation();
        Point location = requestLocation == null ? FormSelectionEditPolicyClassic.getControlModelBounds(control).getLocation() : requestLocation.getCopy();
        List<IControlInfo> hAttachables = FormUtils.getAttachableControls(this.layoutInfo, control, true);
        List<IControlInfo> vAttachables = FormUtils.getAttachableControls(this.layoutInfo, control, false);
        int direction = request.getResizeDirection();
        int parentWidth = this.layoutInfo.getContainerSize().width;
        int parentHeight = this.layoutInfo.getContainerSize().height;
        Rectangle clientArea = this.layoutInfo.getComposite().getClientArea();
        int parentClientAreaWidth = clientArea.width;
        int parentClientAreaHeight = clientArea.height;
        String xText = "";
        String yText = "";
        if (FormSelectionEditPolicyClassic.hasDirection(direction, 8)) {
            this.removeSelectionFeedbacks("W");
            x = bounds.x;
            componentFound = false;
            if (this.useSnap()) {
                if (hwMargin > -1) {
                    I = FormSelectionEditPolicyClassic.sortControlsByAxisRange(hAttachables, false, location.y).iterator();
                    while (I.hasNext() && !componentFound) {
                        child = I.next();
                        Rectangle childBounds = FormSelectionEditPolicyClassic.getControlModelBounds(child);
                        if (FormUtils.between(x - (childBounds.right() + hwMargin), 0, sens)) {
                            componentFound = true;
                            FormSelectionEditPolicyClassic.setX(bounds, childBounds.right() + hwMargin);
                            this.addVerticalResizeLine("12", child, childBounds.right(), IColorConstants.green);
                            this.addVerticalResizeLine("2", childBounds.right() + hwMargin, this.offsetColor);
                            xText = String.valueOf(FormUtils.getVariableName(child) == null ? String.valueOf(childBounds.right()) : FormUtils.getVariableName(child)) + "+" + hwMargin;
                            continue;
                        }
                        if (FormUtils.between(x - childBounds.right(), -sens, hwMargin)) {
                            componentFound = true;
                            FormSelectionEditPolicyClassic.setX(bounds, childBounds.right());
                            this.addVerticalResizeLine("11", childBounds.right(), this.offsetColor);
                            this.addVerticalResizeLine("12", child, childBounds.right(), IColorConstants.green);
                            xText = FormUtils.getVariableName(child) == null ? String.valueOf(childBounds.right()) : FormUtils.getVariableName(child);
                            continue;
                        }
                        if (!FormUtils.between(x - childBounds.x, -sens, sens)) continue;
                        componentFound = true;
                        FormSelectionEditPolicyClassic.setX(bounds, childBounds.x);
                        this.addVerticalResizeLine("11", childBounds.x, this.offsetColor);
                        this.addVerticalResizeLine("12", child, childBounds.x, IColorConstants.green);
                        String string = xText = FormUtils.getVariableName(child) == null ? String.valueOf(childBounds.right()) : FormUtils.getVariableName(child);
                    }
                }
                if (!componentFound) {
                    boolean snappedToPercent = false;
                    formLayoutHPercents = this.layoutInfo.getPreferences().getHorizontalPercents();
                    for (Integer percent : formLayoutHPercents) {
                        newX = (int)((double)percent.intValue() / 100.0 * (double)parentWidth) + layoutMarginLeft;
                        if (FormUtils.between(x - (newX + hwMargin), 0, sens) && phMargin > -1) {
                            FormSelectionEditPolicyClassic.setX(bounds, newX + phMargin);
                            this.addVerticalResizeLine("3", newX, this.baseColor);
                            this.addVerticalResizeLine("4", newX + phMargin, this.offsetColor);
                            xText = String.valueOf(percent.toString()) + "%+" + phMargin;
                            snappedToPercent = true;
                        } else if (FormUtils.between(x - newX, -sens, hwMargin)) {
                            FormSelectionEditPolicyClassic.setX(bounds, newX);
                            this.addVerticalResizeLine("3", newX, this.offsetColor);
                            xText = String.valueOf(percent.toString()) + "%";
                            snappedToPercent = true;
                        }
                        if (snappedToPercent) break;
                    }
                    if (!snappedToPercent) {
                        int leftPoint = hMargin + layoutMarginLeft;
                        if (hMargin > -1 && x < leftPoint) {
                            FormSelectionEditPolicyClassic.setX(bounds, leftPoint);
                            this.addVerticalResizeLine("2", leftPoint, this.offsetColor);
                        } else {
                            FormSelectionEditPolicyClassic.setX(bounds, FormUtils.snapGrid(x, sens));
                        }
                        xText = String.valueOf(bounds.width);
                    }
                }
            } else {
                xText = String.valueOf(bounds.width);
            }
            this.addVerticalResizeLine("5", bounds.x, parentClientAreaHeight, IColorConstants.red);
        }
        if (FormSelectionEditPolicyClassic.hasDirection(direction, 16)) {
            this.removeSelectionFeedbacks("E");
            x = bounds.right();
            componentFound = false;
            if (this.useSnap()) {
                if (hwMargin > -1) {
                    I = FormSelectionEditPolicyClassic.sortControlsByAxisRange(hAttachables, false, location.y).iterator();
                    while (I.hasNext() && !componentFound) {
                        child = I.next();
                        Rectangle childBounds = FormSelectionEditPolicyClassic.getControlModelBounds(child);
                        if (FormUtils.between(childBounds.x - hwMargin - x, 0, sens)) {
                            componentFound = true;
                            bounds.width = childBounds.x - hwMargin - bounds.x;
                            this.addVerticalResizeLine("12", child, childBounds.x, IColorConstants.green);
                            this.addVerticalResizeLine("2", childBounds.x - hwMargin, this.offsetColor);
                            xText = String.valueOf(FormUtils.getVariableName(child) == null ? String.valueOf(childBounds.x) : FormUtils.getVariableName(child)) + "-" + hwMargin;
                            continue;
                        }
                        if (FormUtils.between(childBounds.x - x, -sens, hwMargin)) {
                            componentFound = true;
                            bounds.width = childBounds.x - bounds.x;
                            this.addVerticalResizeLine("11", childBounds.x, this.offsetColor);
                            this.addVerticalResizeLine("12", child, childBounds.x, IColorConstants.green);
                            xText = FormUtils.getVariableName(child) == null ? String.valueOf(childBounds.x) : FormUtils.getVariableName(child);
                            continue;
                        }
                        if (!FormUtils.between(childBounds.right() - x, -sens, sens)) continue;
                        componentFound = true;
                        bounds.width = childBounds.right() - bounds.x;
                        this.addVerticalResizeLine("11", childBounds.right(), this.offsetColor);
                        this.addVerticalResizeLine("12", child, childBounds.right(), IColorConstants.green);
                        String string = xText = FormUtils.getVariableName(child) == null ? String.valueOf(childBounds.x) : FormUtils.getVariableName(child);
                    }
                }
                if (!componentFound) {
                    boolean snappedToPercent = false;
                    formLayoutHPercents = this.layoutInfo.getPreferences().getHorizontalPercents();
                    for (Integer percent : formLayoutHPercents) {
                        newX = (int)((double)percent.intValue() / 100.0 * (double)parentWidth) + layoutMarginLeft;
                        if (FormUtils.between(newX - hwMargin - x, 0, sens) && phMargin > -1) {
                            bounds.width = newX - bounds.x - phMargin;
                            this.addVerticalResizeLine("3", newX, this.baseColor);
                            this.addVerticalResizeLine("4", newX - phMargin, this.offsetColor);
                            xText = String.valueOf(percent.toString()) + "%-" + phMargin;
                            snappedToPercent = true;
                        } else if (FormUtils.between(newX - x, -sens, hwMargin)) {
                            bounds.width = newX - bounds.x;
                            this.addVerticalResizeLine("3", newX, this.offsetColor);
                            xText = String.valueOf(percent.toString()) + "%";
                            snappedToPercent = true;
                        }
                        if (snappedToPercent) break;
                    }
                    if (!snappedToPercent) {
                        int rightPoint = parentWidth - hMargin + layoutMarginLeft;
                        if (hMargin > -1 && x > rightPoint) {
                            bounds.width = rightPoint - bounds.x;
                            this.addVerticalResizeLine("2", rightPoint, this.offsetColor);
                        } else {
                            bounds.width = FormUtils.snapGrid(x, sens) - bounds.x;
                        }
                        xText = String.valueOf(bounds.width);
                    }
                }
            } else {
                xText = String.valueOf(bounds.width);
            }
            this.addVerticalResizeLine("5", bounds.right(), parentClientAreaHeight, IColorConstants.red);
        }
        if (FormSelectionEditPolicyClassic.hasDirection(direction, 1)) {
            this.removeSelectionFeedbacks("N");
            y = bounds.y;
            componentFound = false;
            if (this.useSnap()) {
                if (vwMargin > -1) {
                    I = FormSelectionEditPolicyClassic.sortControlsByAxisRange(vAttachables, true, location.x).iterator();
                    while (I.hasNext() && !componentFound) {
                        child = I.next();
                        Rectangle childBounds = FormSelectionEditPolicyClassic.getControlModelBounds(child);
                        if (FormUtils.between(y - (childBounds.bottom() + vwMargin), 0, sens)) {
                            componentFound = true;
                            FormSelectionEditPolicyClassic.setY(bounds, childBounds.bottom() + vwMargin);
                            this.addHorizontalResizeLine("12", child, childBounds.bottom(), IColorConstants.green);
                            this.addHorizontalResizeLine("2", childBounds.bottom() + vwMargin, this.offsetColor);
                            yText = String.valueOf(FormUtils.getVariableName(child) == null ? String.valueOf(childBounds.bottom()) : FormUtils.getVariableName(child)) + "+" + vwMargin;
                            continue;
                        }
                        if (FormUtils.between(y - childBounds.bottom(), -sens, vwMargin)) {
                            componentFound = true;
                            FormSelectionEditPolicyClassic.setY(bounds, childBounds.bottom());
                            this.addHorizontalResizeLine("11", childBounds.bottom(), this.offsetColor);
                            this.addHorizontalResizeLine("12", child, childBounds.bottom(), IColorConstants.green);
                            yText = FormUtils.getVariableName(child) == null ? String.valueOf(childBounds.bottom()) : FormUtils.getVariableName(child);
                            continue;
                        }
                        if (!FormUtils.between(y - childBounds.y, -sens, sens)) continue;
                        componentFound = true;
                        FormSelectionEditPolicyClassic.setY(bounds, childBounds.y);
                        this.addHorizontalResizeLine("11", childBounds.y, this.offsetColor);
                        this.addHorizontalResizeLine("12", child, childBounds.y, IColorConstants.green);
                        String string = yText = FormUtils.getVariableName(child) == null ? String.valueOf(childBounds.bottom()) : FormUtils.getVariableName(child);
                    }
                }
                if (!componentFound) {
                    boolean snappedToPercent = false;
                    formLayoutVPercents = this.layoutInfo.getPreferences().getVerticalPercents();
                    for (Integer percent : formLayoutVPercents) {
                        newY = (int)((double)percent.intValue() / 100.0 * (double)parentHeight) + layoutMarginTop;
                        if (FormUtils.between(y - (newY + vwMargin), 0, sens) && pvMargin > -1) {
                            FormSelectionEditPolicyClassic.setY(bounds, newY + pvMargin);
                            this.addHorizontalResizeLine("3", newY, this.baseColor);
                            this.addHorizontalResizeLine("4", newY + pvMargin, this.offsetColor);
                            yText = String.valueOf(percent.toString()) + "%+" + pvMargin;
                            snappedToPercent = true;
                        } else if (FormUtils.between(y - newY, -sens, vwMargin)) {
                            FormSelectionEditPolicyClassic.setY(bounds, newY);
                            this.addHorizontalResizeLine("3", newY, this.offsetColor);
                            yText = String.valueOf(percent.toString()) + "%";
                            snappedToPercent = true;
                        }
                        if (snappedToPercent) break;
                    }
                    if (!snappedToPercent) {
                        int topPoint = vMargin + layoutMarginTop;
                        if (vMargin > -1 && y < topPoint) {
                            FormSelectionEditPolicyClassic.setY(bounds, topPoint);
                            this.addHorizontalResizeLine("2", topPoint, this.offsetColor);
                        } else {
                            FormSelectionEditPolicyClassic.setY(bounds, FormUtils.snapGrid(y, sens));
                        }
                        yText = String.valueOf(bounds.height);
                    }
                }
            } else {
                yText = String.valueOf(bounds.height);
            }
            this.addHorizontalResizeLine("5", bounds.y, parentClientAreaWidth, IColorConstants.red);
        }
        if (FormSelectionEditPolicyClassic.hasDirection(direction, 4)) {
            this.removeSelectionFeedbacks("S");
            y = bounds.bottom();
            componentFound = false;
            if (this.useSnap()) {
                if (vwMargin > -1) {
                    I = FormSelectionEditPolicyClassic.sortControlsByAxisRange(vAttachables, true, location.x).iterator();
                    while (I.hasNext() && !componentFound) {
                        child = I.next();
                        Rectangle childBounds = FormSelectionEditPolicyClassic.getControlModelBounds(child);
                        if (FormUtils.between(childBounds.y - vwMargin - y, 0, sens)) {
                            componentFound = true;
                            bounds.height = childBounds.y - vwMargin - bounds.y;
                            this.addHorizontalResizeLine("12", child, childBounds.y, IColorConstants.green);
                            this.addHorizontalResizeLine("2", childBounds.y - vwMargin, this.offsetColor);
                            yText = String.valueOf(FormUtils.getVariableName(child) == null ? String.valueOf(childBounds.y) : FormUtils.getVariableName(child)) + "-" + vwMargin;
                            continue;
                        }
                        if (FormUtils.between(childBounds.y - y, -sens, vwMargin)) {
                            componentFound = true;
                            bounds.height = childBounds.y - bounds.y;
                            this.addHorizontalResizeLine("11", childBounds.y, this.offsetColor);
                            this.addHorizontalResizeLine("12", child, childBounds.y, IColorConstants.green);
                            yText = FormUtils.getVariableName(child) == null ? String.valueOf(childBounds.y) : FormUtils.getVariableName(child);
                            continue;
                        }
                        if (!FormUtils.between(childBounds.bottom() - y, -sens, sens)) continue;
                        componentFound = true;
                        bounds.height = childBounds.bottom() - bounds.y;
                        this.addHorizontalResizeLine("11", childBounds.bottom(), this.offsetColor);
                        this.addHorizontalResizeLine("12", child, childBounds.bottom(), IColorConstants.green);
                        String string = yText = FormUtils.getVariableName(child) == null ? String.valueOf(childBounds.y) : FormUtils.getVariableName(child);
                    }
                }
                if (!componentFound) {
                    boolean snappedToPercent = false;
                    formLayoutVPercents = this.layoutInfo.getPreferences().getVerticalPercents();
                    for (Integer percent : formLayoutVPercents) {
                        newY = (int)((double)percent.intValue() / 100.0 * (double)parentHeight) + layoutMarginTop;
                        if (FormUtils.between(newY - vwMargin - y, 0, sens) && pvMargin > -1) {
                            bounds.height = newY - pvMargin - bounds.y;
                            this.addHorizontalResizeLine("3", newY, this.baseColor);
                            this.addHorizontalResizeLine("4", newY - pvMargin, this.offsetColor);
                            yText = String.valueOf(percent.toString()) + "%-" + pvMargin;
                            snappedToPercent = true;
                        } else if (FormUtils.between(newY - y, -sens, vwMargin)) {
                            bounds.height = newY - bounds.y;
                            this.addHorizontalResizeLine("3", newY, this.offsetColor);
                            yText = String.valueOf(percent.toString()) + "%";
                            snappedToPercent = true;
                        }
                        if (snappedToPercent) break;
                    }
                    if (!snappedToPercent) {
                        int bottomPoint = parentHeight - vMargin + layoutMarginTop;
                        if (vMargin > -1 && y > bottomPoint) {
                            bounds.height = bottomPoint - bounds.y;
                            this.addHorizontalResizeLine("2", bottomPoint, this.offsetColor);
                        } else {
                            bounds.height = FormUtils.snapGrid(y, sens) - bounds.y;
                        }
                        yText = String.valueOf(bounds.height);
                    }
                }
            } else {
                yText = String.valueOf(bounds.height);
            }
            this.addHorizontalResizeLine("5", bounds.bottom(), parentClientAreaWidth, IColorConstants.red);
        }
        Rectangle feedbackBounds = bounds.getCopy();
        this.translateModelToFeedback((Translatable)feedbackBounds);
        this.sourceFeedbackFigure.setBounds(feedbackBounds);
        if (xText.length() != 0) {
            int x2;
            if (this.xTextFeedback == null) {
                this.xTextFeedback = layout.createTextFeedback(true);
                this.xTextFeedback.add();
            }
            this.xTextFeedback.setText(xText);
            Dimension textSize = this.xTextFeedback.getSize();
            textBounds = bounds.getCopy();
            textBounds.y = parentClientAreaHeight + 1;
            int n = x2 = FormSelectionEditPolicyClassic.hasDirection(direction, 16) ? textBounds.right() : textBounds.x;
            if ((x2 -= textSize.width / 2) < 0) {
                x2 = 0;
            } else if (x2 + textSize.width > parentClientAreaWidth) {
                x2 = parentClientAreaWidth - textSize.width;
            }
            textBounds.x = x2;
            this.translateModelToFeedback((Translatable)textBounds);
            this.xTextFeedback.setLocation(textBounds.getLocation());
        }
        if (yText.length() != 0) {
            int y2;
            if (this.yTextFeedback == null) {
                this.yTextFeedback = layout.createTextFeedback(false);
                this.yTextFeedback.add();
            }
            this.yTextFeedback.setText(yText);
            Dimension textSize = this.yTextFeedback.getSize();
            textBounds = bounds.getCopy();
            textBounds.x = parentClientAreaWidth + 1;
            int n = y2 = FormSelectionEditPolicyClassic.hasDirection(direction, 4) ? textBounds.bottom() : textBounds.y;
            if ((y2 -= textSize.height / 2) < 0) {
                y2 = 0;
            } else if (y2 + textSize.height > parentClientAreaHeight) {
                y2 = parentClientAreaHeight - textSize.height;
            }
            textBounds.y = y2;
            this.translateModelToFeedback((Translatable)textBounds);
            this.yTextFeedback.setLocation(textBounds.getLocation());
        }
    }

    public Command getCommand(final Request request) {
        if ("_absolute_resize".equals(request.getType())) {
            return (Command)ExecutionUtils.runObjectLog((RunnableObjectEx)new RunnableObjectEx<Command>(){

                public Command runObject() throws Exception {
                    return FormSelectionEditPolicyClassic.this.getResizeCommand((ChangeBoundsRequest)request);
                }
            }, null);
        }
        return null;
    }

    protected Command getResizeCommand(ChangeBoundsRequest request) throws Exception {
        int newY;
        List<Integer> formLayoutVPercents;
        int y;
        int newX;
        List<Integer> formLayoutHPercents;
        Rectangle componentBounds;
        IControlInfo child;
        Iterator<IControlInfo> I;
        IFormAttachmentInfo attachment;
        EditCommand cmd;
        int x;
        int layoutMarginLeft = FormUtils.getLayoutMarginLeft(this.layoutInfo);
        int layoutMarginTop = FormUtils.getLayoutMarginTop(this.layoutInfo);
        int hMargin = this.layoutInfo.getPreferences().getHorizontalContainerGap();
        int phMargin = this.layoutInfo.getPreferences().getHorizontalPercentsGap();
        int hwMargin = this.layoutInfo.getPreferences().getHorizontalComponentGap();
        int sens = this.layoutInfo.getPreferences().getSnapSensitivity();
        int vMargin = this.layoutInfo.getPreferences().getVerticalContainerGap();
        int pvMargin = this.layoutInfo.getPreferences().getVerticalPercentsGap();
        int vwMargin = this.layoutInfo.getPreferences().getVerticalComponentGap();
        IControlInfo control = (IControlInfo)this.getHost().getModel();
        CompoundEditCommand compoundCommand = new CompoundEditCommand(this.layoutModel);
        Rectangle bounds = FormSelectionEditPolicyClassic.getControlModelBounds(control);
        bounds.performTranslate(request.getMoveDelta());
        bounds.resize(request.getSizeDelta());
        Point requestLocation = request.getLocation();
        Point location = requestLocation == null ? FormSelectionEditPolicyClassic.getControlModelBounds(control).getLocation() : requestLocation.getCopy();
        List<IControlInfo> hAttachables = FormUtils.getAttachableControls(this.layoutInfo, control, true);
        List<IControlInfo> vAttachables = FormUtils.getAttachableControls(this.layoutInfo, control, false);
        int direction = request.getResizeDirection();
        int parentWidth = this.layoutInfo.getContainerSize().width;
        int parentHeight = this.layoutInfo.getContainerSize().height;
        IFormDataInfo formDataInfo = (IFormDataInfo)this.layoutInfo.getLayoutData2(control);
        if (FormSelectionEditPolicyClassic.hasDirection(direction, 8)) {
            x = bounds.x;
            cmd = null;
            attachment = formDataInfo.getAttachment(1);
            if (this.useSnap()) {
                if (hwMargin > -1) {
                    I = FormSelectionEditPolicyClassic.sortControlsByAxisRange(hAttachables, false, location.y).iterator();
                    while (I.hasNext() && cmd == null) {
                        child = I.next();
                        componentBounds = FormSelectionEditPolicyClassic.getControlModelBounds(child);
                        if (FormUtils.between(x - (componentBounds.right() + hwMargin), 0, sens)) {
                            cmd = new ResizeToControlCommand(this, attachment, child, 4, hwMargin);
                            continue;
                        }
                        if (FormUtils.between(x - componentBounds.right(), -sens, hwMargin)) {
                            cmd = new ResizeToControlCommand(this, attachment, child, 4, 0);
                            continue;
                        }
                        if (!FormUtils.between(x - componentBounds.x, -sens, sens)) continue;
                        cmd = new ResizeToControlCommand(this, attachment, child, 1, 0);
                    }
                }
                if (cmd == null) {
                    formLayoutHPercents = this.layoutInfo.getPreferences().getHorizontalPercents();
                    for (Integer percent : formLayoutHPercents) {
                        newX = (int)((double)percent.intValue() / 100.0 * (double)parentWidth) + layoutMarginLeft;
                        if (FormUtils.between(x - (newX + hwMargin), 0, sens) && phMargin > -1) {
                            cmd = new ResizeToPercentOffsetCommand(attachment, percent, phMargin);
                        } else if (FormUtils.between(x - newX, -sens, hwMargin)) {
                            cmd = new ResizeToPercentOffsetCommand(attachment, percent, 0);
                        }
                        if (cmd != null) break;
                    }
                    if (cmd == null) {
                        cmd = hMargin > -1 && x < hMargin + layoutMarginLeft ? new ResizeToMarginCommand(attachment, 1, hMargin) : new ResizeToOffsetCommand(attachment, parentWidth, FormUtils.snapGrid(x - layoutMarginLeft, sens));
                    }
                }
            } else {
                cmd = new ResizeToOffsetCommand(attachment, parentWidth, x - layoutMarginLeft);
            }
            compoundCommand.add(cmd);
        }
        if (FormSelectionEditPolicyClassic.hasDirection(direction, 16)) {
            x = bounds.right();
            cmd = null;
            attachment = formDataInfo.getAttachment(4);
            if (this.useSnap()) {
                if (hwMargin > -1) {
                    I = FormSelectionEditPolicyClassic.sortControlsByAxisRange(hAttachables, false, location.y).iterator();
                    while (I.hasNext() && cmd == null) {
                        child = I.next();
                        componentBounds = FormSelectionEditPolicyClassic.getControlModelBounds(child);
                        if (FormUtils.between(componentBounds.x - hwMargin - x, 0, sens)) {
                            cmd = new ResizeToControlCommand(this, attachment, child, 1, -hwMargin);
                            continue;
                        }
                        if (FormUtils.between(componentBounds.x - x, -sens, hwMargin)) {
                            cmd = new ResizeToControlCommand(this, attachment, child, 1, 0);
                            continue;
                        }
                        if (!FormUtils.between(componentBounds.right() - x, -sens, sens)) continue;
                        cmd = new ResizeToControlCommand(this, attachment, child, 4, 0);
                    }
                }
                if (cmd == null) {
                    formLayoutHPercents = this.layoutInfo.getPreferences().getHorizontalPercents();
                    for (Integer percent : formLayoutHPercents) {
                        newX = (int)((double)percent.intValue() / 100.0 * (double)parentWidth) + layoutMarginLeft;
                        if (FormUtils.between(newX - hwMargin - x, 0, sens) && phMargin > -1) {
                            cmd = new ResizeToPercentOffsetCommand(attachment, percent, -phMargin);
                        } else if (FormUtils.between(newX - x, -sens, hwMargin)) {
                            cmd = new ResizeToPercentOffsetCommand(attachment, percent, 0);
                        }
                        if (cmd != null) break;
                    }
                    if (cmd == null) {
                        cmd = hMargin > -1 && x > parentWidth - hMargin + layoutMarginLeft ? new ResizeToMarginCommand(attachment, 4, hMargin) : new ResizeToOffsetCommand(attachment, parentWidth, FormUtils.snapGrid(x - layoutMarginLeft, sens));
                    }
                }
            } else {
                cmd = new ResizeToOffsetCommand(attachment, parentWidth, x - layoutMarginLeft);
            }
            compoundCommand.add((Command)cmd);
        }
        if (FormSelectionEditPolicyClassic.hasDirection(direction, 1)) {
            y = bounds.y;
            cmd = null;
            attachment = formDataInfo.getAttachment(8);
            if (this.useSnap()) {
                if (vwMargin > -1) {
                    I = FormSelectionEditPolicyClassic.sortControlsByAxisRange(vAttachables, true, location.x).iterator();
                    while (I.hasNext() && cmd == null) {
                        child = I.next();
                        componentBounds = FormSelectionEditPolicyClassic.getControlModelBounds(child);
                        if (FormUtils.between(y - (componentBounds.bottom() + vwMargin), 0, sens)) {
                            cmd = new ResizeToControlCommand(this, attachment, child, 32, vwMargin);
                            continue;
                        }
                        if (FormUtils.between(y - componentBounds.bottom(), -sens, vwMargin)) {
                            cmd = new ResizeToControlCommand(this, attachment, child, 32, 0);
                            continue;
                        }
                        if (!FormUtils.between(y - componentBounds.y, -sens, sens)) continue;
                        cmd = new ResizeToControlCommand(this, attachment, child, 8, 0);
                    }
                }
                if (cmd == null) {
                    formLayoutVPercents = this.layoutInfo.getPreferences().getVerticalPercents();
                    for (Integer percent : formLayoutVPercents) {
                        newY = (int)((double)percent.intValue() / 100.0 * (double)parentHeight) + layoutMarginTop;
                        if (FormUtils.between(y - (newY + vwMargin), 0, sens) && pvMargin > -1) {
                            cmd = new ResizeToPercentOffsetCommand(attachment, percent, pvMargin);
                        } else if (FormUtils.between(y - newY, -sens, vwMargin)) {
                            cmd = new ResizeToPercentOffsetCommand(attachment, percent, 0);
                        }
                        if (cmd != null) break;
                    }
                    if (cmd == null) {
                        cmd = vMargin > -1 && y < vMargin + layoutMarginTop ? new ResizeToMarginCommand(attachment, 8, vMargin) : new ResizeToOffsetCommand(attachment, parentHeight, FormUtils.snapGrid(y - layoutMarginTop, sens));
                    }
                }
            } else {
                cmd = new ResizeToOffsetCommand(attachment, parentHeight, y - layoutMarginTop);
            }
            compoundCommand.add((Command)cmd);
        }
        if (FormSelectionEditPolicyClassic.hasDirection(direction, 4)) {
            y = bounds.bottom();
            cmd = null;
            attachment = formDataInfo.getAttachment(32);
            if (this.useSnap()) {
                if (vwMargin > -1) {
                    I = FormSelectionEditPolicyClassic.sortControlsByAxisRange(vAttachables, true, location.x).iterator();
                    while (I.hasNext() && cmd == null) {
                        child = I.next();
                        componentBounds = FormSelectionEditPolicyClassic.getControlModelBounds(child);
                        if (FormUtils.between(componentBounds.y - vwMargin - y, 0, sens)) {
                            cmd = new ResizeToControlCommand(this, attachment, child, 8, -vwMargin);
                            continue;
                        }
                        if (FormUtils.between(componentBounds.y - y, -sens, vwMargin)) {
                            cmd = new ResizeToControlCommand(this, attachment, child, 8, 0);
                            continue;
                        }
                        if (!FormUtils.between(componentBounds.bottom() - y, -sens, sens)) continue;
                        cmd = new ResizeToControlCommand(this, attachment, child, 32, 0);
                    }
                }
                if (cmd == null) {
                    formLayoutVPercents = this.layoutInfo.getPreferences().getVerticalPercents();
                    for (Integer percent : formLayoutVPercents) {
                        newY = (int)((double)percent.intValue() / 100.0 * (double)parentHeight) + layoutMarginTop;
                        if (FormUtils.between(newY - vwMargin - y, 0, sens)) {
                            cmd = new ResizeToPercentOffsetCommand(attachment, percent, -pvMargin);
                        } else if (FormUtils.between(newY - y, -sens, vwMargin)) {
                            cmd = new ResizeToPercentOffsetCommand(attachment, percent, 0);
                        }
                        if (cmd != null) break;
                    }
                    if (cmd == null) {
                        cmd = vMargin > -1 && y > parentHeight - vMargin + layoutMarginTop ? new ResizeToMarginCommand(attachment, 32, vMargin) : new ResizeToOffsetCommand(attachment, parentHeight, FormUtils.snapGrid(y - layoutMarginTop, sens));
                    }
                }
            } else {
                cmd = new ResizeToOffsetCommand(attachment, parentHeight, y - layoutMarginTop);
            }
            compoundCommand.add((Command)cmd);
        }
        return compoundCommand;
    }

    protected void showSelection() {
        if (this.getHost().getSelected() == 0) {
            return;
        }
        super.showSelection();
        if (!(this.getHost().getModel() instanceof IControlInfo)) {
            return;
        }
        if (this.selectionFeedbacks == null) {
            try {
                this.selectionFeedbacks = Maps.newHashMap();
                this.addSideLinesFeedbacks();
            }
            catch (Throwable e) {
                DesignerPlugin.log((Throwable)e);
            }
        }
        this.anchorFigures.hide();
        this.anchorFigures.show();
    }

    public void hideSelection() {
        super.hideSelection();
        this.hideSelectionFeedbacks();
        this.anchorFigures.hide();
    }

    private void hideSelectionFeedbacks() {
        if (this.selectionFeedbacks != null) {
            for (Figure feedback : this.selectionFeedbacks.values()) {
                FigureUtils.removeFigure((Figure)feedback);
            }
            this.selectionFeedbacks = null;
        }
    }

    private boolean isVSnapPercent(int percent) {
        List<Integer> formLayoutVPercents = this.layoutInfo.getPreferences().getVerticalPercents();
        return formLayoutVPercents.indexOf(percent) != -1;
    }

    private boolean isHSnapPercent(int percent) {
        List<Integer> formLayoutHPercents = this.layoutInfo.getPreferences().getHorizontalPercents();
        return formLayoutHPercents.indexOf(percent) != -1;
    }

    private void addVerticalSideLinesFeedbacks(int parentWidth, int parentHeight, Rectangle bounds, IFormAttachmentInfo<C> attachment) {
        if (attachment == null) {
            return;
        }
        boolean isLeft = this.layoutImpl.isLeft(attachment);
        int sideMargin = this.layoutInfo.getPreferences().getHorizontalContainerGap();
        if (this.layoutImpl.isParentAttachment(attachment)) {
            int percent = attachment.getNumerator();
            int offset = attachment.getOffset();
            if (isLeft && percent == 0) {
                if (offset == sideMargin) {
                    this.addVerticalFeedbackLine("W1", bounds.x, 0, parentHeight, this.offsetColor);
                } else {
                    int thisY = bounds.getCenter().y;
                    this.addHorizontalFeedbackLine("W1", thisY, 0, bounds.x, this.offsetColor);
                    this.addLineEndFigure("W2", 0, thisY, 1, this.offsetColor);
                }
            } else if (!isLeft && percent == 100) {
                if (offset == -sideMargin) {
                    this.addVerticalFeedbackLine("E1", bounds.right(), 0, parentHeight, this.offsetColor);
                } else {
                    int thisY = bounds.getCenter().y;
                    this.addHorizontalFeedbackLine("E1", thisY, bounds.right(), parentWidth, this.offsetColor);
                    this.addLineEndFigure("E2", parentWidth, thisY, 4, this.offsetColor);
                }
            } else if (this.isHSnapPercent(percent)) {
                int percentX;
                if (isLeft) {
                    percentX = bounds.x - offset;
                    if (offset == this.layoutInfo.getPreferences().getHorizontalPercentsGap()) {
                        this.addVerticalFeedbackLine("W2", percentX + offset, 0, parentHeight, this.offsetColor);
                    }
                } else {
                    percentX = bounds.right() - offset;
                    if (offset == -this.layoutInfo.getPreferences().getHorizontalPercentsGap()) {
                        this.addVerticalFeedbackLine("E2", percentX + offset, 0, parentHeight, this.offsetColor);
                    }
                }
                this.addVerticalFeedbackLine(isLeft ? "W3" : "E3", percentX, 0, parentHeight, this.baseColor);
            }
        } else if (this.layoutImpl.isControlAttachment(attachment) && this.layoutImpl.shouldShowConstraintLine(attachment)) {
            this.addSideLinesForControlAttachment(bounds, attachment, false);
        }
    }

    private void addHorizontalSideLinesFeedbacks(int parentWidth, int parentHeight, Rectangle bounds, IFormAttachmentInfo<C> attachment) {
        if (attachment == null) {
            return;
        }
        boolean isTop = this.layoutImpl.isTop(attachment);
        int sideMargin = this.layoutInfo.getPreferences().getVerticalContainerGap();
        if (this.layoutImpl.isParentAttachment(attachment)) {
            int percent = attachment.getNumerator();
            int offset = attachment.getOffset();
            if (isTop && percent == 0) {
                if (offset == sideMargin) {
                    this.addHorizontalFeedbackLine("N1", bounds.y, 0, parentWidth, this.offsetColor);
                } else {
                    int thisX = bounds.getCenter().x;
                    this.addVerticalFeedbackLine("N1", thisX, 0, bounds.y, this.offsetColor);
                    this.addLineEndFigure("N2", thisX, 0, 8, this.offsetColor);
                }
            } else if (!isTop && percent == 100) {
                if (offset == -sideMargin) {
                    this.addHorizontalFeedbackLine("S1", bounds.bottom(), 0, parentWidth, this.offsetColor);
                } else {
                    int thisX = bounds.getCenter().x;
                    this.addVerticalFeedbackLine("S1", thisX, bounds.bottom(), parentHeight, this.offsetColor);
                    this.addLineEndFigure("S2", thisX, parentHeight, 32, this.offsetColor);
                }
            } else if (this.isVSnapPercent(percent)) {
                int percentY;
                if (isTop) {
                    percentY = bounds.y - offset;
                    if (offset == this.layoutInfo.getPreferences().getVerticalPercentsGap()) {
                        this.addHorizontalFeedbackLine("N2", percentY + offset, 0, parentWidth, this.offsetColor);
                    }
                } else {
                    percentY = bounds.bottom() - offset;
                    if (offset == -this.layoutInfo.getPreferences().getVerticalPercentsGap()) {
                        this.addHorizontalFeedbackLine("S2", percentY + offset, 0, parentWidth, this.offsetColor);
                    }
                }
                this.addHorizontalFeedbackLine(isTop ? "N3" : "S3", percentY, 0, parentWidth, this.baseColor);
            }
        } else if (this.layoutImpl.isControlAttachment(attachment) && this.layoutImpl.shouldShowConstraintLine(attachment)) {
            this.addSideLinesForControlAttachment(bounds, attachment, true);
        }
    }

    private void addSideLinesFeedbacks() throws Exception {
        IControlInfo control = (IControlInfo)this.getHost().getModel();
        ICompositeInfo composite = this.layoutInfo.getComposite();
        int parentWidth = composite.getClientArea().width;
        int parentHeight = composite.getClientArea().height;
        Rectangle bounds = FormSelectionEditPolicyClassic.getControlModelBounds(control);
        this.addVerticalSideLinesFeedbacks(parentWidth, parentHeight, bounds, this.layoutImpl.getAttachment(control, 1));
        this.addVerticalSideLinesFeedbacks(parentWidth, parentHeight, bounds, this.layoutImpl.getAttachment(control, 4));
        this.addHorizontalSideLinesFeedbacks(parentWidth, parentHeight, bounds, this.layoutImpl.getAttachment(control, 8));
        this.addHorizontalSideLinesFeedbacks(parentWidth, parentHeight, bounds, this.layoutImpl.getAttachment(control, 32));
    }

    private void addSideLinesForControlAttachment(Rectangle b, IFormAttachmentInfo<C> attachment, boolean vertical) {
        int controlAlign;
        C alignControl = attachment.getControl();
        IEditPartViewer viewer = this.getHost().getViewer();
        GraphicalEditPart bindPart = (GraphicalEditPart)viewer.getEditPartByModel(alignControl);
        if (bindPart == null) {
            return;
        }
        Rectangle bounds = b.getCopy();
        Rectangle bindBounds = FormSelectionEditPolicyClassic.getControlModelBounds(alignControl);
        if (vertical) {
            bindBounds.transpose();
            bounds.transpose();
        }
        int x = (controlAlign = attachment.getAlignment()) == 16384 || controlAlign == 128 ? bindBounds.x : bindBounds.right();
        int y1 = Math.min(bindBounds.y, bounds.y);
        int y2 = Math.max(bindBounds.bottom(), bounds.bottom());
        int offset = attachment.getOffset();
        y1 -= 8;
        y2 += 8;
        if (vertical) {
            this.addHorizontalFeedbackLine(this.layoutImpl.isTop(attachment) ? "N6" : "S6", x + offset, y1, y2, this.offsetColor);
        } else {
            this.addVerticalFeedbackLine(this.layoutImpl.isLeft(attachment) ? "W6" : "E6", x + offset, y1, y2, this.offsetColor);
        }
    }

    private void addVerticalFeedbackLine(String name, int x, int y1, int y2, Color color) {
        this.selectionFeedbacks.put(name, (Figure)this.addFeedbackLine(x, y1, x, y2, color));
    }

    private void addHorizontalFeedbackLine(String name, int y, int x1, int x2, Color color) {
        this.selectionFeedbacks.put(name, (Figure)this.addFeedbackLine(x1, y, x2, y, color));
    }

    private void addLineEndFigure(String name, int x, int y, int alignment, Color color) {
        this.selectionFeedbacks.put(name, (Figure)this.addLineEndFigure(x, y, alignment, color));
    }

    private void removeSelectionFeedbacks(String prefix) {
        Iterator<String> I = this.selectionFeedbacks.keySet().iterator();
        while (I.hasNext()) {
            String key = I.next();
            if (!key.startsWith(prefix)) continue;
            Figure feedback = this.selectionFeedbacks.get(key);
            feedback.getParent().remove(feedback);
            I.remove();
        }
    }

    private Polyline addFeedbackLine(int x1, int y1, int x2, int y2, Color color) {
        Polyline line = new Polyline();
        Point p1 = new Point(x1, y1);
        this.translateModelToFeedback((Translatable)p1);
        Point p2 = new Point(x2, y2);
        this.translateModelToFeedback((Translatable)p2);
        line.addPoint(p1);
        line.addPoint(p2);
        line.setForeground(color);
        line.setLineStyle(3);
        this.addFeedback((Figure)line);
        return line;
    }

    private LineEndFigure addLineEndFigure(int x, int y, int alignment, Color color) {
        Point point = new Point(x, y);
        this.translateModelToFeedback((Translatable)point);
        LineEndFigure lineEndFigure = new LineEndFigure(alignment, color);
        Dimension size = lineEndFigure.getSize();
        lineEndFigure.setLocation(new Point(point.x - size.width / 2, point.y - size.height / 2));
        this.addFeedback((Figure)lineEndFigure);
        return lineEndFigure;
    }

    public static <C extends IControlInfo> Rectangle getControlModelBounds(C control) {
        return control.getModelBounds().getCopy();
    }

    private void translateModelToFeedback(Translatable t) {
        PolicyUtils.translateModelToFeedback((SelectionEditPolicy)this, (Translatable)t);
    }

    private void installQuadrantHandler() {
        this.mouseQuadrant = -1;
        final Figure figure = this.getHostFigure();
        this.mouseTrackListener = new IMouseTrackListener(){

            public void mouseHover(MouseEvent event) {
            }

            public void mouseExit(MouseEvent event) {
                FormSelectionEditPolicyClassic.this.mouseQuadrant = -1;
                figure.repaint();
            }

            public void mouseEnter(MouseEvent event) {
            }
        };
        this.mouseMoveListener = new IMouseMoveListener(){

            public void mouseMove(MouseEvent event) {
                int oldQuadrant = FormSelectionEditPolicyClassic.this.mouseQuadrant;
                Rectangle r = figure.getBounds().getCopy();
                FormSelectionEditPolicyClassic.this.mouseQuadrant = event.x < r.width / 2 && event.y < r.height / 2 ? 0 : (event.y < r.height / 2 ? 1 : (event.x < r.width / 2 ? 2 : 3));
                if (FormSelectionEditPolicyClassic.this.mouseQuadrant != oldQuadrant) {
                    figure.repaint();
                }
            }
        };
        this.figureListener = new IFigureListener(){

            public void figureReparent(Figure source, Figure oldParent, Figure newParent) {
            }

            public void figureMoved(Figure source) {
                Rectangle bounds = figure.getBounds();
                FormSelectionEditPolicyClassic.this.hoverFigure.setBounds(new Rectangle(0, 0, bounds.width, bounds.height));
            }
        };
        this.hoverFigure = new Figure(){

            protected void paintClientArea(Graphics graphics) {
                if (FormSelectionEditPolicyClassic.this.mouseQuadrant == -1) {
                    return;
                }
                graphics.setBackgroundColor(IColorConstants.blue);
                Rectangle bounds = figure.getBounds();
                PointList points = new PointList();
                switch (FormSelectionEditPolicyClassic.this.mouseQuadrant) {
                    case 0: {
                        points.addPoint(1, 1);
                        points.addPoint(7, 1);
                        points.addPoint(1, 7);
                        break;
                    }
                    case 1: {
                        points.addPoint(bounds.width - 1, 1);
                        points.addPoint(bounds.width - 7, 1);
                        points.addPoint(bounds.width - 1, 7);
                        break;
                    }
                    case 2: {
                        points.addPoint(1, bounds.height - 1);
                        points.addPoint(7, bounds.height - 1);
                        points.addPoint(1, bounds.height - 7);
                        break;
                    }
                    case 3: {
                        points.addPoint(bounds.width - 1, bounds.height - 1);
                        points.addPoint(bounds.width - 7, bounds.height - 1);
                        points.addPoint(bounds.width - 1, bounds.height - 7);
                        break;
                    }
                }
                graphics.fillPolygon(points);
            }
        };
        this.hoverFigure.setOpaque(false);
        Rectangle figureBounds = figure.getBounds();
        this.hoverFigure.setBounds(new Rectangle(0, 0, figureBounds.width, figureBounds.height));
        this.hoverFigure.addMouseTrackListener(this.mouseTrackListener);
        this.hoverFigure.addMouseMoveListener(this.mouseMoveListener);
        figure.add(this.hoverFigure, 0);
        figure.addFigureListener(this.figureListener);
    }

    private void uninstallQuadrantHandler() {
        this.getHostFigure().removeFigureListener(this.figureListener);
        FigureUtils.removeFigure((Figure)this.hoverFigure);
    }

    private void removeResizeFeedbacks() {
        this.removeResizeFeedback("H");
        this.removeResizeFeedback("V");
    }

    private void removeResizeFeedback(String name) {
        this.removeSingleResizeFeedback(String.valueOf(name) + "11");
        this.removeSingleResizeFeedback(String.valueOf(name) + "12");
        this.removeSingleResizeFeedback(String.valueOf(name) + "2");
        this.removeSingleResizeFeedback(String.valueOf(name) + "3");
        this.removeSingleResizeFeedback(String.valueOf(name) + "4");
        this.removeSingleResizeFeedback(String.valueOf(name) + "5");
    }

    private void removeSingleResizeFeedback(String name) {
        Figure feedback = this.resizeFeedbacks.get(name);
        if (feedback != null) {
            this.removeFeedback(feedback);
            this.resizeFeedbacks.remove(name);
        }
    }

    private void addVerticalResizeLine(String suffix, C component, int x, Color color) throws Exception {
        Rectangle bounds = FormSelectionEditPolicyClassic.getControlModelBounds(component);
        Polyline line = this.addFeedbackLine(x, bounds.y, x, bounds.bottom(), color);
        line.setLineWidth(2);
        line.setLineStyle(1);
        this.resizeFeedbacks.put("H" + suffix, (Figure)line);
    }

    private void addVerticalResizeLine(String suffix, int x, int parentHeight, Color color) {
        Polyline line = this.addFeedbackLine(x, parentHeight - 5, x, parentHeight + 5, color);
        line.setLineWidth(3);
        line.setLineStyle(1);
        this.resizeFeedbacks.put("H" + suffix, (Figure)line);
    }

    private void addVerticalResizeLine(String suffix, int x, Color color) {
        ICompositeInfo composite = this.layoutInfo.getComposite();
        int parentHeight = composite.getClientArea().height;
        Polyline line = this.addFeedbackLine(x, 0, x, parentHeight, color);
        this.resizeFeedbacks.put("H" + suffix, (Figure)line);
    }

    private void addHorizontalResizeLine(String suffix, C component, int y, Color color) throws Exception {
        Rectangle bounds = FormSelectionEditPolicyClassic.getControlModelBounds(component);
        Polyline line = this.addFeedbackLine(bounds.x, y, bounds.right(), y, color);
        line.setLineWidth(2);
        line.setLineStyle(1);
        this.resizeFeedbacks.put("V" + suffix, (Figure)line);
    }

    private void addHorizontalResizeLine(String suffix, int y, int parentWidth, Color color) {
        Polyline line = this.addFeedbackLine(parentWidth - 5, y, parentWidth + 5, y, color);
        line.setLineWidth(3);
        line.setLineStyle(1);
        this.resizeFeedbacks.put("V" + suffix, (Figure)line);
    }

    private void addHorizontalResizeLine(String suffix, int y, Color color) {
        ICompositeInfo composite = this.layoutInfo.getComposite();
        int parentWidth = composite.getClientArea().width;
        Polyline line = this.addFeedbackLine(0, y, parentWidth, y, color);
        this.resizeFeedbacks.put("V" + suffix, (Figure)line);
    }

    private FormLayoutEditPolicyClassic<C> getLayoutEditPolicy() {
        FormLayoutEditPolicyClassic editPolicy = (FormLayoutEditPolicyClassic)this.getHost().getParent().getEditPolicy((Object)"LayoutEditPolicy");
        return editPolicy;
    }

    private static boolean hasDirection(int direction, int mask) {
        return (direction & mask) == mask;
    }

    private boolean useSnap() {
        return this.getLayoutEditPolicy().useSnap();
    }

    static <C extends IControlInfo> List<C> sortControlsByAxisRange(List<C> components, final boolean isX, final int value) {
        LinkedList newControls = Lists.newLinkedList();
        newControls.addAll(components);
        Collections.sort(newControls, new Comparator<C>(){

            @Override
            public int compare(C o1, C o2) {
                Object component1 = o1;
                Object component2 = o2;
                Rectangle bounds1 = FormSelectionEditPolicyClassic.getControlModelBounds(component1);
                Rectangle bounds2 = FormSelectionEditPolicyClassic.getControlModelBounds(component2);
                if (isX) {
                    int min1 = this.min(value, bounds1.x, bounds1.right());
                    int min2 = this.min(value, bounds2.x, bounds2.right());
                    return min1 - min2;
                }
                int min1 = this.min(value, bounds1.y, bounds1.bottom());
                int min2 = this.min(value, bounds2.y, bounds2.bottom());
                return min1 - min2;
            }

            private int min(int x, int a, int b) {
                return Math.min(Math.abs(x - a), Math.abs(x - b));
            }
        });
        return newControls;
    }

    private static void setX(Rectangle r, int x) {
        r.width += r.x - x;
        r.x = x;
    }

    private static void setY(Rectangle r, int y) {
        r.height += r.y - y;
        r.y = y;
    }

    public int getMouseQuadrant() {
        return this.mouseQuadrant;
    }

    private void hideSizeHints() {
        if (this.xTextFeedback != null) {
            this.xTextFeedback.remove();
            this.xTextFeedback = null;
        }
        if (this.yTextFeedback != null) {
            this.yTextFeedback.remove();
            this.yTextFeedback = null;
        }
    }

    private final class ResizeToControlCommand
    extends EditCommand {
        private final IFormAttachmentInfo<C> attachment;
        private final C control;
        private final int offset;
        private final int position;
        final /* synthetic */ FormSelectionEditPolicyClassic this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public ResizeToControlCommand(IFormAttachmentInfo<C> attachment, C control, int position, int offset) {
            this.this$0 = (FormSelectionEditPolicyClassic)n;
            super(attachment);
            this.attachment = attachment;
            this.control = control;
            this.position = position;
            this.offset = offset;
        }

        protected void executeEdit() throws Exception {
            this.this$0.layoutImpl.resizeToControl(this.attachment, this.control, this.position, this.offset);
        }
    }

    private final class ResizeToMarginCommand
    extends EditCommand {
        private final IFormAttachmentInfo<C> attachment;
        private final int marginValue;
        private final int direction;

        private ResizeToMarginCommand(IFormAttachmentInfo<C> attachment, int direction, int marginValue) {
            super(attachment);
            this.attachment = attachment;
            this.direction = direction;
            this.marginValue = marginValue;
        }

        protected void executeEdit() throws Exception {
            FormSelectionEditPolicyClassic.this.layoutImpl.resizeToMargin(this.attachment, this.direction, this.marginValue);
        }
    }

    private final class ResizeToOffsetCommand
    extends EditCommand {
        private final int offset;
        private final IFormAttachmentInfo<C> attachment;
        private final int parentDimension;

        private ResizeToOffsetCommand(IFormAttachmentInfo<C> attachment, int parentDimension, int offset) {
            super(attachment);
            this.attachment = attachment;
            this.parentDimension = parentDimension;
            this.offset = offset;
        }

        protected void executeEdit() throws Exception {
            FormSelectionEditPolicyClassic.this.layoutImpl.resizeToOffset(this.attachment, this.parentDimension, this.offset);
        }
    }

    private final class ResizeToPercentOffsetCommand
    extends EditCommand {
        private final int offset;
        private final IFormAttachmentInfo<C> attachment;
        private final int percent;

        private ResizeToPercentOffsetCommand(IFormAttachmentInfo<C> attachment, int percent, int offset) {
            super(attachment);
            this.attachment = attachment;
            this.percent = percent;
            this.offset = offset;
        }

        protected void executeEdit() throws Exception {
            FormSelectionEditPolicyClassic.this.layoutImpl.resizeToPercentOffset(this.attachment, this.percent, this.offset);
        }
    }
}

