/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.draw2d.geometry;

import java.io.Serializable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.wb.draw2d.geometry.Rectangle;

public final class PointList
implements Translatable,
Serializable {
    private static final long serialVersionUID = 0L;
    private int[] m_points = new int[0];
    private Rectangle m_bounds;
    private int m_size;

    public PointList() {
    }

    public PointList(int size) {
        this.m_points = new int[size * 2];
    }

    public void addPoint(Point p) {
        this.addPoint(p.x, p.y);
    }

    public void addPoint(int x, int y) {
        this.m_bounds = null;
        int arrayLength = this.m_points.length;
        int usedLength = this.m_size * 2;
        if (arrayLength == usedLength) {
            int[] old = this.m_points;
            this.m_points = new int[arrayLength + 2];
            System.arraycopy(old, 0, this.m_points, 0, arrayLength);
        }
        this.m_points[usedLength] = x;
        this.m_points[usedLength + 1] = y;
        ++this.m_size;
    }

    public void insertPoint(Point p, int index) {
        this.m_bounds = null;
        if (index > this.m_size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.m_size);
        }
        int length = this.m_points.length;
        int[] old = this.m_points;
        this.m_points = new int[length + 2];
        System.arraycopy(old, 0, this.m_points, 0, index *= 2);
        System.arraycopy(old, index, this.m_points, index + 2, length - index);
        this.m_points[index] = p.x;
        this.m_points[index + 1] = p.y;
        ++this.m_size;
    }

    public void removeAllPoints() {
        this.m_bounds = null;
        this.m_size = 0;
    }

    public Point removePoint(int index) {
        this.m_bounds = null;
        if (index < 0 || index >= this.m_size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.m_size);
        }
        Point pt = new Point(this.m_points[index *= 2], this.m_points[index + 1]);
        if (index != this.m_size * 2 - 2) {
            System.arraycopy(this.m_points, index + 2, this.m_points, index, this.m_size * 2 - index - 2);
        }
        --this.m_size;
        return pt;
    }

    public void setSize(int newSize) {
        if (this.m_points.length > newSize * 2) {
            this.m_size = newSize;
            return;
        }
        int[] newArray = new int[newSize * 2];
        System.arraycopy(this.m_points, 0, newArray, 0, this.m_points.length);
        this.m_points = newArray;
        this.m_size = newSize;
    }

    public int size() {
        return this.m_size;
    }

    public int[] toIntArray() {
        if (this.m_points.length != this.m_size * 2) {
            int[] old = this.m_points;
            this.m_points = new int[this.m_size * 2];
            System.arraycopy(old, 0, this.m_points, 0, this.m_size * 2);
        }
        return this.m_points;
    }

    public PointList getCopy() {
        PointList result = new PointList(this.m_size);
        System.arraycopy(this.m_points, 0, result.m_points, 0, this.m_size * 2);
        result.m_size = this.m_size;
        result.m_bounds = null;
        return result;
    }

    public Point getFirstPoint() {
        return this.getPoint(0);
    }

    public Point getLastPoint() {
        return this.getPoint(this.m_size - 1);
    }

    public Point getMidpoint() {
        if (this.m_size % 2 == 0) {
            return this.getPoint(this.m_size / 2 - 1).getTranslated(this.getPoint(this.m_size / 2)).scale(0.5);
        }
        return this.getPoint(this.m_size / 2);
    }

    public Point getPoint(int index) {
        if (index < 0 || index >= this.m_size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.m_size);
        }
        return new Point(this.m_points[index *= 2], this.m_points[index + 1]);
    }

    public Point getPoint(Point p, int index) {
        if (index < 0 || index >= this.m_size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.m_size);
        }
        p.x = this.m_points[index *= 2];
        p.y = this.m_points[index + 1];
        return p;
    }

    public void setPoint(Point pt, int index) {
        if (index < 0 || index >= this.m_size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.m_size);
        }
        this.m_bounds = null;
        this.m_points[index * 2] = pt.x;
        this.m_points[index * 2 + 1] = pt.y;
    }

    public Rectangle getBounds() {
        if (this.m_bounds != null) {
            return this.m_bounds;
        }
        this.m_bounds = new Rectangle();
        if (this.m_size > 0) {
            this.m_bounds.setLocation(this.m_points[0], this.m_points[1]);
            int coordinateCount = this.m_size * 2;
            int i = 0;
            while (i < coordinateCount) {
                this.m_bounds.union(this.m_points[i], this.m_points[i + 1]);
                i += 2;
            }
        }
        return this.m_bounds;
    }

    public void performTranslate(int x, int y) {
        if (x == 0 && y == 0) {
            return;
        }
        if (this.m_bounds != null) {
            this.m_bounds.performTranslate(x, y);
        }
        int i = 0;
        while (i < this.m_size * 2) {
            int n = i;
            this.m_points[n] = this.m_points[n] + x;
            int n2 = i + 1;
            this.m_points[n2] = this.m_points[n2] + y;
            i += 2;
        }
    }

    public void performScale(double factor) {
        int i = 0;
        while (i < this.m_points.length) {
            this.m_points[i] = (int)Math.floor((double)this.m_points[i] * factor);
            ++i;
        }
        this.m_bounds = null;
    }
}

