/*******************************************************************************
 * Copyright (c) 2011 Google, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Google, Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.wb.internal.core.model.description.rules;

import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.helpers.DescriptionHelper;

import org.apache.commons.digester3.Rule;
import org.xml.sax.Attributes;

/**
 * The {@link Rule} that sets model class for {@link ComponentDescription}.
 *
 * @author scheglov_ke
 * @coverage core.model.description
 */
public final class ModelClassRule extends Rule {
  ////////////////////////////////////////////////////////////////////////////
  //
  // Rule
  //
  ////////////////////////////////////////////////////////////////////////////
  @Override
  public void begin(String namespace, String name, Attributes attributes) throws Exception {
    // prepare model Class
    String className = attributes.getValue("class");
    Class<?> modelClass = DescriptionHelper.loadModelClass(className);
    // set model Class
    ComponentDescription componentDescription = (ComponentDescription) getDigester().peek();
    componentDescription.setModelClass(modelClass);
  }
}