/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester3;

import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.digester3.Rule;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMethodRule
extends Rule {
    protected String methodName = null;
    protected String paramTypeName = null;
    protected Class<?> paramType;
    protected boolean useExactMatch = false;
    protected boolean fireOnBegin = false;

    public AbstractMethodRule(String methodName) {
        this(methodName, (String)null);
    }

    public AbstractMethodRule(String methodName, Class<?> paramType) {
        this(methodName, paramType.getName());
        this.paramType = paramType;
    }

    public AbstractMethodRule(String methodName, String paramTypeName) {
        this.methodName = methodName;
        this.paramTypeName = paramTypeName;
    }

    public boolean isExactMatch() {
        return this.useExactMatch;
    }

    public void setFireOnBegin(boolean fireOnBegin) {
        this.fireOnBegin = fireOnBegin;
    }

    public boolean isFireOnBegin() {
        return this.fireOnBegin;
    }

    public void setExactMatch(boolean useExactMatch) {
        this.useExactMatch = useExactMatch;
    }

    @Override
    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        if (this.fireOnBegin) {
            this.invoke();
        }
    }

    @Override
    public void end(String namespace, String name) throws Exception {
        if (!this.fireOnBegin) {
            this.invoke();
        }
    }

    private void invoke() throws Exception {
        Object child = this.getChild();
        Object parent = this.getParent();
        if (this.getDigester().getLogger().isDebugEnabled()) {
            if (parent == null) {
                this.getDigester().getLogger().debug((Object)String.format("[%s]{%s} Call [NULL PARENT].%s(%s)", this.getClass().getSimpleName(), this.getDigester().getMatch(), this.methodName, child));
            } else {
                this.getDigester().getLogger().debug((Object)String.format("[%s]{%s} Call %s.%s(%s)", this.getClass().getSimpleName(), this.getDigester().getMatch(), parent.getClass().getName(), this.methodName, child));
            }
        }
        Class[] paramTypes = new Class[]{this.paramType != null ? this.getDigester().getClassLoader().loadClass(this.paramTypeName) : child.getClass()};
        if (this.useExactMatch) {
            MethodUtils.invokeExactMethod((Object)parent, (String)this.methodName, (Object[])new Object[]{child}, (Class[])paramTypes);
        } else {
            MethodUtils.invokeMethod((Object)parent, (String)this.methodName, (Object[])new Object[]{child}, (Class[])paramTypes);
        }
    }

    protected abstract Object getChild();

    protected abstract Object getParent();

    public final String toString() {
        return String.format("%s[methodName=%s, paramType=%s, paramTypeName=%s, useExactMatch=%s, fireOnBegin=%s]", this.getClass().getSimpleName(), this.methodName, this.paramType, this.paramTypeName, this.useExactMatch, this.fireOnBegin);
    }
}

