/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.databinding.ui.contentproviders.el;

import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.wb.internal.core.databinding.ui.editor.ICompleteListener;
import org.eclipse.wb.internal.core.databinding.ui.editor.IUiContentProvider;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.swing.databinding.ui.contentproviders.el.ElPropertyUiConfiguration;
import org.eclipse.wb.internal.swing.databinding.ui.contentproviders.el.EvalutionLanguageConfiguration;
import org.eclipse.wb.internal.swing.databinding.ui.contentproviders.el.IBeanPropertiesSupport;

public abstract class ElPropertyUiContentProvider
implements IUiContentProvider,
IBeanPropertiesSupport {
    private final ElPropertyUiConfiguration m_configuration;
    private ICompleteListener m_listener;
    private boolean m_enabled;
    private String m_errorMessage;
    private Label m_titleLabel;
    protected SourceViewer m_sourceViewer;
    private final IDocument m_document = new Document();

    public ElPropertyUiContentProvider(ElPropertyUiConfiguration configuration) {
        this.m_configuration = configuration;
    }

    protected final String getText() {
        return this.m_document.get();
    }

    protected final void setText(String text) {
        this.m_document.set(text);
    }

    protected final void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
        if (this.m_titleLabel != null) {
            this.m_titleLabel.setEnabled(this.m_enabled);
        }
        if (this.m_sourceViewer != null) {
            this.m_sourceViewer.getControl().setEnabled(this.m_enabled);
        }
    }

    public void setCompleteListener(ICompleteListener listener) {
        this.m_listener = listener;
    }

    public String getErrorMessage() {
        return this.m_errorMessage;
    }

    protected final void setErrorMessage(String message) {
        this.m_errorMessage = message;
        if (this.m_listener != null) {
            this.m_listener.calculateFinish();
        }
    }

    public int getNumberOfControls() {
        return 2;
    }

    public void createContent(Composite parent, int columns) {
        this.m_titleLabel = new Label(parent, 0);
        GridDataFactory.create((Control)this.m_titleLabel).alignHF();
        this.m_titleLabel.setText(this.m_configuration.getTitle());
        this.m_titleLabel.setEnabled(this.m_enabled);
        this.m_sourceViewer = new SourceViewer(parent, null, 2048);
        GridDataFactory.create((Control)this.m_sourceViewer.getControl()).spanH(columns - 1).hintVC(this.m_configuration.getRows()).fill();
        new EvalutionLanguageConfiguration(this.m_sourceViewer, this.m_document, this.m_configuration, this);
        this.m_sourceViewer.getControl().setEnabled(this.m_enabled);
    }
}

