/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.widgets;

import com.google.common.collect.Maps;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.wb.core.eval.AstEvaluationEngine;
import org.eclipse.wb.core.eval.EvaluationContext;
import org.eclipse.wb.core.eval.InvocationEvaluatorInterceptor;
import org.eclipse.wb.internal.core.model.util.PlaceholderUtils;
import org.eclipse.wb.internal.core.model.util.ScriptUtils;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swt.model.ModelMessages;
import org.eclipse.wb.internal.swt.support.ContainerSupport;
import org.eclipse.wb.internal.swt.support.ControlSupport;

public final class SwtInvocationEvaluatorInterceptor
extends InvocationEvaluatorInterceptor {
    public Object evaluate(EvaluationContext context, ClassInstanceCreation expression, ITypeBinding typeBinding, Class<?> clazz, Constructor<?> actualConstructor, Object[] arguments) throws Exception {
        if (SwtInvocationEvaluatorInterceptor.isControl(actualConstructor)) {
            return this.evaluateSWT(context, expression, clazz, actualConstructor, arguments);
        }
        if (ReflectionUtils.isSuccessorOf(clazz, (String)"org.eclipse.jface.viewers.ComboBoxCellEditor") && actualConstructor.getParameterTypes().length >= 2 && arguments[1] == null) {
            arguments[1] = new String[0];
        }
        return AstEvaluationEngine.UNKNOWN;
    }

    private Object evaluateSWT(EvaluationContext context, ClassInstanceCreation expression, Class<?> clazz, Constructor<?> actualConstructor, Object[] arguments) throws Exception {
        PlaceholderUtils.clear((ASTNode)expression);
        Object parent = arguments[0];
        int style = (Integer)arguments[1];
        try {
            return SwtInvocationEvaluatorInterceptor.tryToCreate(actualConstructor, arguments);
        }
        catch (Throwable e) {
            context.addException((ASTNode)expression, e);
            PlaceholderUtils.addException((ASTNode)expression, (Throwable)e);
            if (parent == null) {
                throw new DesignerException(2005, new String[0]);
            }
            Class<?> parentType = actualConstructor.getParameterTypes()[0];
            Constructor defaultConstructor = ReflectionUtils.getConstructor(clazz, (Class[])new Class[]{parentType, Integer.TYPE});
            if (defaultConstructor != null && !ReflectionUtils.equals(actualConstructor, (Constructor)defaultConstructor)) {
                try {
                    return SwtInvocationEvaluatorInterceptor.tryToCreate(defaultConstructor, parent, style);
                }
                catch (Throwable e2) {
                    context.addException((ASTNode)expression, e2);
                    PlaceholderUtils.addException((ASTNode)expression, (Throwable)e2);
                }
            }
            PlaceholderUtils.markPlaceholder((ASTNode)expression);
            return SwtInvocationEvaluatorInterceptor.createPlaceholder(clazz, parent, style);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static Object tryToCreate(Constructor<?> actualConstructor, Object ... arguments) throws Exception {
        parent = arguments[0];
        if (parent == null) {
            return actualConstructor.newInstance(arguments);
        }
        oldChildrenCount = ContainerSupport.getChildren(parent).length;
        try {
            return actualConstructor.newInstance(arguments);
        }
        catch (Throwable e) {
            newChildren = ContainerSupport.getChildren(parent);
            i = oldChildrenCount;
            ** while (i < newChildren.length)
        }
lbl-1000:
        // 1 sources

        {
            newChild = newChildren[i];
            ControlSupport.dispose(newChild);
            ++i;
            continue;
        }
lbl15:
        // 1 sources

        throw ReflectionUtils.getExceptionToThrow((Throwable)e);
    }

    private static boolean isControl(Constructor<?> constructor) {
        Class<?>[] parameters = constructor.getParameterTypes();
        Class<?> clazz = constructor.getDeclaringClass();
        return ReflectionUtils.isSuccessorOf(clazz, (String)"org.eclipse.swt.widgets.Control") && parameters.length >= 2 && ReflectionUtils.isSuccessorOf(parameters[0], (String)"org.eclipse.swt.widgets.Composite") && parameters[1] == Integer.TYPE;
    }

    private static Object createPlaceholder(Class<?> clazz, Object parent, int style) throws Exception {
        String message = MessageFormat.format(ModelMessages.SwtInvocationEvaluatorInterceptor_placeholderText, CodeUtils.getShortClass((String)clazz.getName()));
        ClassLoader classLoader = parent.getClass().getClassLoader();
        String script = CodeUtils.getSource((String[])new String[]{"import org.eclipse.swt.SWT;", "import org.eclipse.swt.graphics.Color;", "import org.eclipse.swt.widgets.*;", "import org.eclipse.swt.layout.FillLayout;", "", "composite = new Composite(parent, SWT.NONE);", "composite.setLayout(new FillLayout());", "", "label = new Label(composite, SWT.WRAP | SWT.CENTER);", "label.setText(message);", "label.setBackground(new Color(null, 0xFF, 0xCC, 0xCC));", "", "return composite;"});
        TreeMap variables = Maps.newTreeMap();
        variables.put("parent", parent);
        variables.put("message", message);
        return ScriptUtils.evaluate((ClassLoader)classLoader, (String)script, (Map)variables);
    }

    public Object evaluateAnonymous(EvaluationContext context, ClassInstanceCreation expression, ITypeBinding typeBinding, ITypeBinding typeBindingConcrete, IMethodBinding methodBinding, Object[] arguments) throws Exception {
        if (SwtInvocationEvaluatorInterceptor.isViewerCreation_withControl(typeBindingConcrete, arguments) || SwtInvocationEvaluatorInterceptor.isControlCreation_withParentStyle(typeBindingConcrete, arguments)) {
            String stubClassName = AstNodeUtils.getFullyQualifiedName((ITypeBinding)typeBindingConcrete, (boolean)true);
            Class<?> stubClass = context.getClassLoader().loadClass(stubClassName);
            Constructor constructor = ReflectionUtils.getConstructorForArguments(stubClass, (Object[])arguments);
            if (constructor != null) {
                return constructor.newInstance(arguments);
            }
        }
        return AstEvaluationEngine.UNKNOWN;
    }

    private static boolean isViewerCreation_withControl(ITypeBinding typeBinding, Object[] arguments) {
        return AstNodeUtils.isSuccessorOf((ITypeBinding)typeBinding, (String)"org.eclipse.jface.viewers.Viewer") && arguments.length == 1 && ReflectionUtils.isSuccessorOf((Object)arguments[0], (String)"org.eclipse.swt.widgets.Control");
    }

    private static boolean isControlCreation_withParentStyle(ITypeBinding typeBinding, Object[] arguments) {
        boolean isControl = AstNodeUtils.isSuccessorOf((ITypeBinding)typeBinding, (String)"org.eclipse.swt.widgets.Control");
        boolean isViewer = AstNodeUtils.isSuccessorOf((ITypeBinding)typeBinding, (String)"org.eclipse.jface.viewers.Viewer");
        return (isControl || isViewer) && arguments.length >= 2 && ReflectionUtils.isSuccessorOf((Object)arguments[0], (String)"org.eclipse.swt.widgets.Composite") && ReflectionUtils.isSuccessorOf((Object)arguments[1], (String)"int");
    }
}

