/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public class ClassLoaderLocalMap
implements Opcodes {
    private static final String NAME = "GEN$$ClassLoaderProperties";
    private static final Map<Object, Object> globalMap = Collections.synchronizedMap(new WeakHashMap());
    private static Method defineMethod;
    private static Method findLoadedClass;

    static {
        try {
            defineMethod = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            defineMethod.setAccessible(true);
            findLoadedClass = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
            findLoadedClass.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containsKey(ClassLoader cl, Object key) {
        if (cl == null) {
            return globalMap.containsKey(key);
        }
        ClassLoader classLoader = cl;
        synchronized (classLoader) {
            block5: {
                if (ClassLoaderLocalMap.hasHolder(cl)) break block5;
                return false;
            }
            return ClassLoaderLocalMap.getLocalMap(cl).containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void put(ClassLoader cl, Object key, Object value) {
        if (cl == null) {
            globalMap.put(key, value);
            return;
        }
        ClassLoader classLoader = cl;
        synchronized (classLoader) {
            ClassLoaderLocalMap.getLocalMap(cl).put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object get(ClassLoader cl, Object key) {
        if (cl == null) {
            return globalMap.get(key);
        }
        ClassLoader classLoader = cl;
        synchronized (classLoader) {
            return ClassLoaderLocalMap.getLocalMap(cl).get(key);
        }
    }

    private static boolean hasHolder(ClassLoader cl) {
        String propertiesClassName = NAME;
        try {
            Class clazz = (Class)findLoadedClass.invoke((Object)cl, propertiesClassName);
            return clazz != null;
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
    }

    private static Map<Object, Object> getLocalMap(ClassLoader cl) {
        Class holderClass;
        String holderClassName = NAME;
        try {
            holderClass = (Class)findLoadedClass.invoke((Object)cl, holderClassName);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
        if (holderClass == null) {
            byte[] classBytes = ClassLoaderLocalMap.buildHolderByteCode(holderClassName);
            try {
                holderClass = (Class)defineMethod.invoke((Object)cl, holderClassName, classBytes, 0, classBytes.length);
            }
            catch (InvocationTargetException e1) {
                throw new RuntimeException(e1.getTargetException());
            }
            catch (Throwable e1) {
                throw new RuntimeException(e1);
            }
        }
        try {
            return (Map)holderClass.getDeclaredField("localMap").get(null);
        }
        catch (Throwable e1) {
            throw new RuntimeException(e1);
        }
    }

    private static byte[] buildHolderByteCode(String holderClassName) {
        ClassWriter cw = new ClassWriter(0);
        cw.visit(46, 33, holderClassName, null, "java/lang/Object", null);
        FieldVisitor fv = cw.visitField(25, "localMap", "Ljava/util/Map;", null, null);
        fv.visitEnd();
        MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, "java/util/WeakHashMap");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/util/WeakHashMap", "<init>", "()V");
        mv.visitFieldInsn(179, holderClassName, "localMap", "Ljava/util/Map;");
        mv.visitInsn(177);
        mv.visitMaxs(2, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }
}

