/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.util;

import java.util.List;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.draw2d.geometry.Dimension;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.core.model.util.grid.GridConvertionHelper;
import org.eclipse.wb.internal.core.utils.GenericsUtils;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.state.GlobalState;

public final class AbsoluteLayoutCreationFlowSupport {
    private AbsoluteLayoutCreationFlowSupport() {
    }

    public static void apply(IAbstractComponentInfo container, List<? extends IAbstractComponentInfo> childrenComponents, IAbstractComponentInfo component, Point newLocation, Dimension newSize) throws Exception {
        Assert.isTrue(childrenComponents.contains(component));
        Assert.isNotNull(newLocation);
        AbsoluteLayoutCreationFlowSupport.checkBounds(component, newLocation, newSize);
        List<GridConvertionHelper.ComponentGroup> columns = GridConvertionHelper.buildGroups(childrenComponents, true);
        List<GridConvertionHelper.ComponentGroup> rows = GridConvertionHelper.buildGroups(childrenComponents, false);
        GridConvertionHelper.sortGroupsByTranspose(columns, rows);
        GridConvertionHelper.sortGroupsByTranspose(rows, columns);
        GridConvertionHelper.sortGroups(columns);
        GridConvertionHelper.sortGroups(rows);
        GridConvertionHelper.updateBoundsGaps(columns, false);
        GridConvertionHelper.updateBoundsGaps(rows, false);
        IAbstractComponentInfo nextControl = AbsoluteLayoutCreationFlowSupport.getReferenceComponent(rows, component);
        if (nextControl != GenericsUtils.getNextOrNull(childrenComponents, component)) {
            GlobalState.getOrderProcessor().move(component, nextControl);
        }
    }

    public static void checkBounds(IAbstractComponentInfo component, Point location, Dimension size) {
        Rectangle bounds;
        size = size == null ? ((bounds = component.getModelBounds()) != null ? bounds.getSize() : new Dimension(1, 1)) : size.getCopy();
        component.setModelBounds(new Rectangle(location.getCopy(), size));
    }

    private static IAbstractComponentInfo getReferenceComponent(List<GridConvertionHelper.ComponentGroup> rows, IAbstractComponentInfo component) {
        boolean componentArrived = false;
        for (GridConvertionHelper.ComponentGroup row : rows) {
            for (GridConvertionHelper.ComponentInGroup componentInGroup : row.getComponents()) {
                if (componentArrived) {
                    return componentInGroup.getComponent();
                }
                if (componentInGroup.getComponent() != component) continue;
                componentArrived = true;
            }
        }
        return null;
    }
}

