/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.structure.components;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.wb.core.editor.IDesignPageSite;
import org.eclipse.wb.core.model.HasSourcePosition;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.DesignPageSite;
import org.eclipse.wb.internal.core.editor.Messages;
import org.eclipse.wb.internal.core.editor.structure.IPage;
import org.eclipse.wb.internal.core.editor.structure.components.ComponentsTreeWrapper;
import org.eclipse.wb.internal.core.gefTree.EditPartFactory;
import org.eclipse.wb.internal.core.model.ObjectReferenceInfo;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.gef.EditPartsSelectionProvider;
import org.eclipse.wb.internal.core.utils.ui.UiUtils;
import org.eclipse.wb.internal.gef.tree.TreeViewer;

public final class ComponentsTreePage
implements IPage {
    private TreeViewer m_viewer;
    private IEditPartViewer m_graphicalViewer;
    private ObjectInfo m_rootObject;
    private final ISelectionChangedListener m_selectionListener_Tree = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            ComponentsTreePage.this.selectGraphicalViewer();
        }
    };
    private final ISelectionChangedListener m_selectionListener_Graphical = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            ComponentsTreePage.this.selectTreeViewer();
        }
    };

    @Override
    public void dispose() {
        Control control = this.getControl();
        if (control != null && !control.isDisposed()) {
            control.dispose();
        }
    }

    @Override
    public void createControl(Composite parent) {
        this.m_viewer = new TreeViewer(parent, 770);
        this.m_viewer.addSelectionChangedListener(this.m_selectionListener_Tree);
    }

    @Override
    public Control getControl() {
        return this.m_viewer.getControl();
    }

    @Override
    public void setFocus() {
        this.getControl().setFocus();
    }

    @Override
    public void setToolBar(IToolBarManager toolBarManager) {
        Action action = new Action(){

            public void run() {
                UiUtils.expandAll(ComponentsTreePage.this.m_viewer.getTree());
            }
        };
        toolBarManager.add((IAction)action);
        action.setImageDescriptor(DesignerPlugin.getImageDescriptor("expand_all.gif"));
        action.setToolTipText(Messages.ComponentsTreePage_expandAllAction);
        action = new Action(){

            public void run() {
                UiUtils.collapseAll(ComponentsTreePage.this.m_viewer.getTree());
            }
        };
        toolBarManager.add((IAction)action);
        action.setImageDescriptor(DesignerPlugin.getImageDescriptor("collapse_all.gif"));
        action.setToolTipText(Messages.ComponentsTreePage_collapseAllAction);
        toolBarManager.update(false);
    }

    private void selectTreeViewer() {
        List<EditPart> selectedEditParts = this.m_graphicalViewer.getSelectedEditParts();
        ComponentsTreePage.setSelection(this.m_viewer, this.m_selectionListener_Tree, selectedEditParts);
        ComponentsTreePage.showComponentDefinition(selectedEditParts);
    }

    private void selectGraphicalViewer() {
        final List<EditPart> selectedEditParts = this.m_viewer.getSelectedEditParts();
        ExecutionUtils.runLog(new RunnableEx(){

            @Override
            public void run() throws Exception {
                boolean[] refreshFlag = new boolean[1];
                if (!selectedEditParts.isEmpty()) {
                    for (EditPart editPart : selectedEditParts) {
                        ObjectInfo objectInfo = (ObjectInfo)editPart.getModel();
                        objectInfo.getBroadcastObject().selecting(objectInfo, refreshFlag);
                    }
                } else {
                    ComponentsTreePage.this.m_rootObject.getBroadcastObject().selecting(null, refreshFlag);
                }
                if (refreshFlag[0]) {
                    ComponentsTreePage.this.m_graphicalViewer.removeSelectionChangedListener(ComponentsTreePage.this.m_selectionListener_Graphical);
                    try {
                        ComponentsTreePage.this.m_rootObject.refresh();
                    }
                    finally {
                        ComponentsTreePage.this.m_graphicalViewer.addSelectionChangedListener(ComponentsTreePage.this.m_selectionListener_Graphical);
                    }
                }
            }
        });
        ComponentsTreePage.setSelection(this.m_graphicalViewer, this.m_selectionListener_Graphical, selectedEditParts);
        ComponentsTreePage.showComponentDefinition(selectedEditParts);
    }

    private static void setSelection(IEditPartViewer targetViewer, ISelectionChangedListener selectionListener, List<EditPart> sourceEditParts) {
        ArrayList targetEditParts = Lists.newArrayList();
        for (EditPart sourceEditPart : sourceEditParts) {
            EditPart targetEditPart;
            Object model = sourceEditPart.getModel();
            if (model instanceof ObjectReferenceInfo) {
                model = ((ObjectReferenceInfo)model).getObject();
            }
            if ((targetEditPart = targetViewer.getEditPartByModel(model)) == null) continue;
            targetEditParts.add(targetEditPart);
        }
        targetViewer.removeSelectionChangedListener(selectionListener);
        try {
            targetViewer.setSelection(targetEditParts);
        }
        finally {
            targetViewer.addSelectionChangedListener(selectionListener);
        }
    }

    private static void showComponentDefinition(List<EditPart> sourceEditParts) {
        ObjectInfo objectInfo;
        EditPart primaryEditPart;
        IPreferenceStore preferences = DesignerPlugin.getPreferences();
        if (preferences.getBoolean("editor.gotoComponentDefinitionOnSelection") && !sourceEditParts.isEmpty() && (primaryEditPart = sourceEditParts.get(sourceEditParts.size() - 1)).getModel() instanceof ObjectInfo && (objectInfo = (ObjectInfo)primaryEditPart.getModel()) instanceof HasSourcePosition) {
            HasSourcePosition hasSourcePosition = (HasSourcePosition)primaryEditPart.getModel();
            int position = hasSourcePosition.getSourcePosition();
            IDesignPageSite.Helper.getSite(objectInfo).showSourcePosition(position);
        }
    }

    public TreeViewer getTreeViewer() {
        return this.m_viewer;
    }

    public void setInput(IEditPartViewer editPartViewer, ObjectInfo rootObject) {
        this.m_rootObject = rootObject;
        if (this.m_graphicalViewer != null) {
            this.m_graphicalViewer.removeSelectionChangedListener(this.m_selectionListener_Graphical);
        }
        this.m_graphicalViewer = editPartViewer;
        this.m_graphicalViewer.addSelectionChangedListener(this.m_selectionListener_Graphical);
        this.m_viewer.setEditDomain(this.m_graphicalViewer.getEditDomain());
        this.m_viewer.setEditPartFactory(EditPartFactory.INSTANCE);
        this.m_viewer.setContextMenu(this.m_graphicalViewer.getContextMenu());
        if (this.m_rootObject != null) {
            DesignPageSite site = DesignPageSite.Helper.getSite(this.m_rootObject);
            site.setComponentsTree(new ComponentsTreeWrapper(this.m_viewer));
        }
        this.m_viewer.removeSelectionChangedListener(this.m_selectionListener_Tree);
        try {
            this.m_viewer.setInput(this.m_rootObject);
        }
        finally {
            this.m_viewer.addSelectionChangedListener(this.m_selectionListener_Tree);
        }
    }

    public ISelectionProvider getSelectionProvider() {
        return new EditPartsSelectionProvider(this.m_viewer);
    }
}

