/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.commons.compress.utils;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 * Re-implements {@link FilterInputStream#close()} to do nothing.
 *
 * @since 1.14
 * @deprecated Use {@link org.apache.commons.io.input.CloseShieldInputStream}.
 */
@Deprecated
public class CloseShieldFilterInputStream extends FilterInputStream {

    /**
     * Creates a {@code CloseShieldFilterInputStream} by assigning the argument {@code in} to the field {@code this.in} so as to remember it for later use.
     *
     * @param in the underlying input stream, or {@code null} if this instance is to be created without an underlying stream.
     */
    public CloseShieldFilterInputStream(final InputStream in) {
        super(in);
    }

    @Override
    public void close() throws IOException {
        // NO IMPLEMENTATION.
    }
}
