import type { Connection } from '@volar/language-server';
import { URI } from 'vscode-uri';
import { GetLanguagePlugin } from './lib/hybridModeProject';
export declare const connection: Connection;
export declare const server: {
    connection: Connection;
    fs: import("@volar/language-server").FileSystem;
    initializeParams: import("@volar/language-server").InitializeParams;
    initializeResult: import("@volar/language-server").VolarInitializeResult;
    languageServicePlugins: import("@volar/language-server").LanguageServicePlugin[];
    project: import("@volar/language-server").LanguageServerProject;
    pullModelDiagnostics: boolean;
    documents: import("@volar/language-server").TextDocuments<import("@volar/language-server/node").SnapshotDocument>;
    workspaceFolders: Map<import("vscode-uri").URI, boolean>;
    getSyncedDocumentKey: (uri: import("vscode-uri").URI) => string | undefined;
    initialize: (initializeParams: import("@volar/language-server").InitializeParams, project: import("@volar/language-server").LanguageServerProject, languageServicePlugins: import("@volar/language-server").LanguageServicePlugin[], options?: {
        pullModelDiagnostics?: boolean;
    }) => import("@volar/language-server").VolarInitializeResult;
    initialized: () => void;
    shutdown: () => void;
    watchFiles: (patterns: string[]) => void;
    getConfiguration: <T>(section: string, scopeUri?: string) => Promise<T | undefined>;
    onDidChangeConfiguration: (cb: import("@volar/language-server").NotificationHandler<import("@volar/language-server").DidChangeConfigurationParams>) => {
        dispose(): void;
    };
    onDidChangeWatchedFiles: (cb: import("@volar/language-server").NotificationHandler<import("@volar/language-server").DidChangeWatchedFilesParams>) => {
        dispose: () => void;
    };
    clearPushDiagnostics: () => void;
    refresh: (projects: import("@volar/language-server").LanguageServerProject) => Promise<void>;
};
export declare const getLanguagePlugins: GetLanguagePlugin<URI>;
